/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef SOLIDHPP
#define SOLIDHPP

#include "vertex.h"

// something for us to edit
class SolidClass : public ObjectClass
{
public:
  VertexClass* P; // origin index point
  unsigned X,Y,Z;    // number of elements in each axis
  unsigned Xb;
  int Element;  // size of each element as exponent of 2 : eg 0 = 1, 1 = 2, -1 = 0.5
  char* Vol;   // storage of solid
  SolidClass();
  ~SolidClass();
  void CreateVolume(fixed,fixed,fixed);
  bool State(int,int,int);
};

#define SOLID ((SolidClass*)object)

// base class for creator of any object based on objectclass
class SolidControlClass : public Object3DControlClass
{
public:
  SolidControlClass();
  virtual ObjectClass* Create();
  virtual void Remove(ObjectClass*);
  virtual void NewForOld(ObjectClass*,ObjectClass*,ObjectClass*);
  virtual long Size();
  virtual bool Match(ObjectClass*,BlockClass*,LayerClass*);
  virtual bool DependantOn(ObjectClass*,ObjectClass*);
  void GetOtherVertex(VTX*,ObjectClass*);
  virtual bool Include(ObjectClass*,int,int,int,int);
  virtual bool Inside(ObjectClass*,int,int);
  virtual int GetProperty(ObjectClass*,int n, void** p, char** name,
                            void**); // returns type or -1 for fail
  virtual int Summary(ObjectClass*,char*,int,int=0);
  virtual int SetProperty(ObjectClass*,int n, void* p); // -1 for fail
  virtual void GetRealLimits(ObjectClass*, fixed&,fixed&,fixed&,fixed&,fixed&,fixed&);
  virtual bool GetLimits(ObjectClass*,int&,int&,int&,int&,int&,int&);
  virtual void SetLimits(ObjectClass*,int,int,int,int);
  virtual void Draw(BITMAP*,ObjectClass*);
  virtual void Indicate(BITMAP*,ObjectClass*,int,int,int,int,int,int);
};

extern SolidControlClass SolidControl;

#endif
