/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "obj3ctrl.h"
#include "vertex.h"
#include "line.h"
#include "arc.h"
#include "spline.h"
#include "solid.h"
#include "face.h"
#include "insert.h"
Object3DControlClass* ControlClasses[] =
              { &VertexControl,
                &FaceControl,&InsertControl,
                &LineControl, &ArcControl, &SplineControl,
                &SolidControl,
                NULL };
// ControlClasses[] needs to be set to something usefull before Init_Controller is reached

// CONTROL_TYPES is defined in obj3ctrl.h but copied here for reference - must match ControlClasses
// enum CONTROL_TYPES { VERTEX_CONTROL =0, FACE_CONTROL,
//                      INSERT_CONTROL, LINE_CONTROL, ARC_CONTROL, SPLINE_CONTROL };

bool Object3DControlClass::Match(ObjectClass* obj, BlockClass* block) {
   AllLayers = true;
   bool rtn = Match(obj,block,NULL);
   AllLayers = false;
   return rtn;
}

/*
bool NullBlock = TRUE;

void SetBlockMatch(BlockClass* b)
{
  NullBlock = (b == NULL);
  LinkClass* link = BlockList.FirstLink();
  while(link)
  { BlockClass* block = (BlockClass*)(link->Object);
    block->MatchFlag = (block == b);
    link = link->NextLink();
  }
}

bool NullLayer = TRUE;   // default layer is null - so this flag when it's selected

void SetLayerMatch(LayerClass* l)
{
  NullLayer = (l == NULL);
  LinkClass* link = LayerList.FirstLink();
  while(link)
  { LayerClass* layer = (LayerClass*)(link->Object);
    layer->MatchFlag = (layer == l);
    link = link->NextLink();
  }
}

void SetAllLayer()
{
  NullLayer = TRUE;
  LinkClass* link = LayerList.FirstLink();
  while(link)
  { LayerClass* layer = (LayerClass*)(link->Object);
    layer->MatchFlag = 1;   // can't use TRUE because MatchFlag is unsigned char
    link = link->NextLink();
  }
}

bool ObjectInclude(VertexClass* p)
{
  if(p->Block)
  { if(!p->Block->MatchFlag);
      return(FALSE);
  }
  else if(!NullBlock)
    return(FALSE);
  if(p->Layer)
    if(!p->Layer->MatchFlag)
      return(FALSE);
  else if(!NullLayer)
    return(FALSE);
  return(TRUE);
}
*/

bool Object3DControlClass::GetLimits(ObjectClass* object,int& x, int& y, int& w, int& h)
{  // this style still required for VisualLinkClass::Update()
  int z, d;
  return(GetLimits(object,x,y,z,w,h,d));
}

