/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "view.h"

/* Intented for use with avi frame advance to manualy log positions into a file
   It is up to the data user to copy the file POSLOG.txt elsewhere before next use
*/

float LFx[26];
float LFy[26];
float LFz[26];
bool Log_Item_Used[26];
bool Log_Frame_Started = false;
int LogCount = 0;

void LogMousePos(int index)
{
  if(index <0 || index > 25)
    return;
  VTX pos;
  int view = Get_Real(mouse_x,mouse_y,&pos);
  if(view < 0) // not within the bounds of a view
    return;
  LFx[index] = fixtof(pos.X);
  LFy[index] = fixtof(pos.Y);
  LFz[index] = fixtof(pos.Z);
  if(!Log_Frame_Started)
  { for(int i = 0; i < 26; i++)
      Log_Item_Used[i] = false;
    Log_Frame_Started = true;
  }
  Log_Item_Used[index] = true;
}

int LogSave()
{ FILE* logfile;
  if(Log_Frame_Started == false)
    return 0;   // nothing to log
  Log_Frame_Started = false;  // set to flag next entry
  if(LogCount == 0)
    logfile = fopen("POSLOG.TXT","w");
  else
    logfile = fopen("POSLOG.TXT","a");
  if(!logfile)
    return 1;   // can't open file to save
  fprintf(logfile,"DATA FRAME %d",LogCount);
  LogCount++;
  int fc[4];
  Get_Frame_Number(fc);
  for(int v = 0; v < 4; v++)
  { if(fc[v] >= 0)
      fprintf(logfile,"[VISUAL %d FRAME %d]",v,fc[v]);
  }
  fprintf(logfile,"\n");
  for(int i = 0; i < 26; i++)
  { if(Log_Item_Used[i])
      fprintf(logfile,"ITEM: %c X: %f Y: %f Z: %f\n",'A'+i,LFx[i],LFy[i],LFz[i]);
  }
  fclose(logfile);
}

