/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "layset.h"
#include <string.h>
#include "xproc.h"
#include "stdio.h"
#include "layers.h"
#include "view.h"
#include "help.h"

// globals for select editor
char Layer_Str[NCHAR];
char* Layers_Selected = NULL;  // only to be used by Select_Editor
unsigned char* Layer_Flag = NULL;
DIALOG* Layer_List_dlg = NULL;
int Layer_List_Pntr; // used to detect change in list selection point

LinkClass* Link; // used in define macro below but defined here so compiler knows about it
// previously I had an link called 'l' here and another in a function argument and the
// compiler didn't complain.
#define BEGIN_LAYERLIST Link = LayerList.FirstLink(); while(Link) {
#define END_LAYERLIST   Link = Link->NextLink(); }

int Get_Layer_Selected()
{
  if(!Layers_Selected)
    return(-1);
  unsigned i = 0;
  int j = 0;
  BEGIN_LAYERLIST
    Layers_Selected[i] = Link->Selected;
    if(Layers_Selected[i])
      j++;
    LayerClass* layer = (LayerClass*)Link->Object;
    for(int v = 0; v < 4; v++) {
      Layer_Flag[layer->ID*4 + v] = layer->ViewFlags[v];
    }
    i++;
  END_LAYERLIST
  return(j);
}

void Set_Layer_Selected()
{
  if(!Layers_Selected)
    return;
  unsigned i = 0;
  BEGIN_LAYERLIST
    Link->Selected = Layers_Selected[i];
    LayerClass* layer = (LayerClass*)Link->Object;
    for(int v = 0; v < 4; v++) {
      layer->ViewFlags[v] = Layer_Flag[layer->ID*4 + v];
    }
    i++;
  END_LAYERLIST
}

int Layer_Adder(void)
{
  LayerClass* layer = new LayerClass();
  if(layer) {
    LayerList.Add(layer);
    Layers_Selected = (char*)realloc(Layers_Selected,Layers);
    Layer_Flag = (unsigned char*)realloc(Layer_Flag,Layers*4);  // by 4 visuals
    if(Layers_Selected && Layer_Flag) {
      Get_Layer_Selected();
      memset(Layers_Selected,0,Layers);
      Layers_Selected[Layers-1] = true;
      for(int v = 0; v < 4; v++)
        Layer_Flag[layer->ID*4 + v] = layer->ViewFlags[v];
    }
    Action_Layer = layer;
  }
  return D_REDRAW;
}

/* delete (but don't put in the clipboard unless shift key) the selection */
int Layer_Deleter(void)
{ if(Layers_Selected)
  { Set_Layer_Selected();
    int j = 0;
    for(int s = 0; s < Layers; s++)
    { if(Layers_Selected[s]) {
        // if action_layer is removed then set to NULL
        LinkClass* link = LayerList.Find(s);
        if(link) {
          LayerClass* layer = (LayerClass*)link->Object;
          int user = TargetList->DependantOn(layer);
          if(user >= 0) {
            char str[6];
            sprintf(str,"Layer ID%d is being used by object #%d",layer->ID,user);
            billalert("Sorry, can't delete Layer",str,"is being used","&Ok", NULL, 'o', 0);
            link->Selected = false; // prevents Delete_Selected from working below
          } else {
            if(layer == Action_Layer)
              Action_Layer = NULL;
            j++;
          }
        }
      }
      if(j && s+j < Layers)
        Layers_Selected[s] = Layers_Selected[s+j];
    }
    Layers -= j;
  }
  LayerList.Delete_Selected();
  return D_REDRAW;
}

/* getter for the list of the objects of the dialog
 *  this formats a string with the sproc and the id_params
*/

char *Select_Layer_Getter(int index, int *size)
{ if(index < 0)
  { *size = Layers;
    return(NULL);
  }
  if(Layer_List_dlg->d1 != Layer_List_Pntr && Layer_List_dlg->d1 >= 0 && Layer_List_dlg->d1 < Layers)
  { if(key_shifts & KB_CTRL_FLAG)
      Layers_Selected[Layer_List_dlg->d1] = TRUE;
    else if(key_shifts & KB_SHIFT_FLAG)
      Layers_Selected[Layer_List_dlg->d1] = FALSE;
    else
    { for(int i = 0; i < Layers; i++)
        Layers_Selected[i] = FALSE;
        Layers_Selected[Layer_List_dlg->d1] = TRUE;
    }
    Layer_List_Pntr = Layer_List_dlg->d1;
  }
  char check, actc;
  char flag_str[9];
  int i = 0;
  BEGIN_LAYERLIST
    if(i == index)
    { if(Layers_Selected[i])
        check = '*';  // show original selection
      else
        check = ' ';
      LayerClass* layer = (LayerClass*)Link->Object;
      int j = 0;
      for(int v = 0; v < 4; v++)
      { if(!(Menu_View[TL_VIEW+v].flags & D_DISABLED)) {   // see view.cpp
          if(Layer_Flag[layer->ID*4+v] & LAYER_VIEW_HIDE)
            flag_str[j++] = 'H';
          else
            flag_str[j++] = 'S';     // H for hide
          if(Layer_Flag[layer->ID*4+v] & LAYER_VIEW_FILTER)
            flag_str[j++] = 'F';
          else
            flag_str[j++] = 'I';   // I for include
        } else {
          flag_str[j++] = '.';
          flag_str[j++] = '.';
        }
      }
      flag_str[j] = 0;
      if(layer == Action_Layer)
        actc = 'A';
      else
        actc = ' ';
      const char* name = layer->Name;
      if(name == NULL)
        name = "NONAME";
      usprintf(Layer_Str, "%c%3d:%s %c %-32.32s",check,layer->ID,flag_str,actc,name);
      break;
    }
    i++;
  END_LAYERLIST
  return Layer_Str;
}

int Select_All_Layers()
{
  LayerList.Select_All();
  Get_Layer_Selected();
  return D_REDRAW;
}

int Select_No_Layers()
{
  LayerList.Select_None();
  Get_Layer_Selected();
  return D_REDRAW;
}
int Invert_Layer_Selection()
{
  LayerList.Invert_Selection();
  Get_Layer_Selected();
  return D_REDRAW;
}

int Shift_Layer_Down()
{ if(Layer_List_dlg)
  { LinkClass* l = LayerList.Find(Layer_List_dlg->d1);
    if(l)
    { if(LayerList.Demote(l))
        Layer_List_dlg->d1++;
    }
  }
  Get_Layer_Selected();
  return D_REDRAW;
}

int Shift_Layer_Up()
{ if(Layer_List_dlg)
  { LinkClass* l = LayerList.Find(Layer_List_dlg->d1);
    if(l)
    { if(LayerList.Promote(l))
        Layer_List_dlg->d1--;
    }
  }
  Get_Layer_Selected();
  return D_REDRAW;
}

int Select_Action_Layer()
{ int i = 0;
  BEGIN_LAYERLIST
    if(Layers_Selected && Layers_Selected[i])
      Action_Layer = (LayerClass*)Link->Object;
    if(active_dialog[1].d1 == i++)
    { Action_Layer = (LayerClass*)Link->Object;
      break;
    }
  END_LAYERLIST
  return D_REDRAW;
}

void Change_Layer_Flags(unsigned char mask, unsigned char flags)
{ if(Layers_Selected)
  { int i = 0;
    BEGIN_LAYERLIST
      if(Layers_Selected[i++])
      { LayerClass* layer = (LayerClass*)Link->Object;
        for(int v = 0; v < 4; v++) {
          if(active_dialog[4+v].flags & D_SELECTED)
            Layer_Flag[layer->ID*4 + v] = (Layer_Flag[layer->ID*4 + v] & mask) | flags;
        }
      }
    END_LAYERLIST
  }
}

int Show_Selected_Layer()
{ Change_Layer_Flags(LAYER_VIEW_HIDE_MASK,0);
  return D_REDRAW;
}

int Hide_Selected_Layer()
{ Change_Layer_Flags(LAYER_VIEW_HIDE_MASK,LAYER_VIEW_HIDE);
  return D_REDRAW;
}

int Filter_Selected_Layer()
{ Change_Layer_Flags(LAYER_VIEW_FILTER_MASK,LAYER_VIEW_FILTER);
  return D_REDRAW;
}

int Include_Selected_Layer()
{ Change_Layer_Flags(LAYER_VIEW_FILTER_MASK,0);
  return D_REDRAW;
}

#include "tostring.h"
#include "alcolor.h"

int Call_Layer_Prop_Help()
{
  Get_Help("LAYER PROPERTY EDITOR");
  return D_OK;
}

/* pop up a dialog to edit the LayerProperties of a DIALOG object */
int Layer_Properties(void)
{
    int i, j, res;
    int ssize = NCHAR/uwidth_max(U_CURRENT) - 1;
    char* name;
    int tempcolor;
    char cstr[20];

    // Find the first selected object
    i = 0;
    BEGIN_LAYERLIST
      if(Link->Selected)
        break;
      i++;
    END_LAYERLIST
    if(!Link)
      return D_O_K;  // no Link
    LayerClass* layer = (LayerClass*)(Link->Object);
    sprintf(Layer_Str,"Edit Layer ID #%d",layer->ID);
    name = new char[ssize];
    if(layer->Name)
      strcpy(name,layer->Name);
    else
      name[0] = 0;  // null str
    sprintf(cstr,"%d",layer->Color);
    tempcolor = layer->Color;

    DIALOG layer_dlg[] =
{
   /* (proc)            (x)  (y) (w)  (h) (fg) (bg) (key) (flags) (d1) (d2) (dp)              (dp2)           (dp3)              */
   { d_billwin_proc,    0,   0,  352, 88, 0,   0,   0,    0,      0,   0,   (void*)Layer_Str, NULL,           NULL              },
   { d_billtext_proc,   8,   20, 144, 8,  0,   0,   0,    0,      0,   0,   (void*)"Name:",   NULL,           NULL              },
   { Xedit_proc,        48,  16, 296, 16, 0,   0,   0,    0,      9,   0,   name,             NULL,           NULL              },
   { d_billtext_proc,   8,   40, 144, 8,  0,   0,   0,    0,      0,   0,   (void*)"Color:",  NULL,           NULL              },
   { Xedit_proc,        64,  40, 120, 16, 0,   0,   13,   0,      0,   0,   cstr,             Color_Selecter, (void*)&tempcolor },
   { d_billcheck_proc,  200, 40, 8,   8,  0,   0,   0,    0,      0,   0,   (void*)"Force",   NULL,           NULL              },
   { d_billbutton_proc, 56,  64, 48,  16, 0,   0,   13,   D_EXIT, 0,   0,   (void*)"OK",      NULL,           NULL              },
   { d_billbutton_proc, 112, 64, 72,  16, 0,   0,   27,   D_EXIT, 0,   0,   (void*)"Cancel",  NULL,           NULL              },
   { Xbutton_proc,      300, 64, 48,  16, 0,   0,   '?',  D_EXIT, 0,   0,   (void*)"Help&?",  Call_Layer_Prop_Help,   NULL      },
   { NULL,              0,   0,  0,   0,  0,   0,   0,    0,      0,   0,   NULL,             NULL,           NULL              }
};
    if(layer->Force_Color)
      layer_dlg[5].flags |= D_SELECTED;
    set_dialog_color(layer_dlg, gui_fg_color, gui_bg_color);
    centre_dialog(layer_dlg);
    res = popup_dialog(layer_dlg, -1);

    // Get data back to object
    if(res == 6) { // OK
      if(layer->Name)
        delete(layer->Name);
      if(name[0] > 32)
        layer->Name = name;   // retained in memory - deleted with ~Layer()
      else
        layer->Name = NULL;
      layer->Color = (int)strtol(cstr,NULL,10);
      layer->Force_Color = ((layer_dlg[5].flags & D_SELECTED)!= 0);
    } else {  // assume cancel
      delete name;
    }
    return D_REDRAW;
}

int Sel_Layer_Properties()
{
  int i = 0;
  // select only Link pointed to by list
  BEGIN_LAYERLIST
    Link->Selected = (i == Layer_List_dlg->d1);
    i++;
  END_LAYERLIST
  return(Layer_Properties());
}

int Call_Edit_Layer_Help()
{
  Get_Help("LAYER LIST EDITOR");
  return D_OK;
}

/* edit the list of selected layers */
int Layer_Editer(void)
{
    DIALOG_PLAYER *pl;

    // create array selected
    Layers_Selected = (char*)malloc(Layers);  // selected is a global - see above SelectAll
    Layer_Flag = (unsigned char*)malloc(Layers*4);  // by 4 visuals
    Get_Layer_Selected();

    DIALOG sel_dlg[] =
{
   /* (proc)            (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1)       (d2) (dp)                     (dp2)                   (dp3) */
   { d_billwin_proc,    0,   0,   400, 240, 0,   0,   0,    0,      0,         0,   (void*)"Select Layer",   NULL,                   NULL },
   { d_billlist_proc,   8,   24,  344, 148, 0,   0,   0,    D_EXIT, 0,         0,   Select_Layer_Getter,     NULL,                   NULL },
   { d_keyboard_proc,   0,   0,   0,   0,   0,   0,   0,    0,      KEY_SPACE, 0,   Sel_Layer_Properties,    NULL,                   NULL },
   { d_billtext_proc,   8,   180, 48,  12,  0,   0,   0,    0,      0,         0,   (void*)"Visuals:",       NULL,                   NULL },
   { d_billcheck_proc,  84,  180, 8,   8,   0,   0,   0,    0,      0,         0,   (void*)"#1",             NULL,                   NULL },
   { d_billcheck_proc,  120, 180, 8,   8,   0,   0,   0,    0,      0,         0,   (void*)"#2",             NULL,                   NULL },
   { d_billcheck_proc,  156, 180, 8,   8,   0,   0,   0,    0,      0,         0,   (void*)"#3",             NULL,                   NULL },
   { d_billcheck_proc,  188, 180, 8,   8,   0,   0,   0,    0,      0,         0,   (void*)"#4",             NULL,                   NULL },
   { Xbutton_proc,      312, 172, 48,  16,  0,   0,   '?',  D_EXIT, 0,         0,   (void*)"Help&?",         Call_Edit_Layer_Help,   NULL },
   { Xbutton_proc,      80,  196, 48,  16,  0,   0,   'a',  D_EXIT, 0,         0,   (void*)"&All",           Select_All_Layers,      NULL },
   { Xbutton_proc,      80,  216, 48,  16,  0,   0,   'n',  D_EXIT, 0,         0,   (void*)"&None",          Select_No_Layers,       NULL },
   { Xbutton_proc,      136, 196, 64,  16,  0,   0,   'i',  D_EXIT, 0,         0,   (void*)"&Invert",        Invert_Layer_Selection, NULL },
   { Xbutton_proc,      136, 216, 64,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Action",         Select_Action_Layer,    NULL },
   { Xbutton_proc,      206, 196, 40,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Show",           Show_Selected_Layer,    NULL },
   { Xbutton_proc,      206, 216, 40,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Hide",           Hide_Selected_Layer,    NULL },
   { Xbutton_proc,      254, 196, 50,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Filter",         Filter_Selected_Layer,  NULL },
   { Xbutton_proc,      254, 216, 50,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Include",        Include_Selected_Layer, NULL },
   { Xbutton_proc,      312, 196, 40,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Add",            Layer_Adder,            NULL },
   { Xbutton_proc,      312, 216, 40,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Del",            Layer_Deleter,          NULL },
   { Xbutton_proc,      360, 196, 32,  16,  0,   0,   'u',  D_EXIT, 0,         0,   (void*)"/\\",            Shift_Layer_Up,         NULL },
   { Xbutton_proc,      360, 216, 32,  16,  0,   0,   'd',  D_EXIT, 0,         0,   (void*)"\\/",            Shift_Layer_Down,       NULL },
   { d_keyboard_proc,   0,   0,   0,   0,   0,   0,   0,    0,      KEY_DEL,   0,   Layer_Deleter,           NULL,                   NULL },
   { d_billbutton_proc, 8,   216, 64,  16,  0,   0,   13,   D_EXIT, 0,         0,   (void*)"OK",             NULL,                   NULL },
   { d_billbutton_proc, 8,   196, 64,  16,  0,   0,   13,   D_EXIT, 0,         0,   (void*)"Cancel",         NULL,                   NULL },
   { NULL,              0,   0,   0,   0,   0,   0,   0,    0,      0,         0,   NULL,                    NULL,                   NULL }
};
    for(int v = 0; v < 4; v++)
    { if(Menu_View[TL_VIEW+v].flags & D_DISABLED)    // see view.cpp
        sel_dlg[4+v].flags |= D_DISABLED;
      else if(Visual[v].Linked == Current_Visual->Linked)
        sel_dlg[4+v].flags |= D_SELECTED;
    }
    centre_dialog(sel_dlg);
    set_dialog_color(sel_dlg, gui_fg_color, gui_bg_color);
    pl = init_dialog(sel_dlg, 1);
    Layer_List_Pntr = sel_dlg[1].d1 = -1;   // no particular selection
    Layer_List_dlg = &sel_dlg[1];

    bool dialog_exit;
    do
    {
      dialog_exit = update_dialog(pl);
      if(dialog_exit == FALSE && pl->obj == 1)  // list
      { pl->res |= Sel_Layer_Properties();
        dialog_exit = TRUE;
      }
    }
    while(dialog_exit);

    int res = shutdown_dialog(pl);
    if(res == 22)  // OK
      Set_Layer_Selected();
    FREE(Layers_Selected);
    FREE(Layer_Flag);
    Layer_List_dlg = NULL;
    return D_REDRAW;
}

