/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef FINDVISUHPP
#define FINDVISUHPP

#include <allegro.h>
#include "visulist.h"
#include "vertex.h"
#include "line.h"
#include "arc.h"
#include "spline.h"
#include "blocks.h"
#include "layers.h"
#include "obj3ctrl.h"

VertexClass* FindorMakeVertex(fixed,fixed,fixed,BlockClass*,LayerClass*);
BlockClass*  FindorMakeBlock(char*);
unsigned CountMatchingObject(Object3DControlClass*,BlockClass*,LayerClass*);
VisualLinkClass* FirstMatchingObject(Object3DControlClass* control, BlockClass* block, LayerClass* layer);
VisualLinkClass* NextMatchingObject(VisualLinkClass* l,Object3DControlClass* control,
                   BlockClass* block, LayerClass* layer);
int FindMatchingVertex(VertexClass*,BlockClass*,LayerClass*);
VertexClass* FindMatchingVertex(unsigned p,BlockClass*,LayerClass*);
int FindMatchingLine(LineClass*,BlockClass*,LayerClass*);
LineClass* FindMatchingLine(unsigned p,BlockClass*,LayerClass*);
void DrawVisu(BITMAP* bmp, BlockClass* block = NULL);
void ScanLimits(fixed& x1, fixed& y1, fixed& z1, fixed& x2, fixed& y2, fixed& z2);

#endif
