/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef FACEHPP
#define FACEHPP

#include "vertex.h"
#include "texture.h"

#define FACES_DOUBLE_SIDED_FLAG 1

extern int Face_Default_Colors[];
extern char Face_Default_Texture_Name[];
extern char Face_Default_Flags;

class FaceClass : public ObjectClass
{
public:
  VertexClass* P1;
  VertexClass* P2;
  VertexClass* P3;
  VertexClass* P4;
  int C1, C2, C3, C4;
  TextureClass* Texture;
  unsigned Flags;

  FaceClass();
};

class FacetClass {  // see FaceClass::Render(), also used in Render.cpp
public:
  FaceClass* Face;
  fixed X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3,X4,Y4,Z4;
  long Far_Z;
  FacetClass* NextFacet;

  FacetClass(FaceClass*,long);
};

extern FacetClass* FirstFacet;

#define FACE ((FaceClass*)object)

// base class for creator of any object based on objectclass
class FaceControlClass : public Object3DControlClass
{
public:
  FaceControlClass();
  virtual ObjectClass* Create();
  virtual void NewForOld(ObjectClass*,ObjectClass*,ObjectClass*);
  virtual long Size();
  virtual bool Match(ObjectClass*,BlockClass*,LayerClass*);
  virtual bool Include(ObjectClass*,int,int,int,int);
  virtual bool Inside(ObjectClass*,int,int);
  virtual int  Distance(ObjectClass*,int,int);
  virtual bool DependantOn(ObjectClass*,ObjectClass*);
  virtual int GetProperty(ObjectClass*,int n, void** p, char** name,
                            void**); // returns type or -1 for fail
  virtual int Summary(ObjectClass*,char*,int,int=0);
  virtual int SetProperty(ObjectClass*,int n, void* p); // -1 for fail
  virtual void GetRealLimits(ObjectClass*, fixed&,fixed&,fixed&,fixed&,fixed&,fixed&);
  virtual bool GetLimits(ObjectClass*,int&,int&,int&,int&,int&,int&);
  virtual void SetLimits(ObjectClass*,int,int,int,int);
  virtual void Draw(BITMAP*,ObjectClass*);
          void Render(ObjectClass*);  // unique to face
  virtual void Indicate(BITMAP*,ObjectClass*,int,int,int,int,int,int);
};

extern FaceControlClass FaceControl;

#endif
