/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "dxfsave.h"
#include "findvisu.h"
#include "drawline.h"

extern unsigned char Mode;  //  = 0; // already defined in dxfload - other compilers might disagree
extern PACKFILE* packedfile; // = NULL;
extern FILE* file; // = NULL;
#define MAXSTRING 256
BYTE Precision= 3;

/*  // function not needed - leave in case this changes
int DxWUnsigned(unsigned u)
{ unsigned n = u;
  switch(Mode)
  { case 0:
      return(pack_fwrite(&n,2,packedfile) != 2);
    case 1:
      return(fprintf(file,"%-3u\n",n) == 0);
    case 2:
      return(fwrite(&n,1,2,file) != 2);
  }
}
*/

int DxWInt(int i)
{ int n = i;
  switch(Mode)
  { case 0:
      return(pack_fwrite(&n,2,packedfile) != 2);
    case 1:
      return(fprintf(file,"%-3d\r\n",n) == 0);
    case 2:
      return(fwrite(&n,1,2,file) != 2);
  }
}

int DxWFixed(fixed fx)
{ switch(Mode)
  { case 0:
      return(pack_fwrite(&fx,sizeof(fixed),packedfile) != sizeof(fixed));
    case 1:
      return(fprintf(file,"%.*f\r\n",Precision,fixtof(fx)) == 0);
    case 2:
      double n = fixtof(fx);
      return(fwrite(&n,1,8,file) != 8);
  }
}

int DxWString(char* str)
{
  int size = ustrlen(str); // + 1;
  char* buf = new char[size];
  char* s = uconvert(str,U_CURRENT,buf,U_ASCII,size-1);
  int ret = 0;
  if(!Mode)
    ret = (pack_fwrite(s,size,packedfile) != size);
  else
  { if(size > MAXSTRING)
      size = MAXSTRING;
    ret = (fwrite(s,1,size,file) != size);
    if(Mode == 2) {
      char c = 0;
      fwrite(&c,1,1,file);  // binary strings are null terminated
    }
    else if(Mode == 1)   // ascii terminated with carrige return
      fprintf(file,"\r\n");
  }
  if(buf)
    delete buf;
  return(ret);
}

int WGroup(int group, int i)
{ return(DxWInt(group) || DxWInt(i));
}

int WGroup(int group, unsigned i)
{ return(DxWInt(group) || DxWInt(i));
}

int WGroup(int group, fixed f)
{ return(DxWInt(group) || DxWFixed(f));
}

int WGroup(int group, double f)
{ return(DxWInt(group) || DxWFixed(ftofix(f)));
}

int WGroup(int group, char* str)
{
  if(DxWInt(group))
    return(1);
  return(DxWString(str));
}

int WEntityLayer(LayerClass* layer, int levnum)
{ if(layer && layer->Name)
    WGroup(8,layer->Name);
  else
  { char lstr[20];
    sprintf(lstr,"L#%d",levnum);  // levnum may not be the same as layer->ID
    WGroup(8,lstr);
  }
  // levnum for layer=NULL should be zero to indicate base layer
}

#include "vertex.h"
#include "line.h"
#include "arc.h"
#include "spline.h"
#include "face.h"
#include "insert.h"

int Save_DX_Entities(BlockClass* block)
{
  int levnum = 0;
  LayerClass* layer = NULL;  // do null (ie default layer) first
  LinkClass* layerlink = NULL;
  WGroup(0,"SECTION");
  WGroup(2,"ENTITIES");
  do
  {
    OBJECT_CONTROL_TYPES type = FACE_CONTROL;  // skip vertex
    Object3DControlClass* control;
    while((control = ControlClasses[type]))
    { VisualLinkClass* link = FirstMatchingObject(control,block,layer);
      while(link)
      { ObjectClass* object = link->Object;
        switch(type)
        { case FACE_CONTROL: // 3Dface
            WGroup(0,"3DFACE");
            WEntityLayer(layer,levnum);
            WGroup(10,FACE->P1->Pos.X);
            WGroup(20,FACE->P1->Pos.Y);
            WGroup(30,FACE->P1->Pos.Z);
            WGroup(11,FACE->P2->Pos.X);
            WGroup(21,FACE->P2->Pos.Y);
            WGroup(31,FACE->P2->Pos.Z);
            WGroup(12,FACE->P3->Pos.X);
            WGroup(22,FACE->P3->Pos.Y);
            WGroup(32,FACE->P3->Pos.Z);
            WGroup(13,FACE->P4->Pos.X);
            WGroup(23,FACE->P4->Pos.Y);
            WGroup(33,FACE->P4->Pos.Z);
            break;
          case INSERT_CONTROL: // Insert
            WGroup(0,"INSERT");
            WEntityLayer(layer,levnum);
            // assumes block has been given name - see Save_DXF
            WGroup(2,INSERT->InsertBlock->Name);
            WGroup(10,INSERT->P1->Pos.X);
            WGroup(20,INSERT->P1->Pos.Y);
            WGroup(30,INSERT->P1->Pos.Z);
            WGroup(41,INSERT->Sx);
            WGroup(42,INSERT->Sy);
            WGroup(43,INSERT->Sz);
            WGroup(50,INSERT->Rz*360/256);
            WGroup(51,INSERT->Rx*360/256);  // not part of AutoCad format
            WGroup(52,INSERT->Ry*360/256);  // dito - hopefully disregard
            break;
          case LINE_CONTROL: // line
          case ARC_CONTROL:  // arc - treat as line for the moment *************
          case SPLINE_CONTROL: // splines are treated as normal lines for present
            WGroup(0,"LINE");
            WEntityLayer(layer,levnum);
            if(LINE->Type != BYLAYER_LINE)
              WGroup(6,Line_Type_String[LINE->Type]);  // LINE type
            WGroup(10,LINE->P1->Pos.X);
            WGroup(20,LINE->P1->Pos.Y);
            WGroup(30,LINE->P1->Pos.Z);
            WGroup(11,LINE->P2->Pos.X);
            WGroup(21,LINE->P2->Pos.Y);
            WGroup(31,LINE->P2->Pos.Z);
            break;
        }
        link = NextMatchingObject(link,control,block,layer);
      }
      ((int)type)++;
    }
    if(layerlink)
      layerlink = layerlink->NextLink();
    else
      layerlink = LayerList.FirstLink();
    if(layerlink)
      layer = (LayerClass*)(layerlink->Object);
    levnum++;
  } while(layer);
  WGroup(0,"ENDSEC");
}

const char* DXFBinaryStr = "AutoCAD Binary DXF\r\n\x1A\x00";

int Save_DXF(unsigned char mode, unsigned char precision = 0)
{ Mode= mode;
  // as seen from the W* functions above, a 0 (Packed Binary DXF) mode does exist but is only
  // included because I started it and don't feel like erasing it.
  // use DXB or A3D instead.
  Precision = precision;
  if(mode == 1)   // binary DXF doesn't accept comments
  { if(WGroup(999,"File saved by AlCad.exe (Allegro CAD) Orginally programmed by R.Parker 2001"))
      return(1);
  }
  else if(mode == 2)
  { if(fwrite(DXFBinaryStr,1,20,file) != 20)
      return(1);
  }
// 1. HEADER section - General information about the drawing is found
//   in this section of the DXF file. Nothing specific to the content.

  if(Mode)  // header only needed for AutoCad compatiblity
  { WGroup(0,"SECTION");
      WGroup(2,"HEADER");
        WGroup(9,"$ACADVER");
          WGroup(1,"AC1006");
        WGroup(9,"$INSBASE");
          WGroup(10,0);
          WGroup(20,0);
          WGroup(30,0);
    fixed x1,y1,z1,x2,y2,z2;
    ScanLimits(x1,y1,z1,x2,y2,z2);
        WGroup(9,"$EXTMIN");  // top left
          WGroup(10,x1);
          WGroup(20,y1);
          WGroup(30,z1);
        WGroup(9,"$EXTMAX");  // bottom right
          WGroup(10,x2);
          WGroup(20,y2);
          WGroup(30,z2);
    WGroup(0,"ENDSEC");
  }

// 2. TABLES section - This section contains definitions of named items.

  WGroup(0,"SECTION");
    WGroup(2,"TABLES");
// Linetype table (LTYPE)
    if(Mode)   // ADX files don't need line types
    { WGroup(0,"TABLE");
        WGroup(2,"LTYPE");
          WGroup(70,1);
          for(LINETYPE l = SOLID_LINE; l < LINETYPES; ((int)l)++)
          { WGroup(0,"LTYPE");
            WGroup(2,Line_Type_String[l]);
            WGroup(70,64);
            WGroup(3,"Standard AlCad line type");
            WGroup(72,65);
            if(line_masks[l] = 0xFFFFFFFF)    // solid line
            { WGroup(73,0);   // number of dashs
              WGroup(40,0.0); // total length
            }
            else // attempt to convert linetype in drawline.cpp to autocad line type
            { char o = 1;
              char l = 0;
              WGroup(73,6); // as for dash dot dot
              WGroup(40,0.32);
              for(int i = 0; i < 33; i++, l++)
              { if(i == 32 || ((line_masks[l]>>i) & 1)^o)
                { o ^= 1;
                  WGroup(49,(float)l/100.0);
                  l = 0;
                }
              }
            }
          }
      WGroup(0,"ENDTAB");
    }
//  Layer table (LAYER)
    WGroup(0,"TABLE");
      WGroup(2,"LAYER");
        WGroup(70,Layers);
        LinkClass* layerlink = LayerList.FirstLink();
        int layernum = 1;
        while(layerlink)
        { LayerClass* layer = (LayerClass*)(layerlink->Object);
          WGroup(0,"LAYER");
            if(layer->Name)
              WGroup(2,layer->Name);
            else
            { char str[20];
              sprintf(str,"L#%d",layernum);
              WGroup(2,str);
            }
            WGroup(70,64);
            WGroup(62,layer->Color);
            WGroup(6,Line_Type_String[layer->LineType]);
          layerlink = layerlink->NextLink();
          layernum++;
        }
    WGroup(0,"ENDTAB");
//  Text Style table (STYLE)
    if(Mode)
    { WGroup(0,"TABLE");
      WGroup(2,"STYLE");
        WGroup(70,0);
      WGroup(0,"ENDTAB");
    }
// View table (VIEW)
// User Coordinate System table (UCS)
// Viewport configuration table (VPORT)
// Dimension Style table (DIMSTYLE)
// Application Identification table (APPID)
  WGroup(0,"ENDSEC");
// 3. BLOCKS section - This section contains Block Definition entities
//   describing the entities that make up each Block in the drawing.
  LinkClass* blocklink = BlockList.FirstLink();
  int blocknum = 1;
  if(blocklink)
  { WGroup(0,"SECTION");
    WGroup(2,"BLOCKS");
    while(blocklink)
    { BlockClass* block = (BlockClass*)(blocklink->Object);
      WGroup(0,"BLOCK");
      if(!block->Name)   // if no name then give it one
      { block->Name = new char[10];
        sprintf(block->Name,"B#%d",blocknum);
      }
      WGroup(2,block->Name);
      WGroup(70,0);
      WGroup(10,block->Base.X);
      WGroup(20,block->Base.Y);
      WGroup(30,block->Base.Z);
      Save_DX_Entities(block);
      blocklink = blocklink->NextLink();
      blocknum++;
      WGroup(0,"ENDBLK");
    }
    WGroup(0,"ENDSEC");
  }
  
//4. ENTITIES section - This section contains the drawing entities,
//   including any Block References.
  Save_DX_Entities(NULL);
// 5. END OF FILE
  WGroup(0,"EOF");
}

int Save_DXF_Packed(char* path)
{
  char* errorstr = "PACKED SAVE ERROR";
  packedfile = pack_fopen(path,"wp");
  if(!packedfile)
  { billalert(errorstr,path,"Couldn't open file for writing","&Ok",NULL,'o',0);
    return(1);
  }
  int errorcode = Save_DXF(0);
  if(errorcode)
  { char errortype[32];
    sprintf(errortype,"Code:%3d",errorcode);
    billalert(errorstr,errortype,"in Save_DXF","&Ok",NULL,'o',0);
    pack_fclose(packedfile);
    return(1);
  }
  pack_fclose(packedfile);
  return(0);
}

int Save_DXF_ASCII(char* path)
{
  // should prompt for floating point precision here
  unsigned char precision = 3;
  char* errorstr = "ASCII SAVE ERROR";
  file = fopen(path,"w");
  if(!file)
  { billalert(errorstr,path,"Couldn't open file for writing.","&Ok",NULL,'o',0);
    return(1);
  }
  precision = 6;
  switch(billalert3("ASCII SAVE","Select floating point precision?","Decimal places:",
                          "&1","&3","&6",'1','3','6'))
  { case 1:
      precision = 1;
      break;
    case 2:
      precision = 3;
      break;
    case 3:
      precision = 6;
      break;
  }
  int errorcode = Save_DXF(1,precision);
  if(errorcode)
  { char errortype[32];
    sprintf(errortype,"Code:%3d",errorcode);
    billalert(errorstr,errortype,"in Save_DXF","&Ok",NULL,'o',0);
    fclose(file);
    return(1);
  }
  fclose(file);
  return(0);
}

int Save_DXF_Binary(char* path)
{
  char* errorstr = "BINARY SAVE ERROR";
  file = fopen(path,"wb");
  if(!file)
  { billalert(errorstr,path,"Couldn't open file for writing.","&Ok",NULL,'o',0);
    return(1);
  }
  if(fwrite("AutoCAD Binary DXF\r\n\x1A\x00",1,22,file) != 22)
  { billalert(errorstr,path,"Couldn't write tag to file.","&Ok",NULL,'o',0);
    fclose(file);
    return(1);
  }
  int errorcode = Save_DXF(2);
  if(errorcode)
  { char errortype[32];
    sprintf(errortype,"Code:%3d",errorcode);
    billalert(errorstr,errortype,"in Save_DXF","&Ok",NULL,'o',0);
    fclose(file);
    return(1);
  }
  fclose(file);
  return(0);
}

