/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "dxfload.h"
#include "linklist.h"

unsigned char Mode = 0;
PACKFILE* packedfile = NULL;
FILE* file = NULL;
#define MAXSTRING 256
unsigned DXFLineCount = 1;

int GetUnpackedString(char* str, int maxstring = MAXSTRING)
{
  char c;
  int sp = 0;
  int fc = 0;
  // skip empty lines and spaces
  do
  { if(fread(&c,1,1,file) != 1)
      return(1);
    // WordPad only interprets CR as a new line
    if(c == '\r' || c == 0)   // Context interprets 0's as new lines
      DXFLineCount++;
    if(c == EOF)
      break;
  } while(c <= ' ');   // terminates at start of real word
  str[fc++] = c;
  do
  { if(fread(&c,1,1,file) != 1)
      return(1);
    if(c == EOF)
      break;
    if(fc < maxstring)
      str[fc++] = c;
  } while(c >= ' ');   // terminates on null or newline etc.
  str[fc -1] = 0;  // null terminate
  return(0);
}

int DxRInt(int* i)
{ char buf[20];
  DXFLineCount++;
  switch(Mode)
  { case 0:
      return(pack_fread(i,2,packedfile) != 2);
    case 1:
      if(GetUnpackedString(buf,20))
        return(2);
      if(sscanf(buf,"%d",i) == 0)
        return(3);
      break;
    case 2:
      if(fread(i,1,2,file) != 2);
        return(4);
      break;
  }
  return(0);
}

int DxRFixed(fixed* fx)
{ double d;
  char buf[20];
  DXFLineCount++;
  switch(Mode)
  { case 0:
      return(pack_fread(fx,sizeof(fixed),packedfile) != sizeof(fixed));
    case 1:
      if(GetUnpackedString(buf,20))
        return(2);;
      if(sscanf(buf,"%lf",&d) == 0)
        return(3);
      break;
    case 2:
      if(fread(&d,1,8,file) != 8)
        return(4);
      break;
  }
  *fx = ftofix(d);
  return(0);
}

int DxRString(char* str, int maxstring = MAXSTRING)
{ char buf[MAXSTRING];
  DXFLineCount++;
  if(!(Mode))
  { if(!pack_fgets(buf,MAXSTRING,packedfile))
      return(1);
  }
  else if(GetUnpackedString(buf,maxstring))
    return(2);
  char* s = uconvert(buf,U_ASCII,str,U_CURRENT,maxstring);
  if(s != str)
    ustrncpy(str,buf,maxstring);
  return(0);
}

int group = 0;
void* pntr = NULL;
TYPE_ID type;

int RGroup()
{ bool repeat;
  do {
  repeat = false;
  if(DxRInt(&group))
    return(1);
  if(group == 999)
    repeat = true;
  if(group < 10)
    type = STRING_TYPE;
  else if(group < 60)
    type = FLOAT_TYPE;
  else if(group < 80)
    type = INT_TYPE;
  else if(group < 140)
    type = UNKNOWN_TYPE;
  else if(group < 148)
    type = FLOAT_TYPE;
  else if(group < 170)
    type = UNKNOWN_TYPE;
  else if(group < 176)
    type = INT_TYPE;
  else if(group < 210)
    type = UNKNOWN_TYPE;
  else if(group < 240)
    type = FLOAT_TYPE;
  else if(group < 999)
    type = UNKNOWN_TYPE;
  else if(group < 1010)
    type = STRING_TYPE;
  else if(group < 1060)
    type = FLOAT_TYPE;
  else if(group < 1080)
    type = INT_TYPE;
  else
    type = UNKNOWN_TYPE;

  static int sint;
  static fixed sfixed;
  static char sstring[MAXSTRING+1];
  switch((int)type)
  { case INT_TYPE:
      DxRInt(&sint);
      pntr = &sint;
      break;
    case FLOAT_TYPE:
      DxRFixed(&sfixed);
      pntr = &sfixed;
      break;
    case STRING_TYPE:
      DxRString(sstring);
      pntr = &sstring;
      break;
    default:
      return(1);
  }
  
  } while(repeat);
  return(0);
}

const char* DXF_String[] = {"HEADER","TABLES","BLOCKS","ENTITIES","EOF",
               "SECTION","ENDSEC",
               "TABLE","ENDTAB",
               "LTYPE","LAYER",
               "BLOCK","ENDBLK",
               "LINE","3DFACE",
               "INSERT","POLYLINE","VERTEX"};
enum DXF_TYPE { HEADER = 0,TABLES,BLOCKS,ENTITIES,ENDOF,
                SECTION,ENDSEC,
                TABLE,ENDTAB,
                LTYPE,LAYER,
                BLOCK, ENDBLK,
                LINE_ENTITY, FACE_ENTITY,
                INSERT_ENTITY, POLYLINE_ENTITY, VERTEX_ENTITY,
                UNKNOWN_DXF };

int WhichDXF(char* s, DXF_TYPE &tm)
{
  for(int t = HEADER; t < UNKNOWN_DXF; t++)
  { if(!ustrcmp(s,DXF_String[t])) {
      tm = (DXF_TYPE)t;
      return(0);
    }
  }
  return(1);  // unknown
}

int FindDXF(DXF_TYPE dt)
{ DXF_TYPE t;
  do
  { if(RGroup())
      return(1);
    if(type == STRING_TYPE)
      WhichDXF((char*)pntr,t);
  } while(dt != t);
  return(0);
}

int Expecting(int g, DXF_TYPE dt)
{
  if(RGroup())
    return(1);
  if(!ustrcmp((char*)pntr,"EOF"))
    return(-1);  // end of file
  if(group != g || type != STRING_TYPE || ustrcmp((char*)pntr,DXF_String[dt]))
    return(2);
  return(0);
}
#include "vertex.h"
#include "line.h"
#include "arc.h"
#include "spline.h"
#include "face.h"
#include "insert.h"
#include "findvisu.h"
#include "drawline.h"

int Load_Entities(BlockClass* block)
{
  ListClass polylinelist;
  // if block is not null then a group has already been loaded
  if(!block)
  {  if(RGroup())
      return(21);
  }
  while(TRUE)
  { DXF_TYPE t;
    if(WhichDXF((char*)pntr,t))
    { do        // don't recongise this so get to next entitiy
      { if(RGroup())
          return(22);
      } while(group);
    }
    else if(t == ENDBLK || t == ENDSEC)
      break;
    else
    { LayerClass* layer = NULL;
      VertexClass* point[4] = { NULL, NULL, NULL, NULL };
      fixed x[4], y[4], z[4];
      int c[9] = { 0, 0, 0, 0, 0, 0, 0, 0, 0 };   // group 70 counts
      int polylinetype = 0;
      int i, j;
      int points = 0;
      char name[MAXSTRING];
      LINETYPE linetype = BYLAYER_LINE;
      fixed xscale, yscale, zscale;
      xscale = yscale = zscale = 1<<16;
      fixed rx = 0, ry = 0, rz = 0;
      do
      { if(RGroup())
          return(23);
        int pt = group/10;
        int pn = group%10;
        if(group >=10 &&  group <= 33)
        { if(pn > 3)
            return(24);   // maximum of 4 points for each entity at moment
          if(pn >= points)
            points = pn + 1;
          switch(pt)
          { case 1:
              x[pn] = *(fixed*)pntr;
              break;
            case 2:
              y[pn] = *(fixed*)pntr;
              break;
            case 3:
              z[pn] = *(fixed*)pntr;
              break;
          }
        } else if(group >= 70 && group <= 79) {
          c[pn] = *(int*)pntr;
        } else {
          LinkClass* layerlink;
          switch(group)
          { case 2:
              strcpy(name,(char*)pntr);
              break;
            case 6:  // line type
              for(linetype = SOLID_LINE; linetype < BYLAYER_LINE; ((int)linetype)++)
              { if(!ustrcmp((char*)pntr,Line_Type_String[linetype]))
                  break;
              }
              // if type not found, ends up back at BYLAYER
              break;
            case 8: // layer
              layerlink = LayerList.FirstLink();
              while(layerlink)
              { if(!ustrcmp(((LayerClass*)(layerlink->Object))->Name,(char*)pntr))
                  layer = (LayerClass*)(layerlink->Object);
                layerlink = layerlink->NextLink();
              }
              // quite okay if layer is not found - it will became a base object
              break;
            case 41:
              xscale = *(fixed*)pntr;
              break;
            case 42:
              yscale = *(fixed*)pntr;
              break;
            case 43:
              zscale = *(fixed*)pntr;
              break;
            case 50:
              rz = *(fixed*)pntr;
              break;
            case 51:
              rx = *(fixed*)pntr;
              break;
            case 52:
              ry = *(fixed*)pntr;
              break;
            case 62:
              // *pntr is color if not by layer,  256 == bylayer
              break;
          }
        }
      } while(group);  // until next entity
      // find or create points
      for(int pn = 0; pn < points; pn++)
        point[pn] = FindorMakeVertex(x[pn],y[pn],z[pn],block,layer);
      LineClass* line;
      FaceClass* face;
      InsertClass* insert;
      BlockClass* insertblock;
      switch(t)
      { case INSERT_ENTITY:
          insertblock = FindorMakeBlock(name);
          if(!insertblock)
            break;
          insert = new InsertClass();
          TargetList->Add(insert,&InsertControl);
          insert->InsertBlock = insertblock;
          insert->P1 = point[0];
          insert->P2 = insert->P1;
          insert->Sx = xscale;
          insert->Sy = yscale;
          insert->Sz = zscale;
          insert->Rx = rx;
          insert->Ry = ry;
          insert->Rz = rz;
          break;
        case LINE_ENTITY:
          line = new LineClass();
          TargetList->Add(line,&LineControl);
          line->P1 = point[0];
          line->P2 = point[1];
          line->Type = linetype;
          break;
        case POLYLINE_ENTITY:
          // if bit 7 of c[0] is 1, then is polyface mesh
          //    c[1] = number of vertex
          //    c[2] = number of faces
          polylinetype = c[0];
          polylinelist.Clear();
          break;
        case VERTEX_ENTITY:
          // mostly handled by assumption that all 30,40,50s are co-ords
          if(!(c[0] & 0x80)) {
            break;
          } else {   // poly face vertex
            if((c[0] & 0x40)) { // co-ord
              polylinelist.Add(point[0]);
              break;
            }
            if(!c[1] || !c[2] || !c[3])
              break;
            for(i = 0; i < 4; i++) {
              j = c[1+i]-1;
              if(j < 0)
                break;
              LinkClass* l = polylinelist.Find(j);
              if(l)
                point[i] = (VertexClass*)(l->Object);
              else
                break;  // can't find point for face
            }
          }
          // no break delib as this is a polyface mesh face
        case FACE_ENTITY:
          face= new FaceClass();
          TargetList->Add(face,&FaceControl);
          face->P1 = point[0];
          face->P2 = point[1];
          face->P3 = point[2];
          if(point[3])
            face->P4 = point[3];
          break;
      }
    }
  }
  return(0);
}

int Load_DXF(int mode)
{
  int err;
  Mode = mode;
  DXF_TYPE section = ENDOF;
  while(1)
  { int res = Expecting(0,SECTION);
    if(res < 0) // EOF
      break;
    if(res > 0)
      return(1);
    do {
      if(RGroup())
        return(2);
    } while(group != 2);       // not section name following - keep looking for it
    if(WhichDXF((char*)pntr,section) ||    // identify section - return true if unknown
       section == HEADER)                  // skip header section for alcad
    { if(FindDXF(ENDSEC))   // ditch this section
        return(3);
    }
    else if(section == TABLES)
    { while(1)
      { err = Expecting(0,TABLE);
        if(err == 2)
          break;                // probably due to ENDSEC
        if(err)
          return(4);
        do {
          if(RGroup())
            return(5);
        }  while(group != 2);
          
        if( WhichDXF((char*)pntr,section) ||   // unknown
            section != LAYER)                  // not layer
        { if(FindDXF(ENDTAB))   // ditch this table
            return(6);
        }
        else // layers - the only thing of interest here
        { if(RGroup())  // group = 70, *p is the expected number of table items
            return(7);
          if(RGroup())
            return(8);
          while(group == 0 && !ustrcmp((char*)pntr,"LAYER"))
          { LayerClass* layer = new LayerClass();
            LayerList.Add(layer);
            do
            { if(RGroup())
                return(9);
              switch(group)
              { case 2:  // name
                  layer->Name = new char[ustrsizez((char*)pntr)];
                  ustrcpy(layer->Name,(char*)pntr);
                  break;
                case 6:  // line type
                  LINETYPE lt;
                  for(lt = SOLID_LINE; lt < UNKNOWN_LINE; ((int)lt)++)
                  { if(!ustrcmp(Line_Type_String[lt],(char*)pntr))
                    { layer->LineType = lt;
                      break;
                    }
                  }
                case 62: // color
                  layer->Color = *((int*)pntr);
                  break;
              }
            } while(group); // as for LAYER
          }
        }
      }
    }
    else if(section == BLOCKS)
    { while(1)
      { err = Expecting(0,BLOCK);
        if(err == 2)
          break;  // probably due to ENDSEC
        if(err)
          return(10);
        if(RGroup())
          return(11);
        if(group != 2)  // block name must come first
          break;
        // block may already exist through an INSERT reference in another block
        BlockClass* block = FindorMakeBlock((char*)pntr);
        if(block)
        { do
          { if(RGroup())
              return(12);
            switch(group)
            { case 10:
                block->Base.X = *(fixed*)pntr;
                break;
              case 20:
                block->Base.Y = *(fixed*)pntr;
                break;
              case 30:
                block->Base.Z = *(fixed*)pntr;
                break;
            }
          } while(group);
          err = Load_Entities(block); // exit probably due to ENDBLK
          if(err)
            return(err+20);
        }
      }
    }
    else if(section == ENTITIES)
    {
      err = Load_Entities(NULL);  // exit probably due to ENDSEC
      if(err)
        return(err);
    }
  };
  return(0);
}

int Load_DXF_Packed(char* path)
{
  char* errorstr = "PACKED SAVE ERROR";
  packedfile = pack_fopen(path,"r");
  if(!packedfile)
  { billalert(errorstr,path,"Couldn't open file for reading","&Ok",NULL,'o',0);
    return(1);
  }
  int errorcode = Load_DXF(0);
  if(errorcode)
  { char errortype[32];
    sprintf(errortype,"Code:%3d",errorcode);
    billalert(errorstr,errortype,"in Load_DXF","&Ok",NULL,'o',0);
    pack_fclose(packedfile);
    return(1);
  }
  pack_fclose(packedfile);
  return(0);
}

int Load_DXF_ASCII(char* path)
{
  char* errorstr = "ASCII LOAD ERROR";
  file = fopen(path,"r");
  if(!file)
  { billalert(errorstr,path,"Couldn't open file for reading.","&Ok",NULL,'o',0);
    return(1);
  }
  DXFLineCount = 0;
  int errorcode = Load_DXF(1);
  if(errorcode)
  { char errortype[32];
    sprintf(errortype,"Code:%3d at line %10u",errorcode,DXFLineCount);
    billalert(errorstr,errortype,"in Load_DXF","&Ok",NULL,'o',0);
    fclose(file);
    return(1);
  }
  fclose(file);
  return(0);
}

#include <string.h>

int Load_DXF_Binary(char* path)
{
  char* errorstr = "BINARY LOAD ERROR";
  FILE* f = fopen(path,"rb");
  if(!file)
  { billalert(errorstr,path,"Couldn't open file for reading.","&Ok",NULL,'o',0);
    return(1);
  }
  char readbuf[24];
  if(fread(readbuf,1,22,file) != 22)
  { billalert(errorstr,path,"Couldn't read from file.","&Ok",NULL,'o',0);
    fclose(file);
    return(1);
  }
  if(strncmp(readbuf,"AutoCAD Binary DXF\r\n\x1A\x00",22))  // note not unicode
  { readbuf[22] = 0;
    billalert(errorstr,readbuf,"Binary tag syntax.","&Ok",NULL,'o',0);
    fclose(file);
    return(1);
  }
  int errorcode = Load_DXF(2);
  if(errorcode)
  { char errortype[32];
    sprintf(errortype,"Code:%3d",errorcode);
    billalert(errorstr,errortype,"in Load_DXF","&Ok",NULL,'o',0);
    fclose(file);
    return(1);
  }
  fclose(file);
  return(0);
}

