/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "drawline.h"

/* enum LINETYPE { SOLID_LINE=0, FAINT_LINE, DITHERED_LINE, DOTTED_LINE, DASHED_LINE,
                                 DASHDOT_LINE, DASHDOTDOT_LINE,
                                 UNKNOWN_LINE, BYLAYER_LINE };
*/
char* Line_Type_String[] = {"Solid", "Faint", "Dithered", "Dotted", "Dashed",
                               "DashDot", "DashDotDot", "Unknown", "ByLayer" };

unsigned long line_masks[LINETYPES] =
                      { 0XFFFFFFFF, 0x88888888, 0xAAAAAAAA, 0xCCCCCCCC, 0xF0F0F0F0,
                               0xCFCFCFCF, 0xCFCCCFCC };
unsigned long line_mask;
bool line_background = FALSE;
int line_bg_color = 0;
unsigned char lc = 0;  // for use in drawline & putline only

// call back function for allegro do_line
void putline(BITMAP *bmp, int x, int y, int color)
{ if( (1 << lc) & line_mask)
    putpixel(bmp,x,y,color);
  else if(line_background)
    putpixel(bmp,x,y,line_bg_color);
  lc++;
  lc &= 0x1F;
}

void drawline(BITMAP *bmp, int x1, int y1, int x2, int y2, int color, unsigned long mask)
{
  lc = (x1 + y1)&0x1F;  // an attempt to syncronise dashes
  line_mask = mask;
  do_line(bmp,x1,y1,x2,y2,color,putline);
}

void drawline(BITMAP *bmp, int x1, int y1, int x2, int y2, int color, LINETYPE type)
{
  if(type)
  { line_background = FALSE;
    drawline(bmp,x1,y1,x2,y2,color,line_masks[type]);
  }
  else  // SOLID
    line(bmp,x1,y1,x2,y2,color);
}

void dotted_line(BITMAP *bmp, int x1, int y1, int x2, int y2, int fg, int bg)
{
  line_bg_color = bg;
  line_background = TRUE;
  drawline(bmp,x1,y1,x2,y2,fg,line_masks[DITHERED_LINE]);

/* the old way, it worked but didn't always match up with allegro line
    int i = ((x1+y1) & 1) ? 1 : 0;
    int sx, ex;
    if(x1 < x2)
    { sx = x1;
      ex = x2;
    }
    else
    { sx = x2;
      ex = x1;
    }

    for (int x = sx; x <=ex; x++)
    { int y = (y2-y1)*(x-x1)/(x2-x1) + y1;
      putpixel(bmp, x, y, (((x+y1) & 1) == i) ? fg : bg);
    }
*/
}

const fix ARC_ANGLE_INC = (int)5;
const fix MIN_FIX_ANGLE = (int)-128;
const fix MAX_FIX_ANGLE = (int)128;
const fix FULL_FIX_ANGLE = (int)256;
const int MAX_FIX_SQR = 127;  // to avoid overflow on fixed squares

#include "define.h"
#include "math.h"

void drawarc(BITMAP *bmp, int x1, int y1,
                          int x2, int y2,
                          int x3, int y3,
                          int color, LINETYPE type) {
  int dx1 = x1 - x3;
  int dx2 = x2 - x3;
  int dy1 = y1 - y3;
  int dy2 = y2 - y3;
  if(!dx1 && !dy1 && !dx2 && !dy2)
    return;  // non existant at this scale
  fix xf1 = dx1;
  fix xf2 = dx2;
  fix yf1 = dy1;
  fix yf2 = dy2;
  fix a1 = atan2(xf1,yf1);
  fix a2 = atan2(xf2,yf2);
  if(!dx1 && !dy1) {    // center at start
    a1 = a2;
    if(!dx2 && !dy2)    // everything at center
      return;           // giveup
  }
  else if(!dx2 && !dy2)  // center at end
    a2 = a1;
  fix da = a2 - a1;
  bool a1lta2 = (a1 < a2);
  if(da < MIN_FIX_ANGLE) {    // happens when a1>+64 and a2<-64 thus da<-128
    da = FULL_FIX_ANGLE + da;
    a1lta2 = true;   // a1 is really less than a2
  } else if(da < 0)  // everything must be pos
    da += FULL_FIX_ANGLE;
  fix v1;
  fix v2;
  if(dx1 > MAX_FIX_SQR || dy1 > MAX_FIX_SQR ||
     dx1 < -MAX_FIX_SQR || dy1 < -MAX_FIX_SQR) {
    // will have to use float
    double dv1 = sqrt((double)dx1*dx1+(double)dy1*dy1);
    if(dv1 >  MAXINT)
      return;
    v1 = dv1;
  }
  else  // small arc is faster
    v1 = sqrt(xf1*xf1 + yf1*yf1);
  if(dx2 > MAX_FIX_SQR || dy2 > MAX_FIX_SQR ||
      dx2 < -MAX_FIX_SQR || dy2 < -MAX_FIX_SQR) {
    // will have to use float  
    double dv2 = sqrt((double)dx2*dx2+(double)dy2*dy2);
    if(dv2 > MAXINT)
      return;
    v2 = dv2;
  }
  else  // small arc is faster
    v2 = sqrt(xf2*xf2 + yf2*yf2);

  if(v1 < 2 && v2 < 2)  // too small to worry about
    return;
  if(v1 < 4 && v2 < 4 && da < 64) {
    drawline(bmp,x1,y1,x2,y2,color,type);  // approximation good enough at this size
    return;
  }
    
    
  fix dv = (v2 - v1)/da;
  bool arc_start = false;
  int lx = x1;  // make sure it starts on the dot
  int ly = y1;
  fix a = a1;
  fix ta = 0;
  do {
    fix v = v1 + dv*ta;
    int x,y;
    if(a == a2) {
      x = x2;   // make sure it ends on the dot
      y = y2;
    } else {
      x = (int)(sin(a)*v) + x3;
      y = (int)(cos(a)*v) + y3;
    }
    if(arc_start) {
      drawline(bmp,lx,ly,x,y,color,type);
      if(a == a2)
        break;
      lx = x;
      ly = y;
    }
      a += ARC_ANGLE_INC;
      ta += ARC_ANGLE_INC;
      if(a > MAX_FIX_ANGLE)
        a -= FULL_FIX_ANGLE;
      if((a > a2 &&              // gone past end
          (a1lta2 || ta > MAX_FIX_ANGLE) &&
          !((a > 0) ^ (a2 > 0)) ) ||  // need to be same side of +-
         ta >= FULL_FIX_ANGLE )   // one revolution cap for that tricky 0 angle problem
        a = a2;
    arc_start = true;
  } while(1);
}

void dotted_arc(BITMAP *bmp, int x1, int y1,
                             int x2, int y2,
                             int x3, int y3,
                             int fg, int bg) {
  line_bg_color = bg;
  line_background = TRUE;
  drawarc(bmp,x1,y1,x2,y2,x3,y3,fg,DITHERED_LINE);
}

void drawcircle(BITMAP *bmp, int x1, int y1, int x2, int y2,
                          int color, LINETYPE type) {
  int dx = x2 - x1;
  int dy = y2 - y1;
  if(!dx && !dy)
    return;  // non existant at this scale
  fix v;
  if(dx > MAX_FIX_SQR || dy > MAX_FIX_SQR) {
    // will have to use float
    double dv = sqrt((double)dx*dx+(double)dy*dy);
    if(dv >  MAXINT)
      return;
    v = dv;
  } else { // small arc is faster
    fix xf = dx;
    fix yf = dy;
    v = sqrt(xf*xf + yf*yf);
  }
  if(v < 2)  // too small to worry about
    return;
    
  fix a = MIN_FIX_ANGLE + ARC_ANGLE_INC;
  int lx, ly, xs, ys;
  bool circle_start = false;
  do {
    int x,y;
    if(a > MAX_FIX_ANGLE) {
      a = MAX_FIX_ANGLE;
      x = xs;
      y = ys;
    } else {
      x = (int)(sin(a)*v) + x2;
      y = (int)(cos(a)*v) + y2;
    }
    if(circle_start)
      drawline(bmp,lx,ly,x,y,color,type);
    else {
      xs = x;
      ys = y;
    }
    circle_start = true;
    if(a == MAX_FIX_ANGLE)
      break;
    lx = x;
    ly = y;
    a += ARC_ANGLE_INC;
  } while(1);
}

void dotted_circle(BITMAP *bmp, int x1, int y1,
                             int x2, int y2,
                             int fg, int bg) {
  line_bg_color = bg;
  line_background = TRUE;
  drawcircle(bmp,x1,y1,x2,y2,fg,DITHERED_LINE);
}

