/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "blockset.h"
#include <string.h>
#include "xproc.h"
#include "stdio.h"
#include "blocks.h"
#include "view.h"
#include "help.h"

// globals for select editor
char Block_Str[NCHAR];
char* Blocks_Selected = NULL;  // only to be used by Select_Editor
unsigned char Block_Flag = 0;
DIALOG* Block_List_dlg = NULL;
int Block_List_Pntr; // used to detect change in list selection point

LinkClass* Block_Link; // used in define macro below but defined here so compiler knows about it
// previously I had an link called 'l' here and another in a function argument and the
// compiler didn't complain.
#define BEGIN_BLOCKLIST Block_Link = BlockList.FirstLink(); while(Block_Link) {
#define END_BLOCKLIST   Block_Link = Block_Link->NextLink(); }

int Get_Block_Selected()
{
  if(!Blocks_Selected)
    return(-1);
  unsigned i = 0;
  int j = 0;
  BEGIN_BLOCKLIST
    Blocks_Selected[i] = Block_Link->Selected;
    if(Blocks_Selected[i])
      j++;
    i++;
  END_BLOCKLIST
  return(j);
}

void Set_Block_Selected()
{
  if(!Blocks_Selected)
    return;
  unsigned i = 0;
  BEGIN_BLOCKLIST
    Block_Link->Selected = Blocks_Selected[i];
    i++;
  END_BLOCKLIST
}

int Block_Adder(void)
{
  BlockClass* block = new BlockClass();
  if(block) {
    BlockList.Add(block);
    Blocks_Selected = (char*)realloc(Blocks_Selected,Blocks);
    if(Blocks_Selected) {
      memset(Blocks_Selected,0,Blocks);
      Blocks_Selected[Blocks-1] = true;
    }
    Base_Block = block;
  }
  return D_REDRAW;
}

/* delete (but don't put in the clipboard unless shift key) the selection */
int Block_Deleter(void)
{ if(Blocks_Selected)
  { Set_Block_Selected();
    int j = 0;
    for(int s = 0; s < Blocks; s++)
    { if(Blocks_Selected[s]) {
        // if Base_Block is removed then set to NULL
        LinkClass* link = BlockList.Find(s);
        if(link) {
          BlockClass* block = (BlockClass*)link->Object;
          int user = TargetList->DependantOn(block);
          if(user >= 0) {
            char str[6];
            sprintf(str,"Block ID%d is being used by object #%d",block->ID,user);
            billalert("Sorry, Can't delete block.",str,NULL,"&Ok", NULL, 'o', 0);
            link->Selected = false;
          } else {
            if(block == Base_Block)
              Base_Block = NULL;
            if(block == Action_Block)
              Action_Block = NULL;
            j++;
          }
        }
      }
      if(j && s+j < Blocks)
        Blocks_Selected[s] = Blocks_Selected[s+j];
    }
    Blocks -= j;
  }
  BlockList.Delete_Selected();
  return D_REDRAW;
}

/* getter for the list of the objects of the dialog
 *  this formats a string with the sproc and the id_params
*/

char *Select_Block_Getter(int index, int *size)
{ if(index < 0)
  { *size = Blocks;
    return(NULL);
  }
  if(Block_List_dlg->d1 != Block_List_Pntr && Block_List_dlg->d1 >= 0 && Block_List_dlg->d1 < Blocks)
  { if(key_shifts & KB_CTRL_FLAG)
      Blocks_Selected[Block_List_dlg->d1] = TRUE;
    else if(key_shifts & KB_SHIFT_FLAG)
      Blocks_Selected[Block_List_dlg->d1] = FALSE;
    else
    { for(int i = 0; i < Blocks; i++)
        Blocks_Selected[i] = FALSE;
        Blocks_Selected[Block_List_dlg->d1] = TRUE;
    }
    Block_List_Pntr = Block_List_dlg->d1;
  }
  char check, actc, basc;
  char flag_str[9];
  int i = 0;
  BEGIN_BLOCKLIST
    if(i == index)
    { if(Blocks_Selected[i])
        check = '*';  // show original selection
      else
        check = ' ';
      BlockClass* block = (BlockClass*)Block_Link->Object;
      int j = 0;
      flag_str[j] = 0;
      if(Block_Flag & BLOCK_HIDE)
        flag_str[j++] = 'H';
      else
        flag_str[j++] = 'S';     // H for hide
      if(Block_Flag & BLOCK_FILTER)
        flag_str[j++] = 'F';
      else
        flag_str[j++] = 'I';   // I for include
      if(block == Action_Block)
        actc = 'A';
      else
        actc = ' ';
      if(block == Base_Block)
        basc = 'B';
      else
        basc = ' ';
      const char* name = block->Name;
      if(name == NULL)
        name = "NONAME";
      usprintf(Block_Str, "%c%3d:%s %c%c %-32.32s",check,block->ID,flag_str,actc,basc,name);
      break;
    }
    i++;
  END_BLOCKLIST
  return Block_Str;
}

int Select_All_Blocks()
{
  BlockList.Select_All();
  Get_Block_Selected();
  return D_REDRAW;
}

int Select_No_Blocks()
{
  BlockList.Select_None();
  Get_Block_Selected();
  return D_REDRAW;
}
int Invert_Block_Selection()
{
  BlockList.Invert_Selection();
  Get_Block_Selected();
  return D_REDRAW;
}

int Shift_Block_Down()
{ if(Block_List_dlg)
  { LinkClass* l = BlockList.Find(Block_List_dlg->d1);
    if(l)
    { if(BlockList.Demote(l))
        Block_List_dlg->d1++;
    }
  }
  Get_Block_Selected();
  return D_REDRAW;
}

int Shift_Block_Up()
{ if(Block_List_dlg)
  { LinkClass* l = BlockList.Find(Block_List_dlg->d1);
    if(l)
    { if(BlockList.Promote(l))
        Block_List_dlg->d1--;
    }
  }
  Get_Block_Selected();
  return D_REDRAW;
}

void Select_Block(BlockClass** block)
{
  int i = 0;
  BEGIN_BLOCKLIST
    if(Blocks_Selected && Blocks_Selected[i])
      *block = (BlockClass*)Block_Link->Object;  // default
    if(active_dialog[1].d1 == i++)
    { *block = (BlockClass*)Block_Link->Object;
      break;
    }
  END_BLOCKLIST
  if(Base_Block == *block)
    *block = NULL;
}

int Select_Base_Block()
{
  Select_Block(&Base_Block);
  return D_REDRAW;
}

int Select_Action_Block()
{
  Select_Block(&Action_Block);
  return D_REDRAW;
}


void Change_Block_Flags(unsigned char mask, unsigned char flags)
{ if(Blocks_Selected)
  { int i = 0;
    BEGIN_BLOCKLIST
      if(Blocks_Selected[i++])
      { BlockClass* block = (BlockClass*)Block_Link->Object;
        Block_Flag = (Block_Flag & mask) | flags;
      }
    END_BLOCKLIST
  }
}

int Show_Selected_Block()
{ Change_Block_Flags(BLOCK_HIDE_MASK,0);
  return D_REDRAW;
}

int Hide_Selected_Block()
{ Change_Block_Flags(BLOCK_FILTER_MASK,BLOCK_HIDE);
  return D_REDRAW;
}

int Filter_Selected_Block()
{ Change_Block_Flags(BLOCK_FILTER_MASK,BLOCK_FILTER);
  return D_REDRAW;
}

int Include_Selected_Block()
{ Change_Block_Flags(BLOCK_FILTER_MASK,0);
  return D_REDRAW;
}

#include "tostring.h"
#include "alcolor.h"

int Call_Block_Prop_Help()
{
  Get_Help("BLOCK PROPERTY EDITOR");
  return D_OK;
}

/* pop up a dialog to edit the BlockProperties of a DIALOG object */
int Block_Properties(void)
{
    int i, j, res;
    int ssize = NCHAR/uwidth_max(U_CURRENT) - 1;
    char* name;
    int tempcolor;
    char cstr[20];

    // Find the first selected object
    i = 0;
    BEGIN_BLOCKLIST
      if(Block_Link->Selected)
        break;
      i++;
    END_BLOCKLIST
    if(!Block_Link)
      return D_O_K;  // no Link
    BlockClass* block = (BlockClass*)(Block_Link->Object);
    sprintf(Block_Str,"Edit Block ID #%d",block->ID);
    name = new char[ssize];
    if(block->Name)
      strcpy(name,block->Name);
    else
      name[0] = 0;  // null str
    sprintf(cstr,"%d",block->Color);
    tempcolor = block->Color;

    DIALOG block_dlg[] =
{
   /* (proc)            (x)  (y) (w)  (h) (fg) (bg) (key) (flags) (d1) (d2) (dp)              (dp2)           (dp3)              */
   { d_billwin_proc,    0,   0,  352, 88, 0,   0,   0,    0,      0,   0,   (void*)Block_Str, NULL,           NULL              },
   { d_billtext_proc,   8,   20, 144, 8,  0,   0,   0,    0,      0,   0,   (void*)"Name:",   NULL,           NULL              },
   { Xedit_proc,        48,  16, 296, 16, 0,   0,   0,    0,      9,   0,   name,             NULL,           NULL              },
   { d_billtext_proc,   8,   40, 144, 8,  0,   0,   0,    0,      0,   0,   (void*)"Color:",  NULL,           NULL              },
   { Xedit_proc,        64,  40, 120, 16, 0,   0,   13,   0,      0,   0,   cstr,             Color_Selecter, (void*)&tempcolor },
   { d_billbutton_proc, 56,  64, 48,  16, 0,   0,   13,   D_EXIT, 0,   0,   (void*)"OK",      NULL,           NULL              },
   { d_billbutton_proc, 112, 64, 72,  16, 0,   0,   27,   D_EXIT, 0,   0,   (void*)"Cancel",  NULL,           NULL              },
   { Xbutton_proc,      300, 64, 48,  16, 0,   0,   '?',  D_EXIT, 0,   0,   (void*)"Help&?",  Call_Block_Prop_Help,   NULL      },
   { NULL,              0,   0,  0,   0,  0,   0,   0,    0,      0,   0,   NULL,             NULL,           NULL              }
};
    set_dialog_color(block_dlg, gui_fg_color, gui_bg_color);
    centre_dialog(block_dlg);
    res = popup_dialog(block_dlg, -1);

    // Get data back to object
    if(res == 5) { // OK
      if(block->Name)
        delete(block->Name);
      if(name[0] > 32)
        block->Name = name;   // retained in memory - deleted with ~Block()
      else
        block->Name = NULL;
      block->Color = (int)strtol(cstr,NULL,10);
    } else {  // assume cancel
      delete name;
    }
    return D_REDRAW;
}

int Sel_Block_Properties()
{
  int i = 0;
  // select only Link pointed to by list
  BEGIN_BLOCKLIST
    Block_Link->Selected = (i == Block_List_dlg->d1);
    i++;
  END_BLOCKLIST
  return(Block_Properties());
}

int Call_Edit_Block_Help()
{
  Get_Help("BLOCK LIST EDITOR");
  return D_OK;
}

/* edit the list of selected blocks */
int Block_Editer(void)
{
    DIALOG_PLAYER *pl;

    // create array selected
    Blocks_Selected = (char*)malloc(Blocks);  // selected is a global - see above SelectAll
    Get_Block_Selected();

    DIALOG sel_dlg[] =
{
   /* (proc)            (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1)       (d2) (dp)                     (dp2)                   (dp3) */
   { d_billwin_proc,    0,   0,   400, 240, 0,   0,   0,    0,      0,         0,   (void*)"Select Block",   NULL,                   NULL },
   { d_billlist_proc,   8,   24,  344, 148, 0,   0,   0,    D_EXIT, 0,         0,   Select_Block_Getter,     NULL,                   NULL },
   { d_keyboard_proc,   0,   0,   0,   0,   0,   0,   0,    0,      KEY_SPACE, 0,   Sel_Block_Properties,       NULL,                   NULL },
   { Xbutton_proc,      312, 172, 48,  16,  0,   0,   '?',  D_EXIT, 0,         0,   (void*)"Help&?",         Call_Edit_Block_Help,   NULL },
   { Xbutton_proc,      80,  196, 48,  16,  0,   0,   'a',  D_EXIT, 0,         0,   (void*)"&All",           Select_All_Blocks,      NULL },
   { Xbutton_proc,      80,  216, 48,  16,  0,   0,   'n',  D_EXIT, 0,         0,   (void*)"&None",          Select_No_Blocks,       NULL },
   { Xbutton_proc,      136, 172, 64,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Base",           Select_Base_Block,      NULL },
   { Xbutton_proc,      136, 196, 64,  16,  0,   0,   'i',  D_EXIT, 0,         0,   (void*)"&Invert",        Invert_Block_Selection, NULL },
   { Xbutton_proc,      136, 216, 64,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Action",         Select_Action_Block,    NULL },
   { Xbutton_proc,      206, 196, 40,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Show",           Show_Selected_Block,    NULL },
   { Xbutton_proc,      206, 216, 40,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Hide",           Hide_Selected_Block,    NULL },
   { Xbutton_proc,      254, 196, 50,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Filter",         Filter_Selected_Block,  NULL },
   { Xbutton_proc,      254, 216, 50,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Include",        Include_Selected_Block, NULL },
   { Xbutton_proc,      312, 196, 40,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Add",            Block_Adder,            NULL },
   { Xbutton_proc,      312, 216, 40,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Del",            Block_Deleter,          NULL },
   { Xbutton_proc,      360, 196, 32,  16,  0,   0,   'u',  D_EXIT, 0,         0,   (void*)"/\\",            Shift_Block_Up,         NULL },
   { Xbutton_proc,      360, 216, 32,  16,  0,   0,   'd',  D_EXIT, 0,         0,   (void*)"\\/",            Shift_Block_Down,       NULL },
   { d_keyboard_proc,   0,   0,   0,   0,   0,   0,   0,    0,      KEY_DEL,   0,   Block_Deleter,           NULL,                   NULL },
   { d_billbutton_proc, 8,   216, 64,  16,  0,   0,   13,   D_EXIT, 0,         0,   (void*)"OK",             NULL,                   NULL },
   { d_billbutton_proc, 8,   196, 64,  16,  0,   0,   13,   D_EXIT, 0,         0,   (void*)"Cancel",         NULL,                   NULL },
   { NULL,              0,   0,   0,   0,   0,   0,   0,    0,      0,         0,   NULL,                    NULL,                   NULL }
};
    centre_dialog(sel_dlg);
    set_dialog_color(sel_dlg, gui_fg_color, gui_bg_color);
    pl = init_dialog(sel_dlg, 1);
    Block_List_Pntr = sel_dlg[1].d1 = -1;   // no particular selection
    Block_List_dlg = &sel_dlg[1];

    bool dialog_exit;
    do
    {
      dialog_exit = update_dialog(pl);
      if(dialog_exit == FALSE && pl->obj == 1)  // list
      { pl->res |= Sel_Block_Properties();
        dialog_exit = TRUE;
      }
    }
    while(dialog_exit);

    int res = shutdown_dialog(pl);
    if(res == 22)  // OK
      Set_Block_Selected();
    FREE(Blocks_Selected);
    Block_List_dlg = NULL;
    return D_REDRAW;
}

