/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef ARCHPP
#define ARCHPP

#include "line.h"

#define ARC_FULL_CIRCLE 1

// something for us to edit
class ArcClass : public LineClass
{
public:
  VertexClass* P3;
  VertexClass* P4;
  BYTE Flags;
  ArcClass() : LineClass() {   Class = ARC_CLASS; P3 = P4 = NULL; Flags = 0; };
};

extern bool DisableNonPlanerArcs;
extern fixed ArcInterationSize;
#define ARC ((ArcClass*)object)

// base class for creator of any object based on objectclass
class ArcControlClass : public LineControlClass
{
public:
  ArcClass* Focus;
  
  ArcControlClass();
  virtual ObjectClass* Create();
  virtual void NewForOld(ObjectClass*,ObjectClass*,ObjectClass*);
  virtual long Size();
/*  virtual bool Inside(ObjectClass*,int,int);
  virtual bool GetLimits(ObjectClass* object,int& x,int& y,int& z,int& w,int& h,int& d);
  - use lineclass for the moment */
  virtual int GetProperty(ObjectClass*,int n, void** p, char** name,
                            void**); // returns type or -1 for fail
  virtual int Summary(ObjectClass*,char*,int,int=0);
  virtual int SetProperty(ObjectClass*,int n, void* p); // -1 for fail
  void RealToFlat(ObjectClass* object,int* p);
  virtual void Draw(BITMAP*,ObjectClass*);
  virtual void Indicate(BITMAP*, ObjectClass*,int,int,int,int,int,int);
};

extern ArcControlClass ArcControl;

#endif
