/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "drawline.h"
#include "line.h"
#include "obj3ctrl.h"
#include "visulist.h"  // for access to TargetList
#include "vtxmath.h"
#include "arc.h"

ArcControlClass ArcControl;
bool DisableNonPlanerArcs = false;
fixed ArcInterationSize = 1<<16;

#define ARC ((ArcClass*)object)

ArcControlClass:: ArcControlClass() : LineControlClass()
{ Name = "Arc"; Properties = 11;
  Color = LIGHT_BLUE;
}

ObjectClass* ArcControlClass::Create()
{
  return(new ArcClass);
}

void ArcControlClass::NewForOld( ObjectClass* object, ObjectClass* oldobj, ObjectClass* newobj)
{
  if(ARC->P1 == oldobj)
    ARC->P1 = (VertexClass*)newobj;
  else if(ARC->P2 == oldobj)
    ARC->P2 = (VertexClass*)newobj;
  else
    LineControlClass::NewForOld(object,oldobj,newobj);
}
    
long ArcControlClass::Size()
{
  return(sizeof(ArcClass));
}

/*

bool ArcControlClass::Inside(ObjectClass* object, int mx, int my)
{
  return false;
}

int ArcControlClass::Distance(ObjectClass* object, int x, int y)
{
  int x1, x2, y1, y2, z;
  Current_Visual->RealToFlat(&ARC->P1->Pos,x1,y1,z);
  Current_Visual->RealToFlat(&ARC->P2->Pos,x2,y2,z);
  int dx = x2 - x1;
  int dy = y2 - y1;
  return(0);
}
*/

/* Use lineclass
bool ArcControlClass::GetLimits(ObjectClass* object,int& x,int& y,int& z,
                                                       int& w,int& h,int& d)
{
  return true;
}
*/

// should be called Get Pointer to and Name of Property
int ArcControlClass::GetProperty(ObjectClass* object, int n, void** p, char** name,
                                               void** select_function)
{
  static bool flag;
  static int vertex;
  if(n < 8)
    return(LineControlClass::GetProperty(object,n,p,name,select_function));
  *select_function = NULL;
  VertexClass* vtx;
  switch(n)
  {  case 8:
       vtx = ARC->P3;
       break;
     case 9:
       vtx = ARC->P4;
       break;
  }
  if(n < 10)
    vertex = TargetList->Find_OfType(vtx,&VertexControl);
  switch(n)
  { case 8:
      *name = "P3:";
      *p = &vertex;
      return(INT_TYPE | INDEX_TYPE);
      break;
    case 9:
      *name = "P4:";
      *p = &vertex;
      return(INT_TYPE | INDEX_TYPE);
      break;
    case 10:
      *name = "Circle";
      flag = ((ARC->Flags & ARC_FULL_CIRCLE) != 0);
      *p = &flag;
      return(BOOL_TYPE | INDEX_TYPE);
  }
  return(-1);
}

int ArcControlClass::Summary(ObjectClass* object,char* str, int maxstr,int flags)
{
  int i = LineControlClass::Summary(object,str,maxstr,flags);
  int p3 = -1;
  if(ARC->P3)
    p3 = TargetList->Find_OfType(ARC->P3,&VertexControl);
  i += uszprintf(str+i,maxstr,"P3=%d",p3);
  int p4 = -1;
  if(ARC->P4)
    p4 = TargetList->Find_OfType(ARC->P4,&VertexControl);
  i += uszprintf(str+i,maxstr,"P4=%d",p4);
  if(ARC->Flags & ARC_FULL_CIRCLE)
    i += uszprintf(str+i,maxstr,"FullCircle");
  return i;
}

#include "visulist.h"

int ArcControlClass::SetProperty(ObjectClass* object, int n, void* p)
{
  if(n < 8)
    return(LineControlClass::SetProperty(object,n,p));
  VertexClass* vtx;
  if(n < 10)
    vtx = (VertexClass*)TargetList->Find_OfType(*(int*)p,&VertexControl);
  switch(n)
  { case 8:
      ARC->P3 = vtx;
      break;
    case 9:
      ARC->P4 = vtx;
      break;
    case 10:
      if(*((bool*)p))
        ARC->Flags |= ARC_FULL_CIRCLE;
      else
        ARC->Flags &= (ARC_FULL_CIRCLE ^ 0xFFFF);
      break;
  }
  return(0);
}

void ArcControlClass::Draw(BITMAP* bmp,ObjectClass* object)
{
  if(!Current_Visual->Show(Type,ARC->P1->Layer))
    return;
  // use current visual mode to protray object on bmp
  int x1, x2, x3, x4, y1, y2, y3, y4, z1, z2, z3, z4;
  int color = VertexControl.GetColor(ARC->P1,Color);
  Current_Visual->RealToFlat(&ARC->P1->Pos,x1,y1,z1);
  if(ARC->P1 != ARC->P2) {
    Current_Visual->RealToFlat(&ARC->P2->Pos,x2,y2,z2);
  } else if(ARC->P3 == NULL) {
    drawline(bmp,x1,y1,x2,y2,color,(LINETYPE)ARC->Type);
    return;
  }
  Current_Visual->RealToFlat(&ARC->P3->Pos,x3,y3,z3);
  if(ARC->P4 != NULL) {  // shouldn't occur
    Current_Visual->RealToFlat(&ARC->P3->Pos,x4,y4,z4);
  }
  if(z1 == z3 && z1 == z4)  // all in same plane - so it's easy peasy
  { if((ARC->P1 != ARC->P2) && !(ARC->Flags & ARC_FULL_CIRCLE)) {
      drawarc(bmp,x1,y1,x2,y2,x3,y3,color,(LINETYPE)ARC->Type);
    } else {
      drawcircle(bmp,x1,y1,x3,y3,color,(LINETYPE)ARC->Type);
    }
  }
  if(DisableNonPlanerArcs)
    return;
  // else it gets a little more complicated
  // first use P1, P3 and P4 to calc plane of circle and develop a transform matrix
  // P2 could be offset for a screw thread but that's down the track
  // interate through the arc using ArcInterationSize
  //For n interations between P1 and P4,
  // r^2 = x^2 + y^2 + z^2
  // Circumfrence from P1 to P4
}

void ArcControlClass::Indicate(BITMAP* bmp, ObjectClass* object,
     int,int,int,int, int fg, int bg)
{
  int x1, x2, x3, x4, y1, y2, y3, y4, z1, z2, z3, z4;
  Current_Visual->RealToFlat(&ARC->P1->Pos,x1,y1,z1);
  if(ARC->P1 != ARC->P2)
    Current_Visual->RealToFlat(&ARC->P2->Pos,x2,y2,z2);
  else {
    x2 = x1;
    y2 = y1;
  }
  if(ARC->P3 == NULL) {  // occurs during partial creation
    dotted_line(bmp,x1,y1,x2,y2,Color,(LINETYPE)ARC->Type);
    return;
  }
  Current_Visual->RealToFlat(&ARC->P3->Pos,x3,y3,z3);
  if(ARC->P4 != NULL) {  // shouldn't occur
    Current_Visual->RealToFlat(&ARC->P3->Pos,x4,y4,z4);
  }
  if(z1 == z3 && z3 == z4)
  { if((ARC->P1 != ARC->P2) && !(ARC->Flags & ARC_FULL_CIRCLE))
      dotted_arc(bmp,x1,y1,x2,y2,x3,y3,Color,(LINETYPE)ARC->Type);
    else
      dotted_circle(bmp,x1,y1,x3,y3,Color,(LINETYPE)ARC->Type);
  } else {
    if(ARC->P1 != ARC->P2)
      dotted_line(bmp,x1,y1,x2,y2,Color,(LINETYPE)ARC->Type);
    dotted_line(bmp,x1,y1,x3,y3,Color,(LINETYPE)ARC->Type);
    dotted_line(bmp,x2,y2,x3,y3,Color,(LINETYPE)ARC->Type);
  }
  // show plane indicator
  dotted_line(bmp,x3,y3,x4,y4,Color,(LINETYPE)ARC->Type);
}



