/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "face.h"
#include "visulist.h"
#include "texture.h"
#include "alcolor.h"

int Colored_Faces(int c1, int c2, int c3, int c4, int t, bool ds)
{
   VisualLinkClass* link = (VisualLinkClass*)(TargetList->FirstLink());
   while(link)
   { if(link->Selected && link->Control == &FaceControl && link->Object)
     { ((FaceClass*)(link->Object))->C1 = c1;
       ((FaceClass*)(link->Object))->C2 = c2;
       ((FaceClass*)(link->Object))->C3 = c3;
       ((FaceClass*)(link->Object))->C4 = c4;
       if(t >= 0) {
        // replace and fix references etc.
         LinkClass* l = TextureList.Find(t);
         if(l)
           ((FaceClass*)(link->Object))->Texture = (TextureClass*)(l->Object);
       }
       ((FaceClass*)(link->Object))->Flags |= FACES_DOUBLE_SIDED_FLAG;
       if(!ds)
         ((FaceClass*)(link->Object))->Flags ^= FACES_DOUBLE_SIDED_FLAG;
     }
     link = (VisualLinkClass*)(link->NextLink());
   }
   return D_REDRAW;
}

// following functions called using Menu_right_click in edit3d.cpp
/* color selecter for the 'object properties' dialog */

int Faces_Editor()
{
  int co[4], t;
  char cg[120];
  char tg[MAX_TEXTURE_NAME+2];

  for(int c = 0; c < 4; c++) {
    co[c] = Face_Default_Colors[c];
    if(_color_depth == 8)
      usprintf(cg + c*30, "%d", co[c]);
    else
      usprintf(cg + c*30, "%.06X", COL24(co[c]));
  }
  t = Find_Texture(Face_Default_Texture_Name);
  usprintf(tg, "%d", t);

  DIALOG face_dlg[] =
  {
   /* (proc)            (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)               (dp2) (dp3) */
    { d_billwin_proc,    0,   0,  376, 160, 0,   0,   0,    0,      0,   0,   (void*)" Edit Selected Faces", NULL, NULL },
    { d_billbutton_proc, 60,  140,  48,  16,  0,   0,   13,   D_EXIT, 0,   0,   (void*)"OK",         NULL,           NULL },
    { d_billbutton_proc, 112, 140,  72,  16,  0,   0,   27,   D_EXIT, 0,   0,   (void*)"Cancel",     NULL,           NULL },
    { d_billtext_proc,   8,   20, 120,   8,  0,   0,    0,   0,      0,   0,   (void*)"C1:",        NULL,           NULL },
    { Xedit_proc,        144, 16, 80,   16,  0,   0,    0,   0,      0,   0,   (void*)cg,       Color_Selecter, (void*)&(co[0]) },
    { d_billtext_proc,   8,   38, 120,   8,  0,   0,    0,   0,      0,   0,   (void*)"C2:",        NULL,           NULL },
    { Xedit_proc,        144, 34, 80,   16,  0,   0,    0,   0,      0,   0,   (void*)(cg+30),  Color_Selecter, (void*)&(co[1]) },
    { d_billtext_proc,   8,   54, 120,   8,  0,   0,    0,   0,      0,   0,   (void*)"C3:",        NULL,           NULL },
    { Xedit_proc,        144, 52, 80,   16,  0,   0,    0,   0,      0,   0,   (void*)(cg+60),  Color_Selecter, (void*)&(co[2]) },
    { d_billtext_proc,   8,   72, 120,   8,  0,   0,    0,   0,      0,   0,   (void*)"C4:",        NULL,           NULL },
    { Xedit_proc,        144, 70, 80,   16,  0,   0,    0,   0,      0,   0,   (void*)(cg+90),  Color_Selecter, (void*)&(co[3]) },
    { d_billtext_proc,   8,   90, 120,   8,  0,   0,    0,   0,      0,   0,   (void*)"Texture:",   NULL,           NULL },
    { d_billddlist_proc, 144, 88, 300,  16,  0,   0,    0,   0,  t + 1,   0,   Texture_Selector,    NULL,           NULL },
    { d_billcheck_proc,  8,  106,   8,   8,  0,   0,    0,   0,      0,   0,   (void*)"Double Sided", NULL,         NULL },
    { NULL,              0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,                NULL,           NULL }
  };
  if((Face_Default_Flags & FACES_DOUBLE_SIDED_FLAG) != 0)
    face_dlg[13].flags |= D_SELECTED;
  set_dialog_color(face_dlg, gui_fg_color, gui_bg_color);
  centre_dialog(face_dlg);
  int res = popup_dialog(face_dlg, -1);  // -1 = no focus

  // Read data back
  if(res == 1) {
    for(int c = 0; c < 4 ;c++) {
      if(_color_depth == 8)
        co[c] = ustrtol(cg +c*30, NULL, 0);
      else
        co[c] = COL(ustrtol(cg + c*30, NULL, 16));
      Face_Default_Colors[c] = co[c];
    }
    Colored_Faces(co[0],co[1],co[2],co[3],t,face_dlg[13].flags & D_SELECTED);
    strncpy(Face_Default_Texture_Name,Texture_Selector(t),MAX_TEXTURE_NAME);
    Face_Default_Flags |= FACES_DOUBLE_SIDED_FLAG;
    if(face_dlg[13].flags & D_SELECTED)
      Face_Default_Flags ^= FACES_DOUBLE_SIDED_FLAG;
  }
  return D_REDRAW;
}
