/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef OBJCTRLHPP
#define OBJCTRLHPP

#include "obj.h"
#include <allegro.h>
#include "define.h"
#include "drawrect.h"

// something for us to edit
class DummyObjectClass : public ObjectClass
{
public:
  int X, Y, W, H;
  DummyObjectClass() : ObjectClass() { X=Y=W=H= -1; };
};

#define INDEX_TYPE 0x4000   // used by Get_Properties to indicate that the user will need
#define DDLIST_TYPE 0x2000  // dito - function pointed to get different indexed values
// to use Set_Properties in order to change the value
#define TYPE_MASK  0x0FFF   // used to remove the above qualifers


// base class for creator of any object based on objectclass
class ObjectControlClass
{
public:
  int Type;  // must match reference in ObjectControlClasses[]
  char* Name;  // type of object this controls
  unsigned Properties;  // object properties
  bool Visible;  // is this type visible
  int Color;   // if color by type
  bool RetainZ;  // use existing z property rather than current visuals depth value
  // used in visulist to indicate an edit rather than a creation
  // really a 3D feature but include here for simpler inheritance

  ObjectControlClass() { Type = 0; Name = "Dummy"; Properties = 4; Visible = true; };
  virtual ObjectClass* Create();
  virtual void NewWorld(ObjectClass*) {};  // used edit.cpp for Vertex paste in edit3d app
  virtual void NewForOld(ObjectClass*,ObjectClass*,ObjectClass*) {}; // used in edit.cpp paste
  virtual void Remove(ObjectClass*);
  virtual long Size();
  virtual bool Match(ObjectClass*) { return(true); };
  virtual bool DependantOn(ObjectClass*,ObjectClass*) { return(false); };
  virtual bool Include(ObjectClass*,int,int,int,int);
  virtual bool Inside(ObjectClass*,int,int);
  virtual int Distance(ObjectClass*,int,int) { return(MAXINT); };
  virtual void SetColor(int fg,int,int) { Color = fg; }; // called in edit3d.cpp
  virtual int GetProperty(ObjectClass*,int n, void** p, char** name,
                                           void**); // returns type or -1 for fail
  virtual int Summary(ObjectClass*,char*,int,int = 0);
  virtual int SetProperty(ObjectClass*,int n, void* p);
  virtual void GetRealLimits(ObjectClass* object, fixed&,fixed&,fixed&,fixed&,fixed&,fixed&) {};
       // does nothing for Dummy Object
  virtual bool GetLimits(ObjectClass*,int&,int&,int&,int&);
  virtual void SetLimits(ObjectClass*,int,int,int,int);
  virtual void Draw(BITMAP*,ObjectClass*);
  virtual void Indicate(BITMAP*,ObjectClass*,int,int,int,int,int,int);
};

extern ObjectControlClass* ObjectControlClasses[];

#endif
