/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "objctrl.h"

ObjectControlClass Dummy;
ObjectControlClass* ObjectControlClasses[] = { &Dummy, NULL };
// ControlClasses[] needs to be set to something usefull before Init_Controller is reached

#define OBJECT ((DummyObjectClass*)object)

ObjectClass* ObjectControlClass::Create()
{
  return(new DummyObjectClass);
}

void ObjectControlClass::Remove(ObjectClass* object)
{
  delete object;
}

long ObjectControlClass::Size()
{
  return(sizeof(DummyObjectClass));
}

bool ObjectControlClass::Inside(ObjectClass*,int,int)
{
  return(TRUE);
}

bool ObjectControlClass::Include(ObjectClass*,int,int,int,int)
{
  return(TRUE);
}

// should be called Get Pointer to and Name of Property
int ObjectControlClass::GetProperty(ObjectClass* object, int n, void** p, char** name,
                                                         void** select_function)
{
  *select_function = NULL;
  switch(n)
  { case 0:
      *p = &(OBJECT->X);
      *name = "X";
      return(INT_TYPE);
    case 1:
      *p = &(OBJECT->Y);
      *name = "Y";
      return(INT_TYPE);
    case 2:
      *p = &(OBJECT->W);
      *name = "W";
      return(INT_TYPE);
    case 3:
      *p = &(OBJECT->H);
      *name = "H";
      return(INT_TYPE);
  }
  return(-1);
}

int ObjectControlClass::Summary(ObjectClass* object,char* str, int maxstr, int flags)
{ // should check for maxstr but I'm naughty
  int i = uszprintf(str,maxstr,Name);
  i += uszprintf(str+i,maxstr-i,"{%d,%d,%d,%d}",OBJECT->X,OBJECT->Y,OBJECT->W,OBJECT->H);
  return(i);
}

//  probable not needed at GetProperty delivers pointer
int ObjectControlClass::SetProperty(ObjectClass* object, int n, void* p)
{
  switch(n)
  { case 0:
      OBJECT->X = *((int*)p);
      break;
    case 1:
      OBJECT->Y = *((int*)p);
      break;
    case 2:
      OBJECT->W = *((int*)p);
      break;
    case 3:
      OBJECT->H = *((int*)p);
      break;
    default:
      return(-1);
  }
  return(0);
}


bool ObjectControlClass::GetLimits(ObjectClass* object,int& x,int& y,int& w,int& h)
{
  x = OBJECT->X;
  y = OBJECT->Y;
  w = OBJECT->W;
  h = OBJECT->H;
  return(TRUE);
}

void ObjectControlClass::SetLimits(ObjectClass* object,int x,int y,int w,int h)
{
  OBJECT->X = x;
  OBJECT->Y = y;
  OBJECT->W = w;
  OBJECT->H = h;
}

void ObjectControlClass::Draw(BITMAP* bmp,ObjectClass* object)
{
  if(Visible)
    rect(bmp,OBJECT->X,OBJECT->Y,OBJECT->X+OBJECT->W,OBJECT->Y+OBJECT->H,255);
}

void ObjectControlClass::Indicate(BITMAP* bmp,ObjectClass* object,int x1, int y1,
                                                     int x2 ,int y2, int fg, int bg)
{
  dotted_rect(bmp,x1-1,y1-1,x2+1,y2+1,fg,bg);
}


