/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "mpoint.h"

BITMAP *resize_pointer_h  = NULL;
BITMAP *resize_pointer_v  = NULL;
BITMAP *resize_pointer_d1 = NULL;
BITMAP *resize_pointer_d2 = NULL;
BITMAP *crosshair_pointer = NULL;
BITMAP *magglass_pointer  = NULL;
BITMAP *selection_pointer1  = NULL;
BITMAP *selection_pointer2  = NULL;

// data - needs to be put in a datafile one day

char resize_pointer_data1[] =
{
    1,1,1,1,1,1,0,0,0,0,
    1,2,2,2,1,0,0,0,0,0,
    1,2,2,1,0,0,0,0,0,0,
    1,2,1,2,1,0,0,0,0,0,
    1,1,0,1,2,1,0,0,0,1,
    1,0,0,0,1,2,1,0,1,1,
    0,0,0,0,0,1,2,1,2,1,
    0,0,0,0,0,0,1,2,2,1,
    0,0,0,0,0,1,2,2,2,1,
    0,0,0,0,1,1,1,1,1,1
};

char resize_pointer_data2[] =
{
    0,0,0,1,1,0,0,0,0,1,1,0,0,0,
    0,0,1,2,1,0,0,0,0,1,2,1,0,0,
    0,1,2,2,1,1,1,1,1,1,2,2,1,0,
    1,2,2,2,2,2,2,2,2,2,2,2,2,1,
    0,1,2,2,1,1,1,1,1,1,2,2,1,0,
    0,0,1,2,1,0,0,0,0,1,2,1,0,0,
    0,0,0,1,1,0,0,0,0,1,1,0,0,0
};

char crosshair_pointer_data[] =

{  0,0,0,0,1,2,0,0,0,0,
   0,0,0,0,1,2,0,0,0,0,
   0,0,0,0,1,2,0,0,0,0,
   0,0,0,0,1,2,0,0,0,0,
   1,1,1,1,0,0,1,1,1,1,
   0,2,2,2,0,0,2,2,2,2,
   0,0,0,0,1,2,0,0,0,0,
   0,0,0,0,1,2,0,0,0,0,
   0,0,0,0,1,2,0,0,0,0,
   0,0,0,0,1,2,0,0,0,0,
};

char magglass_pointer_data[] =

{  0,0,1,1,1,1,0,0,0,0,
   0,1,2,2,2,2,1,0,0,0,
   1,2,0,0,0,0,0,1,0,0,
   1,2,0,0,0,0,0,1,2,0,
   1,2,0,0,1,0,0,1,2,0,
   1,2,0,0,0,2,0,1,2,0,
   0,1,0,0,0,0,1,2,0,0,
   0,0,1,1,1,1,2,1,0,0,
   0,0,0,2,2,2,0,2,1,0,
   0,0,0,0,0,0,0,0,2,1,
};

char selection_pointer1_data[] =

{  1,0,0,0,0,0,0,0,0,1,
   2,1,0,1,0,0,0,0,1,2,
   0,2,1,1,0,0,0,1,2,0,
   0,1,1,1,0,0,1,1,1,0,
   0,2,2,2,0,0,2,2,2,0,
   0,0,0,0,0,0,0,0,0,0,
   0,1,1,1,0,0,1,1,1,0,
   0,0,1,1,0,0,1,1,0,0,
   0,1,2,1,0,0,1,2,1,0,
   1,2,0,0,0,0,0,0,2,1,
};

char selection_pointer2_data[] =

{  1,1,1,1,0,0,1,1,1,1,
   1,2,2,2,0,0,2,2,2,1,
   1,2,0,0,0,0,0,0,2,1,
   1,2,0,0,0,0,0,0,2,1,
   0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,
   1,2,0,0,0,0,0,0,2,1,
   1,2,0,0,0,0,0,0,2,1,
   1,2,2,2,0,0,2,2,2,1,
   1,1,1,1,0,0,1,1,1,1,
};

void Init_Mouse()
{ // mouse pointers
  resize_pointer_d1 = Create_Bitmap(resize_pointer_data1, 10, 10, 0);
  resize_pointer_d2 = Create_Bitmap(resize_pointer_data1, 10, 10, 2); // horzflip
  resize_pointer_h  = Create_Bitmap(resize_pointer_data2, 14, 7,  0);
  resize_pointer_v  = Create_Bitmap(resize_pointer_data2, 7,  14, 1); // rotated
  crosshair_pointer = Create_Bitmap(crosshair_pointer_data, 10,10,10);
  magglass_pointer  = Create_Bitmap(magglass_pointer_data,10,10,10);
  selection_pointer1 = Create_Bitmap(selection_pointer1_data,10,10,10);
  selection_pointer2 = Create_Bitmap(selection_pointer2_data,10,10,10);
}

void Deinit_Mouse()
{
  destroy_bitmap(selection_pointer2);
  destroy_bitmap(selection_pointer1);
  destroy_bitmap(magglass_pointer);
  destroy_bitmap(crosshair_pointer);
  destroy_bitmap(resize_pointer_v);
  destroy_bitmap(resize_pointer_h);
  destroy_bitmap(resize_pointer_d2);
  destroy_bitmap(resize_pointer_d1);
}

