/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "linklist.h"

void (*Link_Notify)(void*) = NULL;  // LinkClass will call this function if there is a removal
// it may inturn link to other functions
// in a typical usage it would notify the mouse operators that this object nolonger exists

LinkClass* BaseLinkMaker(ObjectClass* object)
{ return(new LinkClass(object));
}

LinkClass::LinkClass(ObjectClass* object)
{
  Object = object;
  Object->References++;
  Previous = NULL;
  Next = NULL;
  Selected = 0;
}

LinkClass::~LinkClass()
{ if(Link_Notify)
    Link_Notify(this);   // "I'm leaving; don't call me here again!"
  if(Previous)
    Previous->Next = Next;
  if(Next)
    Next->Previous = Previous;
  if(Object) {
    if(Object->References)
      Object->References--;  // some one elses responsibility to get rid of it
    if(Object->DeleteOnZero && Object->References == 0)
      delete Object;
  }
}

void LinkClass::Destroy_Followers()
{ while(Next)   // note that this takes no notice of the undone limit
  { delete Next;
    Next = NULL;
  }
}

int LinkClass::Promote()
{
  if(!Previous)  // the buck stops here so no promotion
    return(0);
  // fix old slave up
  LinkClass* oldboss = Previous;
  if(Next)
    Next->Previous = oldboss;    // show old boss to old slave
  // fix up old boss
  oldboss->Next = Next;
  // set new boss
  Previous = Previous->Previous;
  // set new slave
  Next = oldboss;                // old boss is your slave
  Next->Previous = this;          // say "me your boss now"
  Previous->Next = this;          // say "hi boss"
  return(1);
}

int LinkClass::Demote()
{
  if(!Next)  // already at the bottom
    return(0);
  LinkClass* oldslave = Next;
  // fix old boss
  if(Previous)
    Previous->Next = oldslave;
  // fix old slave
  oldslave->Previous = Previous;
  // set new slave
  Next = Next->Next;
  Previous = oldslave;
  Previous->Next = this;  // say "Hi"
  Next->Previous = this;  // say "I'm your new boss"
  return(1);
}

LinkClass* L; // used in define macro below but defined here so compiler knows about it
// previously I had an link called 'l' here and another in a function argument and the
// compiler didn't complain.
#define BEGIN_LIST L = Start; while(L && L != Undone) {
#define END_LIST   L = L->NextLink(); }

ListClass::ListClass()
{
  Start = NULL;
  Undone = NULL;   // artifical end for temporarily undoing
  LinkMaker = BaseLinkMaker;
}

ListClass::~ListClass()
{
  Clear();
}

void ListClass::UnDo()
{ if(Undone)
    Undone = Undone->Previous;
  else  // find last
  { LinkClass* t = Start;
    while(t->Next)
      t = t->Next;
    Undone = t;
  }
}

bool ListClass::CanUnDo()
{ return(Start != NULL);
}

void ListClass::ReDo()
{ if(Undone)
    Undone = Undone->Next;
}

bool ListClass::CanReDo()
{ return(Undone != NULL);
}

void ListClass::Cat(LinkClass* link)
{
  // find end of list
  if(!Start)
    Start = link;
  else
  { if(Undone && Undone->Previous)  // use undone as the end point
    { Undone->Previous->Next = link;
      Destroy_Undone();  // would get too confusing otherwise I think
    }
    else // find the end
    { LinkClass* t = Start;
      while(t->Next)    // no need to worry about undone
        t = t->Next;
      t->Next = link;
      link->Previous = t;  // there must be a previous or there'd be no Start
    }
  }
}

void ListClass::Insert(LinkClass* link, LinkClass* p)
{
  if(p)
  { if(p->Previous)
    { p->Previous->Next = link;
      link->Previous = p->Previous;
    }
    else
      Start = link;
    p->Previous = link;
    link->Next = p;
  }
  else
    Cat(link);
}

LinkClass* ListClass::Add(ObjectClass* obj, LinkClass* p)
{
  LinkClass* link = LinkMaker(obj);
  Insert(link,p);
  return(link);
}

// copy doesn't copy object, just reference to it
LinkClass* ListClass::Copy(LinkClass* link, LinkClass* p)
{ return(Add(link->Object,p));
}

void ListClass::Clear()
{
  if(Start)
  { Start->Destroy_Followers();  // this egnors undone limit
    delete Start;
  }
  Start = NULL;
  Undone = NULL;
}

void ListClass::Destroy(LinkClass* link)
{ if(Undone && link == Undone)
    Undone = Undone->Next;
  if(link == Start)
    Start = link->Next;
  // delete link; done by caller
}

void ListClass::Destroy_Undone()
{ if(Undone)
  { Undone->Destroy_Followers();
    delete Undone;
  }
  Undone = NULL;
}

void ListClass::Update()
{
  BEGIN_LIST
    L->Update();
  END_LIST
}

void ListClass::Select(bool s)
{
  BEGIN_LIST
    L->Selected= s;
  END_LIST
}

void ListClass::Select_All(void)
{
  Select(TRUE);
}

void ListClass::Select_None(void)
{
  Select(FALSE);
}

void ListClass::SelectOnly(LinkClass* link)
{
  Select_None();
  link->Selected = TRUE;
}

void ListClass::Invert_Selection(void)
{
  BEGIN_LIST
    L->Selected = !L->Selected;
  END_LIST
}

int ListClass::Promote(LinkClass* link)
{
  if(!Start)
    return(0);
  if(Start->Next == link)
    Start = link;
  return(link->Promote());
}

int ListClass::Demote(LinkClass* link)
{
  if(!Start || !link->Next)
    return(0);
  if(link == Start)
    Start = link->Next;
  return(link->Demote());
}

void ListClass::Delete_Selected()
{
  BEGIN_LIST
    LinkClass* nl = L->Next; // shouldn't really use it after it's deleted so save next link
    if(L->Selected) {
      Destroy(L);
      delete L;
    }
    L = nl;
  }
}

LinkClass* ListClass::First_Selected(unsigned* n)
{ int i = 0;
  BEGIN_LIST
    if(L->Selected)
      return(L);
    i++;
    if(n)
      *n = i;
  END_LIST
  return(NULL);
}

LinkClass* ListClass::Find(unsigned n)
{
  int i = 0;
  BEGIN_LIST
    if(i == n)
      return(L);
    i++;
  END_LIST
  return(NULL);
}

int ListClass::Find(ObjectClass* obj)
{
  int i = 0;
  BEGIN_LIST
    if(L->Object == obj)
      return(i);
    i++;
  END_LIST
  return(-1);
}

/*  though this was necessary at one stage
ObjectClass* ListClass::Find_Gozump(unsigned n, ObjectClass* obj)
{
  LinkClass* l = Find(n);
  if(!l)
    return NULL;
  if(l->Object) {
    if(l->Object == obj)  // no change to object references
      return(l->Object);
    l->Object->References++;
    if(obj)
      obj->References--;
  }
}
*/

