/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* A template for an Allegro Editor of anything graphic
 * Borrowed from Dialog Editor (dlg) by Julien Cugniere (2001)
 * [uos@free.fr or webpage uos.free.fr/dlg_src_bgui.zip]
 * Stipped down by Robert Parker [rpact@dingoblue.net.au ,or webpage www.dingoblue.net.au/~rpact]
 *
 * bscinit.c : This file deals with settings up and launching the editor.
 *
 */

#include "bscedit.h"
#include <bgui/tdgui.h>


//DATAFILE *datafile;

/* This is a function that will initialize all that is needed by our custom
 * procs, and will take care of run-time initialized params (like BITMAPs).
 * We can change the gui_* variables of allegro, and the font too, they will
 * affect the edited dialog (but _not_ the editor).
 */

void bgui_procs_init(void)
{
    /* If you want the edited dialog (_not_ the editor) to use my thin font,
     * just uncomment these lines.
     */

    /*
    if((datafile = load_datafile("font.dat")) != NULL)
	font = datafile[0].dat;
    */
    bill_init();
//    bill_init_smallpal(48);  // after, NOT before bill_init
// as long as all the bill colors (greys plus dark blue) are available, this is
// not necessary
    set_gui_mode(1);
}


/* The main function of the editor. Here we just need to call our init
 * function, and register_proc_set().
 */
int main(int argc, char *argv[])
{
  int i;
  int bpp = 0;    // will load config or revert to 8 bit if not changed by argument
  int w   = 0;    // ditto to 640
  int h   = 0;    // ditto to 400
  char *s, tmp[256];
  char *path = NULL;
  char *name = NULL;

  set_uformat(U_ASCII);
  set_config_file("config.cfg");  
  allegro_init();

    // processing of command line arguments
  for(i=1; i<argc; i++)
  {
    if((argv[i][0] == '-') || (argv[i][0] == '/'))
    {
      if((ustrchr(argv[i], 'x')) || (ustrchr(argv[i], 'X')))   // egnor x or X
      { ustrcpy(tmp, argv[i]+1);
        s = ustrtok(tmp, "xX");
        if(s)
        {  w = atoi(s);
           s = ustrtok(NULL, "xX");
           if(s)
             h = atoi(s);
           else
             h = 0;
        }
        else
          w = 0;
        bpp = atoi(argv[i]+1);
      }
      else
      {
        if(!path)
          path = argv[i];
        else
          name = argv[i];
      }
    }
  }

  // setting up the editor
  install_keyboard();
  install_mouse();
  install_timer();

  Screen_Mode = new AllegroScreenClass(w,h,bpp);

  PALETTE pal;
  get_palette(pal);
  Rainbow_Palette(pal);
  set_pallete(pal);

  gui_fg_color = makecol(0, 0, 0);
  gui_bg_color = makecol(255, 255, 255);

  // Adding support for custom procs
  bgui_procs_init();
//    register_proc_set(bgui_procs, "bgui");

  // Launching the editor
//    if(path)
//	load_target(path, name);  // replace target with what ever your editiing
  basic_editor();
  delete Screen_Mode;
  return 0;
}

END_OF_MAIN();
