/*  Source file for the BasicGUI program by Robert Parker using the Allegro
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* A template for an Allegro Editor of anything graphic
 * Borrowed from Dialog Editor (dlg) by Julien Cugniere (2001)
 * [uos@free.fr or webpage uos.free.fr/dlg_src_bgui.zip]
 * Stipped down by Robert Parker 
 *
 * bscedit.c : The core functions of the editor
 *
 */

#include "bscedit.h"
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include "objctrl.h"
#include "edit.h"
#include "fileopen.h"

VisualListClass TemporaryList;     // clipboard for cut and paste

//PROC *proc_list = NULL;
//PROC *new_object = NULL;
DIALOG_PLAYER *Editor_Player = NULL;
DATAFILE *FontFile = NULL;

/* gui settings of the edited dialog ( != those of the editor ) */
FONT* Back_font;
int Back_baseline, Back_mouse_focus;


void Init_Editor();
void Deinit_Editor();
void Set_Editor_Gui_State();
void Set_Back_Gui_State();

/* menu callbacks */
int About();
int Closer();
int Mover();
int Font_Checker();
int Snaper();
int Gui_Setter();
int Gui_Color_Setter();
int Color_Selected();
int Source_Viewer();
int Shift_Up();
int Shift_Down();

/* dialog procs */
int Workspace_proc(int, DIALOG*, int);
int Drag_New_Object(void);

/* strings functions */
char *Get_Copy(char*);

int Screen_Change()
{
//  Screen_Mode->ChangeMode(Screen_Mode->W,Screen_Mode->H,Screen_Mode->BPP,TRUE);
//  bill_init_radio_buttons();
  return D_REDRAW;
}

/******************************************/
/********** The menus & dialogs ***********/
/******************************************/

MENU Menu_dialog[] =
{
//  (text)                  (proc)      (child)     (flags)     (dp)
    { "&New\tCtrl-N",       Newer,      NULL,       0,          NULL },
    { "&Open\tCtrl-O",      Opener,     NULL,       0,          NULL },
    { "",                   NULL,       NULL,       0,          NULL },
    { "&Save\tCtrl-S",      Saver,      NULL,       0,          NULL },
    { "Save &As...",        Save_As,    NULL,       0,          NULL },
    { "",                   NULL,       NULL,       0,          NULL },
    { "&Quit\tCtrl-Q",      Closer,     NULL,       0,          NULL },
    { 0 }
};

MENU Menu_selection[] =
{
//  (text)                  (proc)              (child)     (flags)     (dp)
    { "Select &None",       Select_None,        NULL,       0,          NULL },
    { "Select &All\tCtrl-A",Select_All,         NULL,       0,          NULL },
    { "&Invert\tCtrl-I",    Invert_Selection,   NULL,       0,          NULL },
    { "",                   NULL,               NULL,       0,          NULL },
    { "C&ut\tCtrl-T",       Cutter,             NULL,       0,          NULL },
    { "C&opy\tCtrl-C",      Copier,             NULL,       0,          NULL },
    { "Pa&ste\tCtrl-P",     Paster,             NULL,       0,          NULL },
    { "",                   NULL,               NULL,       0,          NULL },
    { "&Edit List",         Selection_Editer,   NULL,       0,          NULL },
    { "Set &Colors",        Color_Selected,     NULL,       0,          NULL },
    { "&Properties",        Properties,         NULL,       0,          NULL },
    { "&Snap Now!",         Snaper,             NULL,       0,          NULL },
    { 0 }
};

MENU Menu_Options[] =
{
//  (text)                 (proc)         (child)  (flags)  (dp)
    { "&Screen Mode",      Screen_Change, NULL,    0,       NULL },
    { "Gui &Settings",     Gui_Setter,    NULL,    0,       NULL },
    { "&Ega Colors",       Ega_Color_Setter, NULL, 0,       NULL },
    { "Use &Default Font", Font_Checker,  NULL,    0,       NULL },
    { "",                  NULL,          NULL,    0,       NULL },
//    { "&View Source",      source_viewer, NULL,    0,       NULL },
//    { "",                  NULL,          NULL,    0,       NULL },
    { "&About...",         About,         NULL,    0,       NULL },
    { 0 }
};

MENU Menu[] =
{
//  (text)          (proc)          (child)         (flags)     (dp)
    { "&File",      NULL,           Menu_dialog,    0,          NULL },
    { "&Selection", NULL,           Menu_selection, 0,          NULL },
    { "&Grid",      NULL,           Menu_Grid,      0,          NULL },
    { "&Add",       NULL,           NULL,           0,          NULL },
    { "Move&!",     Mover,          NULL,           0,          NULL },
    { "&Options",   NULL,           Menu_Options,   0,          NULL },
    { 0 }
};

MENU Menu_right_click[] = 
{
//  (text)              (proc)          (child)     (flags)     (dp)
    { "&Add",           NULL,           NULL,       0,          NULL },
    { "",               NULL,           NULL,       0,          NULL },
    { "C&ut",           Cutter,         NULL,       0,          NULL },
    { "C&opy",          Copier,         NULL,       0,          NULL },
    { "Pa&ste",         Paster,         NULL,       0,          NULL },
    { "",               NULL,           NULL,       0,          NULL },
    { "Set &Colors",    Color_Selected, NULL,       0,          NULL },
    { "&Properties",    Properties,     NULL,       0,          NULL },
    { 0 }
};


DIALOG editor[] =
{
   /* (proc)          (x) (y) (w) (h) (fg) (bg) (key)   (flags) (d1)      (d2) (dp)              (dp2) (dp3) */
   { Workspace_proc,  0,  0,  0,  0,  0,   0,   0,      0,      0,        0,   NULL,             NULL, NULL },
   { d_billmenu_proc, 0,  0,  0,  0,  0,   0,   0,      0,      0,        0,   Menu,             NULL, NULL },
   { d_keyboard_proc, 0,  0,  0,  0,  0,   0,   C('q'), 0,      0,        0,   Closer,           NULL, NULL },
   { d_keyboard_proc, 0,  0,  0,  0,  0,   0,   C('a'), 0,      0,        0,   Select_All,       NULL, NULL },
   { d_keyboard_proc, 0,  0,  0,  0,  0,   0,   C('i'), 0,      0,        0,   Invert_Selection, NULL, NULL },
   { d_keyboard_proc, 0,  0,  0,  0,  0,   0,   C('t'), 0,      0,        0,   Cutter,           NULL, NULL },
   { d_keyboard_proc, 0,  0,  0,  0,  0,   0,   C('c'), 0,      0,        0,   Copier,           NULL, NULL },
   { d_keyboard_proc, 0,  0,  0,  0,  0,   0,   C('p'), 0,      0,        0,   Paster,           NULL, NULL },
   { d_keyboard_proc, 0,  0,  0,  0,  0,   0,   C('n'), 0,      0,        0,   Newer,            NULL, NULL },
   { d_keyboard_proc, 0,  0,  0,  0,  0,   0,   C('o'), 0,      0,        0,   Opener,           NULL, NULL },
   { d_keyboard_proc, 0,  0,  0,  0,  0,   0,   C('s'), 0,      0,        0,   Saver,            NULL, NULL },
   { d_keyboard_proc, 0,  0,  0,  0,  0,   0,   0,      0,    KEY_INSERT, 0,   Inserter,         NULL, NULL },
   { d_keyboard_proc, 0,  0,  0,  0,  0,   0,   0,      0,      KEY_DEL,  0,   Deleter,          NULL, NULL },
   { NULL,            0,  0,  0,  0,  0,   0,   0,      0,      0,        0,   NULL,             NULL, NULL }
};

/******************************************/
/********* Some dialog procedures *********/
/******************************************/

/* workspace_proc */
int Workspace_proc(int msg, DIALOG *d, int c)
{
  int ret = D_O_K;
  int ox, oy;
//  BITMAP *back_screen;  // see remarks in case REDRAW
  VisualLinkClass* t;
  switch(msg)
  {
    case MSG_START:

      d->w = SCREEN_W;   //Screen_Mode->W;
      d->h = SCREEN_H;   //Screen_Mode->H;
      d->dp = (void*)ScreenBuffer;
      TargetList->Update();
      // get the mouse to use correct colours
      set_mouse_sprite(NULL);
      break;

    case MSG_END:
      // Screen_Mode removes BackBuffer
      break;

    case MSG_CLICK:

      ox = mouse_x;
      oy = mouse_y;
      if(mouse_b & 1)
      {
        if(New_Object)  // create a new object
          ret |= Drag_New_Object();
        else if(Menu_new[1].flags & D_SELECTED)  // paste mode
          ret |= Mouse_Paste();
        else if( (t = TargetList->Find_Mouse_Object()) && !(key_shifts & KB_ALT_FLAG))
        { if(!t->Selected)   // not selected
            TargetList->SelectOnly(t);
          // If the user release the mouse button without moving, just select the object
          while(!(ox-mouse_x || oy-mouse_y))
          { if(!mouse_b)
            { if(!(key_shifts & KB_CTRL_FLAG || key_shifts & KB_SHIFT_FLAG))
                TargetList->SelectOnly(t);
              else
                t->Selected = !(key_shifts & KB_SHIFT_FLAG);
              return D_REDRAW;
            }
          }

          // decide if this is a move or a resize
          if( mouse_x >= t->X+3 && mouse_x < t->X + t->W - 3
              && mouse_y >= t->Y+3 && mouse_y < t->Y + t->H - 3 )
            ret |= TargetList->Drag_Move(t,ox,oy);
          else
            ret |= t->Drag_Resize(ox,oy);
        }
        else
        { while(!(ox-mouse_x || oy-mouse_y))
          { if(!mouse_b)
            { TargetList->Select_None();
              return D_REDRAW;
            }
          }
          if(!(key_shifts & KB_CTRL_FLAG) && !(key_shifts & KB_SHIFT_FLAG))
          {    // find if least one target that was selected
            BEGIN_TARGETLIST
              if(target->Selected)
                return(TargetList->Drag_Move(target,ox,oy));
            END_TARGETLIST
          }
          ret |= TargetList->Drag_Select();
        }
      }
      else if(mouse_b & 2)
      {
        t = TargetList->Find_Mouse_Object();
    /*    if(New_Object)
        {
          New_Object = NULL;
          while(mouse_b)
            broadcast_dialog_message(MSG_IDLE, 0);
        }
        else
        {  */
          set_mouse_sprite(NULL);
          if(t)
          {
            if(!t->Selected)
              TargetList->SelectOnly(t);
          }
          do_billmenu(Menu_right_click, mouse_x, mouse_y);
          ret |= D_REDRAW;
     //   }
      }
      break;

    case MSG_DCLICK:

      set_mouse_sprite(NULL);
      while(mouse_b)
        broadcast_dialog_message(MSG_IDLE, 0);
      ret |= Properties();
      break;

    case MSG_LOSTMOUSE:

      if(mouse_sprite != _mouse_pointer)
        set_mouse_sprite(_mouse_pointer);
      break;

    case MSG_DRAW:

      // just incase they've changed
      d->w = SCREEN_W;  // Screen_Mode->W;
      d->h = SCREEN_H;  // Screen_Mode->H;
      d->dp = (void*)ScreenBuffer;
      
      clear_to_color(ScreenBuffer, makecol(127, 127, 127));

      Draw_Grid(ScreenBuffer);

//    Slight of hand in original dlg program to force drawing to bitmap
//    nolonger needed for my purposes but I'll keep it here as a reminder
//      back_screen = screen;
//      screen = ScreenBuffer;  // just in case some targets draw to screen
      Set_Back_Gui_State();

      TargetList->Draw_All(ScreenBuffer);
      Set_Editor_Gui_State();
//      screen = back_screen;

      TargetList->Indicate_Selected(ScreenBuffer);

      blit(ScreenBuffer, screen, 0, 0, 0, 0, ScreenBuffer->w, ScreenBuffer->h);

      break;

    }

    return ret;
}
// let the user drag the shape of a new object, and then create it

int Drag_New_Object(void)
{
    int x1, y1, x2, y2;
    x1 = mouse_x;
    y1 = mouse_y;
    Drag_Rectangle(&x1, &y1, &x2, &y2, TRUE);

    if(x1!=x2 && y1!=y2 && New_Object)
    {
      // create a new object
      ObjectClass* obj = New_Object->Create();
      // connect to a visual link
      
      target = TargetList->Add(obj,New_Object);
      target->X = x1;
      target->Y = y1;
      target->W = x2 - x1 + 1;
      target->H = y2 - y1 + 1;
      target->Control->SetLimits(target->Object,target->X,target->Y,target->W,target->H);

      TargetList->SelectOnly(target);
    }

    return D_REDRAW;
}


/******************************************/
/********** The menu functions ************/
/******************************************/



int Snaper(void)
{
  TargetList->Snap_Selected();
}


/* a simple 'about' box */
int About(void)
{
    billalert(" About...", "Allegro Editor by Robert Parker 2001", ALLEGRO_PLATFORM_STR, "based on Dialog Editor,Julien Cugniere (2001)", "&Ok", 'o', 0);
    return D_O_K;
}



/* 'close' menu function */
int Closer(void)
{
   if(billalert(" Warning", "Really want to quit?", NULL, "Sure", "No", 13, 27) == 1)
     return D_CLOSE;

   return D_O_K;
}



/* move the menu bar around so that it doesn't get in the way */
int Mover(void)
{
  if(editor[1].y == 0)
    editor[1].y = SCREEN_H/2;
  else
    editor[1].y = 0;

  return D_REDRAW;
}



/* checks/unchecks the 'use default font' menu item */
int Font_Checker(void)
{
  active_menu->flags ^= D_SELECTED;

  if(FontFile && !(Menu_Options[3].flags & D_SELECTED))
    font = (FONT*)FontFile[0].dat;
  else
    font = &_default_font;

  editor[1].w = 0;
  SEND_MESSAGE(&editor[1], MSG_START, 0);

  return D_REDRAW;
}

/* changes the GUI global settings */
int Gui_Setter(void)
{
    char bl[30];
    int res;

    DIALOG gui_dlg[] =
    {
       /* (proc)            (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)                   (dp2)           (dp3) */
       { d_billwin_proc,    0,   0,   248, 116, 0,   0,   0,    0,      0,   0,   (void*)" Target settings",    NULL,           NULL },
       { d_billbutton_proc, 10,  20,  80,  16,  0,   0,   13,   D_EXIT, 0,   0,   (void*)"Color",               NULL,           NULL },
       { d_billbutton_proc, 100, 20,  80,  16,  0,   0,   13,   D_EXIT, 0,   0,   (void*)"Restore",             NULL,           NULL },
       { d_billcheck_proc,  8,   60,  164, 8,   0,   0,   0,    0,      0,   0,   (void*)"Focus follows mouse",  NULL,           NULL },
       { d_billtext_proc,   8,   40,  144, 8,   0,   0,   0,    0,      0,   0,   (void*)"Font baseline",        NULL,           NULL },
       { Xedit_proc,        160, 36,  80,  16,  0,   0,   0,    0,      9,   0,   bl,                           NULL,           NULL },
       { d_billbutton_proc, 60,  92,  48,  16,  0,   0,   13,   D_EXIT, 0,   0,   (void*)"OK",                   NULL,           NULL },
       { d_billbutton_proc, 112, 92,  72,  16,  0,   0,   27,   D_EXIT, 0,   0,   (void*)"Cancel",               NULL,           NULL },
       { NULL,              0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,                         NULL,           NULL }
    };

    usprintf(bl, "%d", Back_baseline);

    if(Back_mouse_focus)
      gui_dlg[9].flags = D_SELECTED;
    else
      gui_dlg[9].flags = 0;
    
    // Do the dialog
    set_dialog_color(gui_dlg, gui_fg_color, gui_bg_color);
    centre_dialog(gui_dlg);
    res = popup_dialog(gui_dlg, 5);

    // Read data back
    if(res == 1)
      Gui_Color_Setter();
    else if(res == 2)
      Set_Editor_Gui_State();
    else if(res == 6)
    { Back_baseline = ustrtol(bl, NULL, 0);
      Back_mouse_focus = gui_dlg[4].flags & D_SELECTED;
    }
    Set_Back_Gui_State();
    return D_REDRAW;
}

int Gui_Color_Setter()
{
  int colors[3];
  colors[0] = Back_fg;
  colors[1] = Back_mg;
  colors[2] = Back_bg;
  char* back_str[] = { "Foreground","Midground","Background" };
  if(Color_Setter(colors,3,back_str))
  { Back_fg = colors[0];
    Back_mg = colors[1];
    Back_bg = colors[2];
    return D_REDRAW;
  }
  return D_OK;
}

int Color_Selected()
{
  int cf = Back_fg;
  int cm = Back_mg;
  int cb = Back_bg;
  // Back colors are used for defaults
  Gui_Color_Setter();

  BEGIN_TARGETLIST
    if(target->Selected)
      target->Control->SetColor(Back_fg,Back_mg,Back_bg);
  END_TARGETLIST

  Back_fg = cf;
  Back_mg = cm;
  Back_bg = cb;

  return D_REDRAW;
}




/**********************************************/
/******* Source code handling functions *******/
/**********************************************/


/* get a copy of a string, allocating the memory */
char *Get_Copy(char *str)
{
    char *res = (char*)malloc(NCHAR);

    if(res)
      ustrcpy(res, str);

    return res;
}



/******************************************/
/******* The main editor functions ********/
/******************************************/


/* restore editor settings */
void Set_Editor_Gui_State(void)
{
    if(FontFile && !(Menu_Options[4].flags & D_SELECTED))
      font = (FONT*)FontFile[0].dat;
    else
      font = &_default_font;

    gui_fg_color = makecol(0,   0,   0);    // black
    gui_mg_color = makecol(127, 127, 127);  // grey
    gui_bg_color = makecol(255, 255, 255);  // white
    gui_font_baseline = 0;
    gui_mouse_focus = 1;

    Back_font = font;
    Back_fg = gui_fg_color;
    Back_mg = gui_mg_color;
    Back_bg = gui_bg_color;
    Back_baseline = gui_font_baseline;
    Back_mouse_focus = gui_mouse_focus ^ D_SELECTED;
}

void Set_Back_Gui_State(void)
{
    font = Back_font;
    gui_fg_color = Back_fg;
    gui_mg_color = Back_mg;
    gui_bg_color = Back_bg;
    gui_font_baseline = Back_baseline;
    gui_mouse_focus = Back_mouse_focus ^ D_SELECTED;
}

void Update_Mouse()
{   // update the mouse cursor
    if(Editor_Player->mouse_obj == 0)
    {
      BITMAP *new_pointer = _mouse_pointer;
      int mx = mouse_x;
      int my = mouse_y;
      VisualLinkClass* t = TargetList->Find_Mouse_Object();

      if(t)   // yes object found
      {
        if(mx < t->X+3)
        {
          if(my < t->Y+3)
            new_pointer = resize_pointer_d1;
          else if(my >= t->Y+t->H-3)
            new_pointer = resize_pointer_d2;
          else
            new_pointer = resize_pointer_h;
        }
        else if(mx >= t->X+t->W-3)
        {
          if(my < t->Y+3)
            new_pointer = resize_pointer_d2;
          else if(my >= t->Y+t->H-3)
            new_pointer = resize_pointer_d1;
          else
            new_pointer = resize_pointer_h;
        }
        else if(my < t->Y+3 || my >= t->Y+t->H-3)
          new_pointer = resize_pointer_v;
      }

      if(mouse_sprite != new_pointer)
      {
        scare_mouse();
        set_mouse_sprite(new_pointer);
        if(new_pointer != _mouse_pointer)
          set_mouse_sprite_focus(new_pointer->w/2, new_pointer->h/2);
        unscare_mouse();
      }
    }
}

/* editor initialization */
char Initialized = FALSE;
void Init_Editor(void)
{
  if(!Initialized)
  {
    Initialized = TRUE;

    FontFile = load_datafile("font.dat");
    if(!FontFile)
      Menu_Options[3].flags = D_DISABLED;
    else
      Menu_Options[3].flags = 0;
    Register_Object_Set(ObjectControlClasses);
    Menu[3].child = Menu_right_click[0].child = Menu_new;

    Init_Grid();
    Init_Mouse();

    TargetList = &TemporaryList;   // current edit target - TargetList lives in edit.cpp
  }
}

/* editor cleanup */
void Deinit_Editor(void)
{
    int i;
    
    if(!Initialized)
      return;
    Initialized = FALSE;
    Deinit_Mouse();
    unload_datafile(FontFile);
}




/* execute the dialog editor */
void basic_editor(void)
{
  show_mouse(screen);
  Init_Editor();
  clear_keybuf();
  Set_Editor_Gui_State();
  Editor_Player = init_dialog(editor, -1);

  while(update_dialog(Editor_Player))
  { Update_Mouse();
    // do own stuff
  }

  shutdown_dialog(Editor_Player);
  Set_Back_Gui_State();
  Editor_Player = NULL;
  Deinit_Editor();
}
