/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "bitmap.h"

/* create a mouse bitmap from an array */
// o: 0=normal 1=rotate 2=horzflip
BITMAP* Create_Bitmap(char *data, int w, int h, int o)
{
    int x, y, c1, c2, pix;
    BITMAP *b = create_bitmap(w ,h);

    c1 = makecol(255, 255, 255);
    c2 = makecol(0, 0, 0);

    for(x=0; x<w; x++)
    { for(y=0; y<h; y++)
      {
        switch(o)
        {
          case 1:  pix = data[y + x*h];     break;  // 90dg rotate
          case 2:  pix = data[w-x-1 + y*w]; break;  // horizontal flip
          default: pix = data[x + y*w];     break;  // normal
        }

        switch(pix)
        {
          case 1:  putpixel(b ,x ,y, c1); break;
          case 2:  putpixel(b ,x ,y, c2); break;
          default: putpixel(b ,x ,y, bitmap_mask_color(screen)); break;  // transparent
        }
      }
    }
    return b;
}
