/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "alvideo.h"
// #include <allegro/winalleg.h> // for DirectX but can't get round header problems
// #include <allegro/alwin.h> //GFX_DIRECTX defined in but comes up as bad include

AllegroScreenClass* Screen_Mode = NULL;
BITMAP *ScreenBuffer = NULL;

AllegroScreenClass::AllegroScreenClass(int w = 0, int h = 0, int bpp = 0)
{
  Card = GFX_AUTODETECT;
  W  = 0;
  H  = 0;
  VW = 0;
  VH = 0;
  BPP = 0;          // to indicate no mode reached yet
  VHz = 75;         // vertical frequency
  NeedPoly = TRUE;
  if(w && h)
    ChangeMode(w, h, bpp);  // try arguments passed
  else
  { if(Load())  // no config file
      ChangeMode(640,480,bpp,TRUE);  // request user to enter new mode
      // if bpp = 0 then color change is not requested
    else
      ChangeMode(W,H,BPP);  // try mode from config file
  }
}

AllegroScreenClass::~AllegroScreenClass()
{
  set_gfx_mode (GFX_TEXT,320,200,NULL,NULL);
  Save();
  if (ScreenBuffer)
    destroy_bitmap(ScreenBuffer);
}

int AllegroScreenClass::StartMode()
{ if(set_gfx_mode (GFX_SAFE,640,480,NULL,NULL) != 0)
  { allegro_exit();
    printf("Error setting graphics mode\n%s\n\n", allegro_error);
    return 1;
  }
  W = SCREEN_W;
  H = SCREEN_H;
  BPP = 8;
  set_pallete(desktop_palette);                    
  clear_to_color(screen,gui_mg_color);
  return 0;
}

int AllegroScreenClass::ChangeMode(int w, int h, int bpp = 0,bool change = FALSE)
{
  // swap foreground and background colours - why is this necessary
  int hold=gui_fg_color;
  gui_fg_color=gui_bg_color; 
  gui_bg_color=hold;

  bool error = change;
  do
  { if(change)
    { if(!BPP || !W || !H)
        StartMode();        // needs to Allegro mode to show mode selector
      W = w;
      H = h;
      if(bpp)
        BPP = bpp;
      else
        BPP = 8;
      if(bpp || BPP != 8)        // desire to change color depth or have done once already
      { if (!gfx_mode_select_ex (&Card,&W,&H,&BPP))
        { W = SCREEN_W;
          H = SCREEN_H;
          return(0);  // pressed cancel so change nothing
        }
      }
      else
      { if (!gfx_mode_select (&Card,&W,&H)) // assumes color depth at 8bit
        { W = SCREEN_W;
          H = SCREEN_H;
          return(0);  // pressed cancel so change nothing
        }
      }
    }
    else
    { W = w;
      H = h;
      if(bpp)
        BPP = bpp;
      else
        BPP = 8;
    }
    if (NeedPoly && gfx_driver->id == GFX_MODEX)
    { alert("ERROR","Can't draw 3d polygons in mode-X, sorry!",
                                 "Choose again","&OK",NULL,NULL,NULL);
      change = true;
    }
    // check for valid color depths
    if(BPP != 8 && BPP != 15 && BPP != 16 && BPP != 24 && BPP !=32)
      BPP = 8;
    request_refresh_rate(VHz);   // worth a try but doesn't seem to work
    set_color_depth(BPP);
//   Card = GFX_DIRECTX;  // just trying - can't get round header problems
    if (set_gfx_mode (Card,W,H,VW,VH))
    {
	if(StartMode())
          return(1);
	alert("ERROR","Unsupported video mode","Choose again","&OK",NULL,NULL,NULL);				
      change = true;
    }
    else
      change = false;
  } while(change);
  W = SCREEN_W;
  H = SCREEN_H;

  text_mode(-1);  // text is transparent
  if (ScreenBuffer)
    destroy_bitmap(ScreenBuffer);
  ScreenBuffer = create_bitmap(W, H);
  return(0);
}

// intend to incorporate video config ina general config file
// otherwise 16bytes of info uses 4K of disk space

int AllegroScreenClass::Load()
{
  W = get_config_int("video","wide",640);
  H = get_config_int("video","high",480);
  BPP = get_config_int("video","bpp",8);
  return(0);
}

int AllegroScreenClass::Save()	//Save in the settings file
{
  set_config_int("video","wide",W);
  set_config_int("video","high",H);
  set_config_int("video","bpp",BPP);
  return(0);
}

