/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* Some usefull constants */
// DJGPP gives warnings about redefines hences all the indefs

#ifndef DEFINEHPP
#define DEFINEHPP

#include <stddef.h>

#ifndef TRUE
  #define TRUE   1
  #define FALSE  0  // for the americans
  #define FAULSE 0
#endif

#ifndef PI
  #define PI      3.1415927   /* Define a value for PI */
#endif
#define ON      1
#define OFF     0
#define YES     1
#define NO      0
#ifndef MIN
  #define MIN(a,b) (a<b ? a : b)          /* Macros that should have come in stlib.h */
  #define MAX(a,b) (a>b ? a : b)
#endif
#define SIGN(a)  (a<0 ? -1: 1)
#ifndef ABS
  #define ABS(a)   (a<0 ? -1*a : a)
#endif

#ifndef RTN
  #define LF    10
  #define RTN   13
  #define BKSP   8
  #define ESC   27
  #define TAB    9
  #define SPACE 32
#endif

#ifndef MAXINT
  #define MININT  -32768
  #define MAXINT   32767
#endif

#ifndef MAXLONG
  #define MINLONG -2147483648
  #define MAXLONG  2147483647
#endif

#ifndef MAXUNSIGNED
  #define MAXUNSIGNED 65535
#endif

#ifndef MAXUNSIGNEDLONG
  #define MAXUNSIGNEDLONG 4294967295
#endif

#ifndef MAXFLOAT
  #define MAXFLOAT 3.4028E38
  #define MINFLOAT -3.4028E38
#endif

#ifndef MAXDOUBLE
  #define MAXDOUBLE 1.7976E308
  #define MINDOUBLE -1.7976E308
#endif

#ifndef MAXLONGDOUBLE
  #define MAXLONGDOUBLE  1.1895E4932
  #define MINLONGDOUBLE -1.1895E4932
#endif

#define BIT(n) (1<<n)

#ifndef BYTE
  #define BYTE unsigned char
#endif
#ifndef WORD
  #define WORD unsigned
#endif

typedef enum { CHAR_TYPE,
               BYTE_TYPE,
               INT_TYPE,
               UNSIGNED_TYPE,
               LONG_TYPE,
               UNSIGNED_LONG_TYPE,
               LONG_LONG_TYPE,
               UNSIGNED_LONG_LONG_TYPE,
               FLOAT_TYPE,
               DOUBLE_TYPE,
               LONG_DOUBLE_TYPE,
               STRING_TYPE,
               BOOL_TYPE,
               UNKNOWN_TYPE } TYPE_ID;
               
#define FREE(x)     { if(x) free(x); x = NULL; }
#define C(c)        (c - 'a' + 1)

#endif
