/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef VIEWHPP
#define VIEWHPP

#include "grid.h"
#include "axis.h"
#include "visual.h"
#include "alcolor.h"

extern VisualClass Visual[];
extern int Color_Seperation_Mode;

int Checker(void);
int View_Editor();
void ReSizeViews();
void Init_Views();
void DeInit_Views();
void Draw_Views(BITMAP*);
void Refresh_Views(BITMAP*,BITMAP*);

extern MENU Menu_View[];
enum Menu_View_Children { SPLIT3D = 0, SPLIT_H, SPLIT_V, SPLIT_S, TL_VIEW, TR_VIEW, BL_VIEW, BR_VIEW,
                          AXIS_M, GRID_M, SNAP_O, STATUS_M };
extern int HSplit;
extern int VSplit;
extern int ViewsX1, ViewsX2, ViewsY1, ViewsY2;
extern int View_Gap;

void CrossHair_Limits(int& x1, int& y1, int& x2, int& y2);
int Find_View(int,int);
int Set_View(int,int,BITMAP* = NULL);
void Set_DrawingPlane(int,int);
void RestoreDepth();
void Set_Current_Visual(VisualClass*,BITMAP* = NULL);
void Update_Views();
bool Animate_Views();

extern int Status_Disp_Mode;
#include "vislst3d.h"
extern VTX* StatusVTX;
extern VTX* StatusVTX1;
extern char* StatusMsg;
void Position_Status(BITMAP* bmp, int x, int y, int xo, int yo);

int Previous_Frame();
int Next_Frame();
int Get_Real(int,int,VTX*);
void Get_Frame_Number(int*);

#endif
