/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef SPLINEHPP
#define SPLINEHPP

#include "line.h"
#define SPLINE_V1_LOCK  0x01
#define SPLINE_V2_LOCK  0x02
#define SPLINE_V1_CALC  0x04
#define SPLINE_V2_CALC  0x08
// the following flags made redundant by the Class property
//#define SPLINE_L1_SPLINE  0x10 // connecting line is a spline
//#define SPLINE_L2_SPLINE  0x20

// something for us to edit
class SplineClass : public LineClass
{
public:
  VTX V1;  // internal vectors - if 0 then use current velocity method
  VTX V2;
  unsigned Flags;  // V# locks and calc status
  SplineClass() : LineClass() { V1.X=V1.Y=V1.Z=V2.X=V2.Y=V2.Z= 0;
                                Class = SPLINE_CLASS;
                                Flags = 0;
                                  // reset calcd flags pending a fresh draw
                                };
};

#define SPLINE ((SplineClass*)object)

// base class for creator of any object based on objectclass
class SplineControlClass : public LineControlClass
{
public:
  SplineClass* Focus;
  int Vector;
  
  SplineControlClass();
  virtual ObjectClass* Create();
  virtual long Size();
  virtual bool Inside(ObjectClass*,int,int);
  void MoveVector(ObjectClass*,int,int);
  virtual bool GetLimits(ObjectClass* object,int& x,int& y,int& z,int& w,int& h,int& d);
  virtual int GetProperty(ObjectClass*,int n, void** p, char** name,
                            void**); // returns type or -1 for fail
  virtual int Summary(ObjectClass*,char*,int,int=0);
  virtual int SetProperty(ObjectClass*,int n, void* p); // -1 for fail
  void UnCalcV1(ObjectClass*);
  void UnCalcV2(ObjectClass*);
  virtual void Calc_Vectors(ObjectClass* object);
  void RealToFlat(ObjectClass* object,int* p);
  virtual void Draw(BITMAP*,ObjectClass*);
  virtual void Indicate(BITMAP*, ObjectClass*,int,int,int,int,int,int);
};

extern SplineControlClass SplineControl;

#endif
