/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "open3d.h"
#include "vislst3d.h"
#include "a3dload.h"
#include "a3dsave.h"
#include "dxfload.h"
#include "dxfsave.h"
#include "blocks.h"
#include "layers.h"

/* already defined from dir.h
#ifndef MAXPATH
#define MAXPATH 128    // don't want to use DOS.H
#endif
*/

char Save_Path[MAXPATH*2] = "";
unsigned char Save_Mode = 0;

int Backup_Checker(void)
{
  active_menu->flags ^= D_SELECTED;
}

MENU Menu_File[] =
{
//  (text)                  (proc)      (child)     (flags)     (dp)
    { "&New\tCtrl-N",       Newer,      NULL,       0,          NULL },
    { "&Open\tCtrl-O",      Opener,     NULL,       0,          NULL },
    { "",                   NULL,       NULL,       0,          NULL },
    { "&Save\tCtrl-S",      Saver,      NULL,       0,          NULL },
    { "Save &As...",        Save_As,    NULL,       0,          NULL },
    { "&BackUp",            Backup_Checker, NULL,       0,          NULL },
    { "",                   NULL,       NULL,       0,          NULL },
    { "&Quit\tCtrl-Q",      Closer,     NULL,       0,          NULL },
    { 0 }
};

/* open a file */
int Opener(void)
{
    // if files are to contain multipul chapters, revise code to dlg orginal

    int i;
    char path[MAXPATH*2];

    ustrcpy(path, Save_Path);

    if(!billfile_select("Select a source file (DXF or A3D)", path, "DXF;A3D"))
      return D_O_K;
    if(!ustrchr(path,'.'))
      ustrcat(path,".A3D");  // default load

    // open and scan the file
    FILE* file = fopen(path, "r");
    if(file == NULL)
    {  billalert(" Error", path, "Could not open the file", "&Ok", NULL, 'o', 0);
       return D_OK;
    }
    if(TargetList->FirstLink())  // just to see there is something there
    { switch(billalert3("Current Project","Add file data to existing objects",
                        "or make New project?","&Add","&New","&Cancel",
                        'a','s','c'))
      { case 1:
          // leave existing target,block and layer list and push new file on top
          break;
        case 2:
          Newer();
          break;
        case 3:
          return(D_OK);
      }
    }
    ustrcpy(Save_Path,path);
    char* suffix = ustrchr(path,'.');
    
    if(!ustricmp(suffix,".A3D"))    // does path end with .A3D
    { fclose(file);
      Save_Mode = 0;
      LoadA3D(path);
    }
    else  // assume for now that it's a dxf file of some sort
    { char c;
      if(fread(&c,1,1,file) != 1)
        return D_OK;
      fclose(file);
      if(c == 'A')  // file Binary format - header starts "AutoCad Binary DXF" etc.
      { Save_Mode = 2;
        Load_DXF_Binary(path);
      }
      else if(c == ' ' || (c >= '0' && c <= '9'))   // file ASCII format (either section start or comment)
      { Save_Mode = 1;
        Load_DXF_ASCII(path);
      }
      else
        return D_OK;
    }

    // probably need to update views here
    ((VisualList3DClass*)TargetList)->Update();

    return D_REDRAW;
}



/* 'save as' comand */
int Save_As(void)
{
    FILE *f;
    DIALOG_PLAYER *player;
    char path[MAXPATH*2];
    int i;

    ustrcpy(path, Save_Path);
    if(billfile_select("Save as *.DXF or *.A3D", path, "DXF;A3D"))
    {  // A3D is a Allegro Packed 3D object binary - bit similar to 3DS from AutoDesk
      if(!ustrchr(path,'.'))
        ustrcat(path,".A3D");  // default save
      if(exists(path))
      { if(billalert(" WARNING", path, "File already exists", "&Ok", "&Cancel", RTN, ESC)!=1)
          return D_O_K;
      }
      char* suffix = ustrchr(path,'.');
      if(!ustricmp(suffix,".DXF"))   // compare ignoring case
        Save_Mode = billalert("Save Mode","Select the drawing save mode",NULL,
                                    "&ASCII","&BINARY",'a','b');
      else
        Save_Mode = 0;   // Allegro packed Drawing eXchange file
      ustrcpy(Save_Path, path);
      Save_TargetList(path);
    }
    return D_OK;
}



/* 'save' command */
int Saver(void)
{
  if(ustrlen(Save_Path) == 0)
    return Save_As();
  Save_TargetList(Save_Path);
  return D_O_K;
}

void Save_TargetList(char *path)
{
    FILE *f;
    PACKFILE *pf;
    char bakpath[128], buff[1024];
    int n;

    if(Menu_File[5].flags & D_SELECTED)
    { // make backup of existing file
      replace_extension(bakpath, path, "bak", 128);
      remove(bakpath);  // if it exists
      if(rename(path, bakpath)!=0)
        billalert(path, "Error renaming the file to", bakpath, "&Ok", NULL, 'o', 0);
    }

    switch(Save_Mode)
    { case 0:
        SaveA3D(path);
        break;
      case 1:
        Save_DXF_ASCII(path);
        break;
      case 2:
        Save_DXF_Binary(path);
        break;
    }
}

/* start a new dialog from scratch */
int Newer(void)
{
  TargetList->Clear();
  LayerList.Clear();
  BlockList.Clear();
  usetc(Save_Path, 0);
  Save_Mode = 1;

  return D_REDRAW;
}

/* 'close' menu function */
int Closer(void)
{
   if(billalert(" Warning", "Have you saved any changes?", "Really want to quit?",
                                    "yes", "no", 'y', 'n') == 1)
     return D_CLOSE;

   return D_O_K;
}

