/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef BASIC3DCTRLHPP
#define BASIC3DCTRLHPP

#include "objctrl.h"
#include "blocks.h"
#include "layers.h"

enum OBJECT_CONTROL_TYPES { VERTEX_CONTROL =0,
    FACE_CONTROL, INSERT_CONTROL, LINE_CONTROL, ARC_CONTROL, SPLINE_CONTROL, SOLID_CONTROL };
#define OBJECT_TYPES  7
   
class Object3DControlClass : public ObjectControlClass {
public:
  bool AllLayers;
  Object3DControlClass() : ObjectControlClass() { AllLayers = false; };
  virtual bool Match(ObjectClass*,BlockClass*,LayerClass*) { return true; };
  bool Match(ObjectClass*, BlockClass*);
  virtual bool GetLimits(ObjectClass*,int&,int&,int&,int&);
  virtual bool GetLimits(ObjectClass*,int&,int&,int&,int&,int&,int&) { return false; };
};

extern Object3DControlClass* ControlClasses[];

#endif
