/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef LAYERSHPP
#define LAYERSHPP

#include "linklist.h"
#include "alcolor.h"
#include "drawline.h"
#include "texture.h"

extern unsigned Layers;
extern ListClass LayerList;

#define LAYER_VIEWS 4
// masks for View modes
#define LAYER_VIEW_FILTER 1
#define LAYER_VIEW_HIDE 2
#define LAYER_VIEW_FILTER_MASK 0xFE
#define LAYER_VIEW_HIDE_MASK 0xFD

class LayerClass : public ObjectClass
{
public:
  unsigned ID;
  char* Name;
  int Color;
  unsigned Force_Color   :1;   // force objects to use layer color
  unsigned Force_Type    :1;   // force objects to use layer line type
  unsigned Force_Texture :1;   // force objects to use layer face texture
  LINETYPE LineType;
  TextureClass* Texture;
  BYTE ViewFlags[LAYER_VIEWS];
  BYTE MatchFlag;
  LayerClass();
  ~LayerClass();
};

extern LayerClass* Action_Layer;  // the layer into which new objects are placed

char* Layer_Selector(int,int*);

#endif
