/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef DRAWLINEHPP
#define DRAWLINEHPP

#include <allegro.h>

enum LINETYPE { SOLID_LINE=0, FAINT_LINE, DITHERED_LINE, DOTTED_LINE, DASHED_LINE,
                                DASHDOT_LINE, DASHDOTDOT_LINE,
                                UNKNOWN_LINE, BYLAYER_LINE };
extern char* Line_Type_String[];
#define LINETYPES 7
extern unsigned long line_masks[];
extern unsigned long line_mask;
extern bool line_background;
extern int line_bg_color;

// call back function for allegro do_line
void putline(BITMAP *bmp, int x, int y, int color);
void drawline(BITMAP* bmp, int x1, int y1, int x2, int y2, int color, unsigned long);
void drawline(BITMAP* bmp, int x1, int y1, int x2, int y2, int color, LINETYPE type);
void dotted_line(BITMAP *bmp, int x1, int y1, int x2, int y2, int fg, int bg);
void drawarc(BITMAP *bmp, int x1, int y1,
                          int x2, int y2,
                          int x3, int y3,
                          int color, LINETYPE type);
void dotted_arc(BITMAP *bmp, int x1, int y1,
                          int x2, int y2,
                          int x3, int y3,
                          int fg, int bg);
void drawcircle(BITMAP *bmp, int x1, int y1,
                          int x2, int y2,
                          int color, LINETYPE type);
void dotted_circle(BITMAP *bmp, int x1, int y1,
                          int x2, int y2,
                          int fg, int bg);

#endif
