/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "xproc.h"

/* xbutton_proc
 *  a modified button proc that call a function instead of closing the dialog
 *  dp2 should contain the function: int func()
 */
int Xbutton_proc(int msg, DIALOG *d, int c)
{
    int ret;
    int (*proc)();
    ret = d_billbutton_proc(msg, d, c);

    if(ret == D_CLOSE && d->dp2)
    {
      proc = (int (*)())d->dp2;
      ret = proc() | D_REDRAWME;
    }

    return ret;
}



/* xedit_proc
 *  a tricky little mix of a proc, that behave like a d_edit_proc object, but
 *  - shows itself in a d_shadow_box
 *  - can have a button at its right that calls a function. The function is
 *    in dp2 in the form int func(DIALOG*), and is passed the dialog calling
 *    it. Its return value is passed back to the dialog manager. PageDown
 *    simulates a click on the button.
 */

int Xedit_proc(int msg, DIALOG *d, int c)
{
    int ret = D_O_K;
    int (*proc)(DIALOG*);

    int n = d->h-text_height(font);
    DIALOG edit =   { d_edit_proc,       d->x+n/2,         d->y+n/2, d->w-n, d->h-n, d->fg, d->bg, 0, d->flags,        d->d1, d->d2, d->dp, NULL, NULL };
    DIALOG button = { d_billbutton_proc, d->x+d->w-d->h+2, d->y+2,   d->h-4, d->h-4, d->fg, d->bg, 0, d->flags|D_EXIT, 0,     0, (void*)"...", NULL, NULL };
    d->fg = makecol(0, 0, 0);
    d->bg = makecol(255, 255, 255);

    if(d->dp2)
    {
      edit.w -= button.w;
      if(font == &_default_font)
        button.dp = (void*)"_";
      if(button.flags & D_GOTFOCUS)
        button.flags &= ~D_GOTFOCUS;
    }

    switch(msg)
    {
    case MSG_CLICK:

      if(d->dp2 && mouse_x >= button.x)
      {
        ret = d_billbutton_proc(msg, &button, c);
        if(ret & D_CLOSE)
        {
          proc = (int (*)(DIALOG *))d->dp2;
          ret = proc(d) | D_REDRAWME;
        }
      }
      else
        ret = d_edit_proc(msg, &edit, c);

      break;

    case MSG_DRAW:

      tdbox(screen, d->x, d->y, d->w, d->h, STL_FRAMEFILLED|STL_IN|STL_FRAME);
      ret = d_edit_proc(msg, &edit, c);
      if(d->dp2)
      { if(d->dp3)
        { rectfill(screen, button.x, button.y, button.x+button.w, button.y+button.h,
                 *(int*)(d->dp3));
          rect(screen, button.x, button.y, button.x+button.w, button.y+button.h,
                 d->fg);
        }
        else
          ret |= d_billbutton_proc(msg, &button, c);
      }
      break;

    case MSG_CHAR:

      if(d->dp2 && (c>>8) == KEY_PGDN)
      {
        proc = (int (*)(DIALOG *))d->dp2;
        ret = proc(d) | D_REDRAWME;
      }
      // IMPORTANT: No break here to allow continuation to default!!!!

    default:

      ret |= d_edit_proc(msg, &edit, c);
      break;
  }

  d->d1 = edit.d1;
  d->d2 = edit.d2;
  return ret;
}




/* an unknown proc. dp contains the name of the proc */
int d_unknown_proc(int msg, DIALOG *d, int c)
{
  if(msg == MSG_DRAW)
  {
     rect(screen, d->x, d->y, d->x+d->w-1, d->y+d->h-1, d->fg);
     rectfill(screen, d->x+1, d->y+1, d->x+d->w-2, d->y+d->h-2, d->bg);
     line(screen, d->x, d->y, d->x+d->w-1, d->y+d->h-1, d->fg);
     line(screen, d->x, d->y+d->h-1, d->x+d->w-1, d->y, d->fg);
     text_mode((int)d->bg);
     textout(screen, font, (char*)d->dp, d->x+2, d->y+2, d->fg);
  }

  return D_O_K;
}

