/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "tostring.h"

int TypeToString(char* propstr,void* prop,int type, int maxsize)
{ switch(type)
  { case BYTE_TYPE:
      usprintf(propstr,"%d",*((unsigned char*)prop));
      break;
    case CHAR_TYPE:
      usprintf(propstr,"%d",*((char*)prop));
      break;
    case UNSIGNED_TYPE:
      usprintf(propstr,"%u",*((unsigned*)prop));
      break;
    case INT_TYPE:
      usprintf(propstr,"%d",*((int*)prop));
      break;
    case LONG_TYPE:
      usprintf(propstr,"%ld",*((long*)prop));
      break;
    case UNSIGNED_LONG_TYPE:
      usprintf(propstr,"%lu",*((unsigned long*)prop));
      break;
    case LONG_LONG_TYPE:
      usprintf(propstr,"%ld",*((long long*)prop));
      break;
    case UNSIGNED_LONG_LONG_TYPE:
      usprintf(propstr,"%lu",*((unsigned long long*)prop));
      break;
    case FLOAT_TYPE:
      usprintf(propstr,"%f",*((float*)prop));
      break;
    case DOUBLE_TYPE:
      usprintf(propstr,"%d",*((double*)prop));
      break;
    case STRING_TYPE:
      ustrncpy(propstr,(char*)prop,maxsize);
      break;
    default:
      return(-1);
  }
  return(0);
}

int StringToType(char* propstr,void* prop,int type, int maxsize)
{
  long l;
  double d;
  switch(type)
  { case CHAR_TYPE:
    case BYTE_TYPE:
    case INT_TYPE:
    case UNSIGNED_TYPE:
    case LONG_TYPE:
    case UNSIGNED_LONG_TYPE:
    case LONG_LONG_TYPE:
    case UNSIGNED_LONG_LONG_TYPE:
      l = ustrtol(propstr,NULL,0);
      break;
    case FLOAT_TYPE:
    case DOUBLE_TYPE:
      d = ustrtod(propstr,NULL);
      break;
    case STRING_TYPE:
      ustrncpy((char*)prop,propstr,maxsize);
      break;
  }
  switch(type)
  { case BYTE_TYPE:
      *(unsigned char*)prop = *((unsigned char*)&l);
      break;
    case CHAR_TYPE:
      *(char*)prop = *((char*)&l);
      break;
    case UNSIGNED_TYPE:
      *(unsigned*)prop = *((unsigned*)&l);
      break;
    case INT_TYPE:
      *(int*)prop = *((int*)&l);
      break;
    case LONG_TYPE:
      *(long*)prop = l;
      break;
    case UNSIGNED_LONG_TYPE:
      *(unsigned long*)prop = labs(l);
      break;
    case LONG_LONG_TYPE:
      *(long long*)prop = l;
      break;
    case UNSIGNED_LONG_LONG_TYPE:
      *(unsigned long long*)prop = labs(l);
      break;
    case FLOAT_TYPE:
      *(float*)prop = d;
      break;
    case DOUBLE_TYPE:
      *(double*)prop = d;
      break;
    case STRING_TYPE:
    case BOOL_TYPE:
   default:
      return(-1);
  }
  return(0);
}

