/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "help.h"

char* Help_File_FID = NULL;
int Help_Depth = 0;

int Menu_Help_Proc()
{ return(Get_Help((char*)active_menu->dp));
}

int Get_Help(char* subject)
{
  MENU menu_help[20];
  menu_help[0].text = NULL;
  MENU menu_help_options[] =
  {
   //  (text)               (proc)          (child)     (flags)     (dp)
    { "&Goto",              NULL,           menu_help,  0,          NULL },
    { "Home",               Menu_Help_Proc, NULL,       0,    (void*)"HELP CONTENTS"},
    { 0 }
  };
  char menu_text[200];
  int mc = 0;
  if(!Help_File_FID)
    return D_OK;
  char* help_text = new char[4096]; // should cover most subjects
  if(!help_text)
    return D_OK;
  FILE* file = fopen(Help_File_FID,"r");
  if(!file)
  { delete help_text;
    return D_OK;
  }
  int match = 1;  // the first line of a new file is a newline in effect
  bool newline = false;
  unsigned size = 0;
  int mh = 0;
  bool new_help_menu_item = false;
  while(!feof(file) && size < 4047)
  { char c;
    if(fread(&c,1,1,file) != 1)
      break;
    if(match && (!subject || !subject[match-1]))  // help subject found (or if no subject)
    { if(c == 10 || c == 13)
        newline = true;
      else
      { if(newline)
        { if(c == ' ')
            c = 10;  // replace space with a new line
          else
            break;   // any non space after a newline is a new subject.
        }
        newline = false;
      }
      if(c == '[')
      { if(mc < 19)
          menu_help[mc].text = menu_text + mh;
        new_help_menu_item = true;
      }
      else if(c == ']')
      { bool nomatch = true;
        // make sure this reference hasn't been used already
        for(int mm = 0; mm < mc; mm++)
        { if(!strcmp(menu_help[mm].text,menu_help[mc].text))
          { nomatch = false;
            break;
          }
        }
        if(mc < 19 && nomatch)
        { menu_help[mc].proc = Menu_Help_Proc;
          menu_help[mc].child = NULL;
          menu_help[mc].flags = 0;
          menu_help[mc].dp = (void*)menu_help[mc].text;
          mc++; // next menu help item
          menu_help[mc].text = NULL;
          mh++;  // get it past the null terminator
        }
        new_help_menu_item = false;
      }
      else
      { help_text[size++] = c;
        if(new_help_menu_item && mh < 199)
        { menu_text[mh++] = c;
          menu_text[mh] = 0;
        }
      }
    }
    else  // continue search for help subject
    { if(c == 10 || c == 13)  // RTN or LF
        match = 1;
      else if(match && tolower(c) == tolower(subject[match-1]))
      { help_text[size++] = c;
        match++;
      }
      else
      { match = 0;
        size = 0;
      }
    }
  }
  help_text[size] = 0;  // terminate string
  fclose(file);
  if(!match || !size)
    return D_OK;
  Help_Depth++;
  char help_level_str[20];
  sprintf(help_level_str,"HELP w%d",Help_Depth);
  DIALOG help_dlg[] =
{
   /* (proc)         (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)              (dp2) (dp3) */
   { d_billwin_proc, 144, 96,  344, 280, 0,   0,   0,    0,      0,   0,   (void*)help_level_str,    NULL, NULL },
   { d_menu_proc,    152, 112, 48,  16,  0,   0,   0,    0,      0,   0,   menu_help_options,NULL, NULL },
   { d_textbox_proc, 152, 128, 328, 224, 0,   0,   0,    0,      0,   0,   (void*)help_text, NULL, NULL },
   { d_button_proc,  164, 356, 96,  16,  0,   0,   0,    D_EXIT, 0,   0,   (void*)"Exit",    NULL, NULL },
   { d_button_proc,  264, 356, 96,  16,  0,   0,   0,    D_EXIT, 0,   0,   (void*)"Back",  NULL, NULL },
   { NULL,           0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,             NULL, NULL }
};
  // Do the dialog
  set_dialog_color(help_dlg, gui_fg_color, gui_bg_color);
  centre_dialog(help_dlg);
  int res = popup_dialog(help_dlg, -1);  // -1 = no focus
  Help_Depth--;  // if it goes below zero something is seriously wrong
  if(res != 4 && Help_Depth) // if not cancel and not lowest level, exit all help
    return D_EXIT; // for all except the lowest help level, Ok = return exit to caller
  else
    return D_OK;
}
