/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "fileopen.h"

char Save_Path[NCHAR] = "";
char Save_Name[NCHAR] = "";
long Save_Offset = 0;
long Save_Replace_Size = 0;

/* open a file */
int Opener(void)
{
    // if files are to contain multipul chapters, revise code to dlg orginal

    int i;
    char path[NCHAR];

    ustrcpy(path, Save_Path);

    if(!billfile_select("Select a source file (DWG)", path, "DWG"))
      return D_O_K;

    // open and scan the file
    FILE* f = fopen(path, "r");
    if(f == NULL)
    {  billalert(" Error", path, "Could not open the file", "&Ok", NULL, 'o', 0);
       return D_OK;
    }
    Save_Replace_Size = TargetList->Load(f);
    fclose(f);

    TargetList->Update();

    return D_REDRAW;
}



/* 'save as' comand */
int Save_As(void)
{
    FILE *f;
    DIALOG_PLAYER *player;
    char path[NCHAR], name[NCHAR];
    int i;

    ustrcpy(path, Save_Path);
    if(billfile_select("Save as...", path, "DWG"))  // file types e.g. DWG;3DO
    {
      f = fopen(path, "r");
      if(f)
      {
//      might want to check file syntax matches type for saving to
        fclose(f);
      }
      else if(exists(path))
      {
        billalert(" Error", path, "Could not open the file for reading", "&Ok", NULL, 'o', 0);
        return D_O_K;
      }

      ustrcpy(Save_Path, path);
      Save_TargetList(Save_Path, Save_Offset, Save_Replace_Size, FALSE);
    }
    
    return D_REDRAW;
}



/* 'save' command */
int Saver(void)
{
  if(ustrlen(Save_Path) == 0)
    return Save_As();

  Save_TargetList(Save_Path, Save_Offset, Save_Replace_Size, FALSE);
    return D_O_K;
}
void Save_TargetList(char *path, long offset, long replacesize, bool backup)
{
    FILE *f;
    PACKFILE *pf;
    char bakpath[128], buff[1024];
    int n;

    if(!exists(path))  // no file so need to worry about offset
    { pf = pack_fopen(path, "w");
      if(!pf)
        billalert(" Error", path, "Could not open the file for writing", "&Ok", NULL, 'o', 0);
      else
      { // okay, save data
        TargetList->Save(pf);
        pack_fclose(pf);
      }
      return;
    }

    // make backup of existing file
    replace_extension(bakpath, path, "bak", 128);
    remove(bakpath);
    if(rename(path, bakpath)!=0)
      billalert(path, "Error renaming the file to", bakpath, "&Ok", NULL, 'o', 0);

    // open exiting file
    f = fopen(bakpath, "rb");
    if(!f)
    { billalert(" Error", bakpath, "Could not open backup file for reading ?!", "&Ooops...", NULL, 'o', 0);
      return;
    }

    pf = pack_fopen(path, "w");
    if(!pf)
    { billalert(" Error", path, "Could not open file for writing...", "&Ok", NULL, 'o', 0);
      fclose(f);
      return;
    }

    // now, find spot to put data in the old file
    long o = offset;
    while(o>1024 && !feof(f))
    {
      n = fread(buff, sizeof(char), 1024, f);
      pack_fwrite(buff, sizeof(char)*n, pf);
      o -= n;
    }
    n = fread(buff, sizeof(char), o, f);
    pack_fwrite(buff, sizeof(char)*n, pf);

    TargetList->Save(pf);
    fseek(f,replacesize,SEEK_SET); // skips copying old data

    while(!feof(f))
    {
	n = fread(buff, sizeof(char), 1024, f);
	pack_fwrite(buff, sizeof(char)*n, pf);
    }

    pack_fclose(pf);
    fclose(f);

    // remove the backup copy if we have to
    if(!backup)
    { if(remove(bakpath) != 0)
        billalert(" Error", bakpath, "Could not delete the file...", "&Ok", NULL, 'o', 0);
    }
}

/* start a new dialog from scratch */
int Newer(void)
{
  TargetList->Clear();
  usprintf(Save_Name, "");
  usetc(Save_Path, 0);

  return D_REDRAW;
}
