/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "edit.h"
#include <string.h>
#include "xproc.h"
#include "stdio.h"

// globals for select editor
char str[NCHAR];
VisualListClass ClipList;     // clipboard for cut and paste
DIALOG* List_dlg = NULL;
int tp; // used to detect change in list selection point
int Paste_Offset_Count;  // number of times Paste option is choses for same graphic object
// used to offset the pasted object to prevent identical objects being hidden

/* copy the selection into the clipboard */
int Copier(void)
{
  Count_Targets();
  ClipList.Clear();
  ClipList.LinkMaker = TargetList->LinkMaker;
  BEGIN_TARGETLIST
    if(target->Selected)
      ClipList.Copy(target);
  END_TARGETLIST

  Paste_Offset_Count = 1;
  return D_O_K;
}

/* cut the selection to the clipboard */
int Cutter(void)
{
  Copier();
  Deleter();
  return D_REDRAW;
}

/* past the clipboard */
int Paster(void)
{
  if(List_dlg)
    target = (VisualLinkClass*)TargetList->Find(List_dlg->d1);
  else // put at first selected or end if none
    target = (VisualLinkClass*)TargetList->First_Selected();
  // scan links in clipboard
  VisualLinkClass* cliplink = (VisualLinkClass*)ClipList.FirstLink();
  Count_Targets();
  int newtargets = 0;
  ListClass newlist;
  VisualLinkClass* first_target = NULL;
  while(cliplink)
  {
    // copy clipboard link to target list
    VisualLinkClass* l = (VisualLinkClass*)TargetList->Copy(cliplink,target,true);
    // search for dependancies within clipboard
//    if(target)
//      target = (VisualLinkClass*)target->NextLink();
    newlist.Add(l->Object);  // make a list of new objects (NULL is valid)
    // it is important the newlist is in sequence with cliplist and target list
    if(l)  // offset new copy from old??
    {
      if(first_target == NULL)
        first_target = l;     // easiest way to note the first new link
/*  Seemed like a good idea to offset but in practice is just confusing
      l->X = (l->X+Grid_W[Grid]*Paste_Offset_Count)%SCREEN_W;
      l->Y = (l->Y+Grid_H[Grid]*Paste_Offset_Count)%SCREEN_H;
      // redirect it to the new location
      l->Control->SetLimits(l->Object,l->X,l->Y,l->W,l->H);
*/
      l->Control->NewWorld(l->Object);  // adjust things like the Base_Block
      l->Update();  // only updates 2D variables using GetLimits(obj,x,y,w,h);
    }
    else
      return D_REDRAW;  // bomb out
    newtargets++;
    cliplink = (VisualLinkClass*)(cliplink->NextLink());
  }
  VisualLinkClass* tl = first_target;  // scan new links
  while(tl)
  { cliplink = (VisualLinkClass*)ClipList.FirstLink();
    LinkClass* newlink = (LinkClass*)newlist.FirstLink();  // scan new objects
    while(cliplink)
    { if(tl->Object != newlink->Object) {  // don't service itself
        tl->Control->NewForOld(tl->Object,cliplink->Object,newlink->Object);
        // if the cliplink object was used by the targetlist object then
        // replace with the newlink object
      }
      cliplink = (VisualLinkClass*)(cliplink->NextLink());
      newlink = newlink->NextLink();
    }
    tl = (VisualLinkClass*)(tl->NextLink());
  }
  Paste_Offset_Count++;
  Targets += newtargets;
  return D_REDRAW;
}

int Mouse_Paste()
{ unsigned targets = Count_Targets();
  Paste_Offset_Count = 0;
  Paster();
  if(Targets > targets)  // something new added
  { unsigned t = 0;
    int dx, dy;
    BEGIN_TARGETLIST
      if(t >= targets)
      { if(t == targets)    // use first target as reference point
        { dx = mouse_x - target->X;
          dy = mouse_y - target->Y;
        }
        target->X += dx;
        target->Y += dy;
        target->Control->SetLimits(target->Object,
                      target->X,target->Y,target->W,target->H);
        target->Selected = TRUE;
      }
      else
        target->Selected = FALSE;
      t++;
    END_TARGETLIST
    while(mouse_b);
    return D_REDRAW;
  }
  return D_OK;  // nothing changed
}

int Inserter(void)
{
  if(key_shifts & KB_SHIFT_FLAG)
    Paster();
//  else  // select new object to load?
  return D_REDRAW;
}

/* delete (but don't put in the clipboard unless shift key) the selection */
int Deleter(void)
{ Count_Targets();
  if(key_shifts & KB_SHIFT_FLAG)
    Copier();
  int j = 0;
  int s = 0;
  BEGIN_TARGETLIST
    if(target->Selected) {
      if(TargetList->DependantOn(target->Object)) { // check if anything else depends on this
        char str[6];
        sprintf(str,"%d",s-j);
        billalert("Object number",str,"is (or was) being used","&Ok", NULL, 'o', 0);
        target->Selected = false; // not really necessary but saves a latter check
      } else {
        //  TargetList->Destroy(target); - can't do that within BEGIN
        j++;
      }
    }
    s++;
  END_TARGETLIST
  Targets -= j;
  TargetList->Delete_Selected(); // doesn't do anything about failure
  return D_REDRAW;
}

int Show_Selected(void)
{
  BEGIN_TARGETLIST
    if(target->Selected)
      target->Visible = true;
  END_TARGETLIST
  return D_REDRAW;
}

int Hide_Selected(void)
{
  BEGIN_TARGETLIST
    if(target->Selected)
      target->Visible = false;
  END_TARGETLIST
  return D_REDRAW;
}


/* getter for the list of the objects of the dialog
 *  this formats a string with the sproc and the id_params
*/
unsigned Count_Targets()
{
  Targets = 0;
  BEGIN_TARGETLIST
    Targets++;
  END_TARGETLIST
  return(Targets);
}

int Show_Only_Base_Block = 1;

int Show_All_Checker()
{
  Show_Only_Base_Block ^= 1;
  return D_REDRAW;
}

char *Select_Getter(int index, int *size)
{ if(index < 0)
  { *size = Targets;
    return(NULL);
  }
  if(Targets == 0)
    return NULL;
  if(List_dlg->d1 != tp && List_dlg->d1 >= 0 && List_dlg->d1 < Targets)
  { target = (VisualLinkClass*)TargetList->Find(List_dlg->d1);
    if(key_shifts & KB_CTRL_FLAG)
      target->Selected = TRUE;
    else if(key_shifts & KB_SHIFT_FLAG)
      target->Selected = FALSE;
    else
    { VisualLinkClass* t = target;
      BEGIN_TARGETLIST
        target->Selected = FALSE;
      END_TARGETLIST
      t->Selected = TRUE;
    }
    tp = List_dlg->d1;
  }
  char check;
  char vis;
  int i = 0;
  BEGIN_TARGETLIST
    if(i == index)
    { if(target->Selected)
        check = '*';  // show original selection
      else
        check = ' ';
      if(target->Visible)
        vis = ' ';  // show original selection
      else
        vis = 'H';
      int n = usprintf(str, "%c%c%3d:",vis,check,index);
      target->Control->Summary(target->Object,str+n,NCHAR,Show_Only_Base_Block);
      break;
    }
    i++;
  END_TARGETLIST
  Paste_Offset_Count = 1;
  return str;
}

int Select_All()
{
  Count_Targets();
/*  for(int s = 0; s < Targets; s++)
    Selected[s] = TRUE; */
  if(TargetList)
    TargetList->Select_All();
  return D_REDRAW;
}

int Select_None()
{
  Count_Targets();
/*  for(int s = 0; s < Targets; s++)
    Selected[s] = FALSE; */
  if(TargetList)
    TargetList->Select_None();
  return D_REDRAW;
}
int Invert_Selection()
{
  Count_Targets();
/*  for(int s = 0; s < Targets; s++)
    Selected[s] = !Selected[s]; */
  TargetList->Invert_Selection();
  return D_REDRAW;
}

int Shift_Down()
{ if(List_dlg)
  { LinkClass* l = TargetList->Find(List_dlg->d1);
    if(l)
    { if(TargetList->Demote(l))
        List_dlg->d1++;
    }
  }
  return D_REDRAW;
}

int Shift_Up()
{ if(List_dlg)
  { LinkClass* l = TargetList->Find(List_dlg->d1);
    if(l)
    { if(TargetList->Promote(l))
        List_dlg->d1--;
    }
  }
  return D_REDRAW;
}

int SelProperties()
{
  int i = 0;
  // select only target pointed to by list
  BEGIN_TARGETLIST
    target->Selected = (i == List_dlg->d1);
    i++;
  END_TARGETLIST
  return(Properties());
}

int Old_Edit_Select_Target = 0;
int Old_Edit_Select_Scroll = 0;

/* edit the list of selected ttarget objects */
int Selection_Editer(void)
{
    DIALOG_PLAYER *pl;

    Paste_Offset_Count = 1;  // how many grid units to offset paste commands

    // create array selected
    Count_Targets();
    if(Old_Edit_Select_Target >= Targets)
      Old_Edit_Select_Target = 0;
    if(Old_Edit_Select_Scroll >= Targets)
      Old_Edit_Select_Scroll = 0;

    DIALOG sel_dlg[] =
{
   // (proc)            (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1)        (d2) (dp)               (dp2)             (dp3)
   { d_billwin_proc,    0,   0,   360, 240, 0,   0,   0,    0,      0,          0,   (void*)"Select Objects",  NULL,             NULL },
   { d_billlist_proc,   8,   24,  344, 164, 0,   0,   0,    D_EXIT, Old_Edit_Select_Target, Old_Edit_Select_Scroll, Select_Getter,NULL,NULL},
   { d_keyboard_proc,   0,   0,   0,   0,   0,   0,   0,    0,      KEY_SPACE,  0,   SelProperties,            NULL,             NULL },
   { Xbutton_proc,      80,  196, 48,  16,  0,   0,   'a',  D_EXIT, 0,          0,   (void*)"&All",            Select_All,       NULL },
   { Xbutton_proc,      80,  216, 48,  16,  0,   0,   'n',  D_EXIT, 0,          0,   (void*)"&None",           Select_None,      NULL },
   { Xbutton_proc,      136, 196, 64,  16,  0,   0,   'i',  D_EXIT, 0,          0,   (void*)"&Invert",         Invert_Selection, NULL },
   { Xbutton_proc,      136, 216, 64,  16,  0,   0,   0,    D_EXIT, 0,          0,   (void*)"ListAll",         Show_All_Checker, NULL },
   { Xbutton_proc,      208, 196, 56,  16,  0,   0,   'c',  D_EXIT, 0,          0,   (void*)"&Copy",           Copier,    NULL },
   { Xbutton_proc,      208, 216, 56,  16,  0,   0,   'p',  D_EXIT, 0,          0,   (void*)"&Paste",          Paster,    NULL },
   { Xbutton_proc,      272, 196, 40,  16,  0,   0,   't',  D_EXIT, 0,          0,   (void*)"Cu&t",            Cutter,    NULL },
   { Xbutton_proc,      272, 216, 40,  16,  0,   0,   0,    D_EXIT, 0,          0,   (void*)"Del",             Deleter,   NULL },
   { Xbutton_proc,      320, 196, 32,  16,  0,   0,   'u',  D_EXIT, 0,          0,   (void*)"/\\",             Shift_Up,     NULL },
   { Xbutton_proc,      320, 216, 32,  16,  0,   0,   'd',  D_EXIT, 0,          0,   (void*)"\\/",             Shift_Down,   NULL },
   { d_keyboard_proc,   0,   0,   0,   0,   0,   0,   0,    0,      KEY_DEL,    0,   Deleter,           NULL,             NULL },
   { d_keyboard_proc,   0,   0,   0,   0,   0,   0,   0,    0,      KEY_INSERT, 0,   Inserter,          NULL,             NULL },
   { Xbutton_proc, 8,   196, 30,  16,  0,   0,   0,   D_EXIT, 0,          0,   (void*)"Show",   Show_Selected,      NULL },
   { Xbutton_proc, 42,  196, 30,  16,  0,   0,   0,   D_EXIT, 0,          0,   (void*)"Hide",   Hide_Selected,      NULL },
//   { d_billbutton_proc, 8,   196, 64,  16,  0,   0,   27,   D_EXIT, 0,          0,   (void*)"Cancel",   NULL,             NULL },
// cancel is no different from Okay, so why bother having it, what's done is done
   { d_billbutton_proc, 8,   216, 64,  16,  0,   0,   13,   D_EXIT, 0,          0,   (void*)"OK",       NULL,             NULL },
   { NULL,              0,   0,   0,   0,   0,   0,   0,    0,      0,          0,   NULL,              NULL,             NULL }
};
    if(!(Show_Only_Base_Block & 1)) {
      sel_dlg[6].dp = (void*)"HideBlk";  // alternate message
      sel_dlg[6].flags |= D_SELECTED;
    }
    centre_dialog(sel_dlg);
    set_dialog_color(sel_dlg, gui_fg_color, gui_bg_color);
    pl = init_dialog(sel_dlg, 1);
    tp = sel_dlg[1].d1 = -1;   // no particular selection
    List_dlg = &sel_dlg[1];

    bool dialog_exit;
    do
    {
      dialog_exit = update_dialog(pl);
      if(dialog_exit == FALSE && pl->obj == 1)  // list
      { pl->res |= SelProperties();
        dialog_exit = TRUE;
      }
    }
    while(dialog_exit);
    Old_Edit_Select_Target = List_dlg->d1;   // preserve position in list
    Old_Edit_Select_Scroll = List_dlg->d2;

    int res = shutdown_dialog(pl);
    List_dlg = NULL;
    return D_REDRAW;
}

#include "tostring.h"
#include "alcolor.h"

/* pop up a dialog to edit the properties of a DIALOG object */
int Properties(void)
{
    int i, j, res;
    int ssize = NCHAR/uwidth_max(U_CURRENT) - 1;
    const int MAXTEMPCOLORS = 8;
    int tempcolors = 0;
    int tempcolor[8];

    // Find the first selected object
    i = 0;
    BEGIN_TARGETLIST
      if(target->Selected)
        break;
      i++;
    END_TARGETLIST
    if(!target)
      return D_O_K;  // no target

// note: xedit_proc is similar to d_edit_proc
    int p = target->Control->Properties;
    if(p <= 0)
      return D_O_K;  // no properites
    int dlgs = 2*p + 4; // will need at least this many dialogs in the array
    DIALOG* prop_dlg = (DIALOG*)malloc(sizeof(DIALOG)*dlgs);  //new DIALOG[d];
    if(!prop_dlg)
      return D_O_K;  // out of memory
    int* ty = (int*)malloc(sizeof(int)*p);      // was new int[p];
    void** prop = (void**)malloc(sizeof(void*)*p);                // was new void*[p];
    char* ss = (char*)malloc(p*NCHAR);   // used new before
    
    memset(prop_dlg,0,sizeof(DIALOG)*(dlgs));
    prop_dlg[0].proc = d_billwin_proc;
        prop_dlg[i].w = 212;
    prop_dlg[0].w = 288;
    prop_dlg[0].h = p*20 + 50;
    sprintf(str,"Edit Properties for %s object #%d",target->Control->Name,i);
    prop_dlg[0].dp = (void*)str;
    for(i= 1, j= 0; j < p && i < dlgs; i++, j++)
    { // get pointer to property into prop[j],
      // property name into prop_dlg[i].dp,
      // property selection function if any - eg. for color, blocks,layers
      // and return property type to ty[j] (see tostring.h)
      ty[j] = target->Control->GetProperty(target->Object,j,&prop[j],
                    (char**)&(prop_dlg[i].dp), (void**)&(prop_dlg[i+1].dp2));
      if(ty[j] == -1)  // somehow have gone past the end of valid properties
        break;
      // bool type uses check buttons instead of text              
      if((ty[j] & TYPE_MASK) == BOOL_TYPE)
      { prop_dlg[i].proc = d_billcheck_proc;
        if(*((bool*)(prop[j])))
          prop_dlg[i].flags |= D_SELECTED;
        prop_dlg[i].x = 8;
        prop_dlg[i].y = j * 20 + 32;
        prop_dlg[i].w = 8;
        prop_dlg[i].h = 8;
      }
      else  // everything else uses a text edit tool
      { prop_dlg[i].proc = d_billtext_proc;
        prop_dlg[i].x = 8;
        prop_dlg[i].y = j * 20 + 32;
        prop_dlg[i].w = 56;
        prop_dlg[i].h = 8;
        i++;
        prop_dlg[i].flags = 0;
        if(ty[j] & DDLIST_TYPE) {
          prop_dlg[i].proc = d_billddlist_proc;
          prop_dlg[i].dp = prop_dlg[i].dp2;  // function to fetch list strings
          prop_dlg[i].dp2 = NULL;
          prop_dlg[i].d1 = *(int*)(prop[j]) + 1;   // 0 is NULL
          prop_dlg[i].d2 = 0;
          prop_dlg[i].w = 300;
          prop_dlg[0].w = 376;  // need to make the whole dialog a bit wider
        } else {
          prop_dlg[i].proc = Xedit_proc;
          TypeToString(ss +j*NCHAR,prop[j],ty[j] & TYPE_MASK,ssize);
          prop_dlg[i].dp = ss + j*NCHAR;
          prop_dlg[i].w = 212;
          prop_dlg[i].d1 = ssize;
        }
        prop_dlg[i].x = 68;
        prop_dlg[i].y = j * 20 + 28;
        prop_dlg[i].h = 15;
        // if property is color
        if(prop_dlg[i].dp2 == Color_Selecter && tempcolors < MAXTEMPCOLORS) {
          tempcolor[tempcolors] = *(int*)prop[j];
          prop_dlg[i].dp3 = (void*)&tempcolor[tempcolors++];
        }
      }
    }
    // set up ok and cancel buttons
    for(int j = 0; j < 2 && i < dlgs; j++, i++)
    { prop_dlg[i].proc = d_billbutton_proc;
      prop_dlg[i].flags = D_EXIT;
      prop_dlg[i].x = 116 + j*68;
      prop_dlg[i].w = 60  + j*36;
      prop_dlg[i].y = p * 20 + 28;
      prop_dlg[i].h = 16;
    }
    dlgs = i;
    prop_dlg[i-2].dp = (void*)"OK";
    prop_dlg[i-1].dp = (void*)"CANCEL";
    prop_dlg[i].proc = NULL;          // just for completeness though it's already set

    set_dialog_color(prop_dlg, gui_fg_color, gui_bg_color);
    centre_dialog(prop_dlg);
    res = popup_dialog(prop_dlg, -1);
    

    // Get data back to object
    if(res == dlgs-2)  // OK
    { for(i=1, j = 0; j < p; j++, i++)
      { if((ty[j] & TYPE_MASK) == BOOL_TYPE)
        { if(prop_dlg[i].flags & D_SELECTED)
            *(bool*)prop[j] = TRUE;
          else
            *(bool*)prop[j] = FALSE;
        }
        else {
          i++; // skip over label for text edit
          if(ty[j] & DDLIST_TYPE) {
            *(int*)(prop[j]) = prop_dlg[i].d1 - 1;   // 0 is NULL
          } else {
            StringToType(ss + j*NCHAR,prop[j],ty[j] & TYPE_MASK,ssize);
          }
        }
//        if(prop_dlg[i+1].dp2 == Color_Selecter - recover tempcolor change
        
        // if index type then we will also need to call SetProperty()
        // that is because prop[j] is only pointing at a static shadow of the
        // real property which may need the SetProperty function to either convert
        // from the shadow to the real property (eg. float to fixed) and/or it
        // may need to call a finder function to check if the layer or block exists.
        if(ty[j] & INDEX_TYPE)
           target->Control->SetProperty(target->Object,j,prop[j]);
      }
      target->Update();
    }
    FREE(ss);
    FREE(prop);   // delete prop;
    FREE(ty);      //delete ty;
    FREE(prop_dlg);   //delete prop_dlg;

    return D_REDRAW;
}


int FindIndex(ObjectClass* object)
{
  int i = 0;
  // select only target pointed to by list
  BEGIN_TARGETLIST
    if(target->Object == object)
      return i;
    i++;
  END_TARGETLIST
  return(-1);
}



