/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "drawrect.h"

// purely screen gui functions

/* directly ripped from Allegro. Maybe this function should be made
 * available in aintern.h ?
 */
// leave as lower case in case this happens one day
void dotted_rect(BITMAP *bmp, int cx1, int cy1, int cx2, int cy2, int fg, int bg)
{
    int x1 = MIN(cx1,cx2);
    int y1 = MIN(cy1,cy2);
    int x2 = MAX(cx1,cx2);
    int y2 = MAX(cy1,cy2);
    int i = ((x1+y1) & 1) ? 1 : 0;

    for (int x = x1; x <= x2; x++)
    { putpixel(bmp, x, y1, (((x+y1) & 1) == i) ? fg : bg);
      putpixel(bmp, x, y2, (((x+y2) & 1) == i) ? fg : bg);
    }

    for (int y = y1+1; y < y2; y++)
    { putpixel(bmp, x1, y, (((x1+y) & 1) == i) ? fg : bg);
      putpixel(bmp, x2, y, (((x2+y) & 1) == i) ? fg : bg);
    }
}

/* let the user drag a rectangle on the screen (the mouse button must already
 * be pressed), returning it thru the pointers. You can safely assume (x1,y1)
 * is the upper-left corner and (x2,y2) the bottom-right one.
 * Grid snaping is ignored while ALT is pressed.
 */
#include "grid.h"
#define SCARE(x)    { scare_mouse(); x; unscare_mouse(); }

void (*Status_Disp)(BITMAP*,int,int,int,int) = NULL;

int Drag_Rectangle(int *x1, int *y1, int *x2, int *y2, int mode)
{
  // mode bit 1 =
  // mode bit 2 = drag whole rectangle
  // mode bit 4 = drag new rect from orignal mouse point
  // mode bit 8 = show mouse

  int ox, oy, x, y, back_grid = Grid, ret = 0;
  int mouse_at_start = mouse_b;

  if((!(mode & 1)) ^ ((key_shifts & KB_ALT_FLAG) != 0))
    Grid = 0;

  int ox1; // mouse_y is usually passed to x1
  int oy1; // mouse_x is usually passed to y1
  int ox2;
  int oy2;
  ox = SnapX(mouse_x);
  oy = SnapY(mouse_y);
  if(mode & 2) // drag whole rect
  { ox1 = *x1;
    oy1 = *y1;
    ox2 = *x2;
    oy2 = *y2;
  }
  else
  { ox1 = SnapX(*x1); // mouse_y is usually passed to x1
    oy1 = SnapY(*y1); // mouse_x is usually passed to y1
    ox2 = ox;
    oy2 = oy;
  }
  set_mouse_sprite(NULL);
  xor_mode(TRUE);
  int nx1 = ox1, ny1 = oy1, nx2 = ox2, ny2 = oy2;
  int lx1 = 0,ly1,lx2 = 0,ly2;
  while(mouse_b == mouse_at_start)
  {
    Grid = ((!(mode & 1)) ^ ((key_shifts & KB_ALT_FLAG)!=0)) ? 0 : back_grid;

    if(SnapX(mouse_x) != x || SnapY(mouse_y) != y)
    {
      x = SnapX(mouse_x);
      y = SnapY(mouse_y);
      if(x != ox)
        ret |= 1;
      if(y != oy)
        ret |= 2;
      if(mode & 2)        // dragging the whole rectangle
      { nx1 = ox1 + x - ox;
        nx2 = ox2 + x - ox;
        ny1 = oy1 + y - oy;
        ny2 = oy2 + y - oy;
      }
      else    // dragging one corner
      { nx2 = x;
        ny2 = y;
      }
      if(lx1 != nx1 || lx2 != nx2 || ly1 != ny1 || ly2 != ny2)
      { scare_mouse();  // in case calling program revives mouse or (mode & 4)
        if(lx1 != lx2)
          rect(screen, lx1, ly1, lx2, ly2, XOR_COLOR);
        rect(screen, nx1, ny1, nx2, ny2, XOR_COLOR);
        lx1 = nx1;
        ly1 = ny1;
        lx2 = nx2;
        ly2 = ny2;
        if(Status_Disp)
          Status_Disp(screen,x,y,ox,oy);
        if(mode & 8)
          unscare_mouse();
      }
    }
    broadcast_dialog_message(MSG_IDLE, 0);
  }
  rect(screen, lx1, ly1, lx2, ly2, XOR_COLOR);
  xor_mode(FALSE);
  unscare_mouse();
  Grid = back_grid;

  if(mode & 4)
  { *x1 = ox;
    *y1 = oy;
    *x2 = x;
    *y2 = y;
  }
  else
  { *x1 = MIN(nx1, nx2);
    *y1 = MIN(ny1, ny2);
    *x2 = MAX(nx1, nx2);
    *y2 = MAX(ny1, ny2);
  }
  return(ret);
}

int Drag_CrossHairs(int x0, int y0, int* x1, int* y1, int* x2, int* y2, int mode)
{
  int ox, oy, back_grid = Grid, ret = 0;
  int mouse_at_start = mouse_b;

  if((!(mode & 1)) ^ ((key_shifts & KB_ALT_FLAG)!=0))
    Grid = 0;   // turns off any snap

  int x = ox = SnapX(x0);   // x0 is usually the same as mouse_x
  int y = oy = SnapY(y0);   // ditto

  set_mouse_sprite(NULL);
  xor_mode(TRUE);
  scare_mouse();
  if(mode & 4)
  { hline(screen, *x1, y, *x2, XOR_COLOR);
    vline(screen, x, *y1, *y2, XOR_COLOR);
  }
  if(mode & 2)
    line(screen, ox, oy, x, y, XOR_COLOR);
  while(mouse_b == mouse_at_start)
  {
    Grid = ((!(mode & 1)) ^ ((key_shifts & KB_ALT_FLAG)!=0)) ? 0 : back_grid;

    if(SnapX(mouse_x) != x || SnapY(mouse_y) != y)
    {
      scare_mouse();   // incase calling program revives mouse when out of area
      if(mode & 4)
      { hline(screen, *x1, y, *x2, XOR_COLOR);
        vline(screen, x, *y1, *y2, XOR_COLOR);
      }
      if(mode & 2)
        line(screen, ox, oy, x, y, XOR_COLOR);
      x = SnapX(mouse_x);
      y = SnapY(mouse_y);
      if(x != ox)
        ret |= 1;
      if(y != oy)
        ret |= 2;
      if(mode & 4)
      { hline(screen, *x1, y, *x2, XOR_COLOR);
        vline(screen, x, *y1, *y2, XOR_COLOR);
      }
      if(mode & 2)
        line(screen, ox, oy, x, y, XOR_COLOR);
    }
    if(Status_Disp)
      Status_Disp(screen,x,y,ox,oy);
    broadcast_dialog_message(MSG_IDLE, 0);
  }
  if(mode & 4)
  { hline(screen, *x1, y, *x2, XOR_COLOR);
    vline(screen, x, *y1, *y2, XOR_COLOR);
  }
  if(mode & 2)
    line(screen, ox, oy, x, y, XOR_COLOR);
  unscare_mouse();
  xor_mode(FALSE);
  Grid = back_grid;

  *x1 = ox;
  *y1 = oy;
  *x2 = x;
  *y2 = y;
  return(ret);
}

