/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "vtxmath.h"

void ScaleVTX(VTX& v, fixed s)
{ if(s == 0)
    return;
  v.X = fdiv(v.X,s);
  v.Y = fdiv(v.Y,s);
  v.Z = fdiv(v.Z,s);
}

void AveVTX(VTX& vo, VTX& v1, VTX& v2)
{ vo.X = fadd(v1.X,v2.X)/2;
  vo.Y = fadd(v1.Y,v2.Y)/2;
  vo.Z = fadd(v1.Z,v2.Z)/2;
}

fixed DistVTX(VTX& v)
{
  return(vector_length(v.X,v.Y,v.Z));
/*   old way suffered from overflow - was goinging shrink but may this will fix it
  fixed tx = v.X;
  fixed ty = v.Y;
  fixed tz = v.Z;
  if(tx > 0x10000)
  fixed sx = fmul(v.X,v.X);
  fixed sy = fmul(v.Y,v.Y);
  fixed sz = fmul(v.Z,v.Z);
  fixed st = sx + sy + sz;
  return(fsqrt(st));
*/
}

bool NormVTX(VTX& vo,VTX& vi)
{
  vo = vi;
  normalize_vector(&vo.X,&vo.Y,&vo.Z);
  return false;
/*
  fixed d;
  d = DistVTX(vi);
  if(d == 0)
    return true;  // zero vector
  vo = vi;
  ScaleVTX(vo,d);
  return false;
*/
}

bool FracVTX(VTX& o, VTX& i, VTX& d, int frac)
{
  if(NormVTX(o,i))
    return true;
  fixed dd = DistVTX(d);
  if(dd == 0)
    return true;
  fixed tf = fdiv(itofix(frac),dd);
  if(tf == 0)
    return true;
  ScaleVTX(o,tf);
  return false;
}
