/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef VERTEXHPP
#define VERTEXHPP

#include "visual.h"
#include "layers.h"
#include "blocks.h"

extern long CurrentRealToFlatConversion;  // needs to be incremented after each view

// something for us to edit
class VertexClass : public ObjectClass
{
public:
  VTX Pos;           // see Space.h
  LayerClass* Layer; // note: Level is only need objects that don't refer to a vertex
  // all objects must be of the same Level ie. not two points between different levels
  BlockClass* Block; // as for level

  // used during viewing only - only applies to Vertex
  // saves having to convert the same point repeatedly
  fixed X,Y,Z;
  long ConversionStamp;
  
  VertexClass();
  void RealToFlat(int&,int&,int&);
  void RealToFixed(fixed&,fixed&,fixed&);
};

#define VERTEX ((VertexClass*)object)

#include "obj3ctrl.h"  // needs to be down here to prevent compile loop

// base class for creator of any object based on objectclass
class VertexControlClass : public Object3DControlClass
{
  int Color;   // if color by type
  unsigned char PointSize; // how big to show the point on the screen
public:
  VertexControlClass();
  virtual ObjectClass* Create();
  virtual void NewWorld(ObjectClass*);
  virtual long Size();
  virtual bool Match(ObjectClass*, BlockClass*, LayerClass*);
  virtual bool Include(ObjectClass*,int,int,int,int);
  virtual bool Inside(ObjectClass*,int,int);
  virtual bool DependantOn(ObjectClass*,ObjectClass*);
  virtual int Distance(ObjectClass*,int,int);
  virtual int GetProperty(ObjectClass*,int n, void** p, char** name,
                                           void**); // returns type or -1 for fail
  virtual int Summary_Layer(ObjectClass*,char*,int);
  virtual int Summary_Pos(ObjectClass*,char*,int);
  virtual int Summary(ObjectClass*,char*,int,int=0);
  virtual int SetProperty(ObjectClass*,int n, void* p);
  virtual void GetRealLimits(ObjectClass*, fixed&,fixed&,fixed&,fixed&,fixed&,fixed&);
  virtual bool GetLimits(ObjectClass*,int&,int&,int&,int&,int&,int&);
  virtual void SetLimits(ObjectClass*,int,int,int,int);
  int GetColor(ObjectClass*,int);
  virtual void Draw(BITMAP*,ObjectClass*);
  virtual void Indicate(BITMAP*,ObjectClass*,int,int,int,int,int,int);
};

extern VertexControlClass VertexControl;

#endif
