/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "vertex.h"
#include "obj3ctrl.h"  // for objectinclude
// #include "drawrect.h"
#include "view.h"  // for color_seperation_mode
//#include "layers.h"

long CurrentRealToFlatConversion = 0;

VertexClass::VertexClass() : ObjectClass()
{ Pos.X = Pos.Y = Pos.Z = 0;
  Layer = Action_Layer;   // in Layer.cpp
  Block = Base_Block;   // in Block.cpp
  ConversionStamp = -1;  // marks if current flat co-ordinates are current conversion
};


void VertexClass::RealToFixed(fixed& x, fixed& y, fixed& z)
{
//  if(ConversionStamp != CurrentRealToFlatConversion)
//  {
    Current_Visual->RealToFixed(&Pos,X,Y,Z);
    ConversionStamp = CurrentRealToFlatConversion;
//  }
  x = X;
  y = Y;
  z = Z;
}

void VertexClass::RealToFlat(int& x, int& y, int& z)
{
// Visual.cpp also has a long version but it is only for convenience in passing
// references as x,y,z always have int range.
  fixed fx, fy, fz;
  RealToFixed(fx,fy,fz);
  x = fixtoi(fx);
  y = fixtoi(fy);
  z = fixtoi(fz);
}


VertexControlClass VertexControl;

VertexControlClass:: VertexControlClass() : Object3DControlClass()
{ Name = "Vertex"; Properties = 5;  // Type is set when registered - see object.cpp
  Color = WHITE;
  PointSize = 1;
}

ObjectClass* VertexControlClass::Create()
{
  return(new VertexClass);
}

void VertexControlClass::NewWorld(ObjectClass* object)
{
  // used by edit.cpp after a paste to relocate new or cut object
  VERTEX->Block = Base_Block;
  // no reason to relocate Layer
}

long VertexControlClass::Size()
{
  return(sizeof(VertexClass));
}

bool VertexControlClass::Match(ObjectClass* object, BlockClass* block, LayerClass* layer)
{
  return(VERTEX->Block == block && (AllLayers || VERTEX->Layer == layer));
}

bool VertexControlClass::Include(ObjectClass* object, int, int, int, int)
{
  if(VERTEX->Block != Base_Block)
    return(false);
  return(Current_Visual->Include(Type,VERTEX->Layer));
}

bool VertexControlClass::Inside(ObjectClass* object, int, int)
{
  if(VERTEX->Block != Base_Block)
    return(false);
  return(Current_Visual->Include(Type,VERTEX->Layer));
}

int VertexControlClass::Distance(ObjectClass* object, int x, int y)
{
  long xo, yo, zo;
  Current_Visual->RealToFlat(&VERTEX->Pos,xo,yo,zo);
  long dx = xo - x;
  long dy = yo - y;
  if(!dx)       // just a bit quicker
    return(dy);
  else if(!dy)
    return(dx);
  else
    return(sqrt((dx*dx)+(dy*dy)));
}


bool VertexControlClass::DependantOn(ObjectClass* object, ObjectClass* dependant) {
  return((dependant == VERTEX->Block) ||
     (dependant == VERTEX->Layer));
}

// should be called Get Pointer to and Name of Property
int VertexControlClass::GetProperty(ObjectClass* object, int n, void** p, char** name,
                                                         void** select_function)
{
  static int layer;
  static int block;
  *select_function = NULL;
  fixed fp;
  switch(n)
  { case 0:
      fp = VERTEX->Pos.X;
      *name = "X";
      break;
    case 1:
      fp = VERTEX->Pos.Y;
      *name = "Y";
      break;
    case 2:
      fp = VERTEX->Pos.Z;
      *name = "Z";
      break;
    case 3:
      if(VERTEX->Layer)
        layer = LayerList.Find(VERTEX->Layer);  // -1 = no level
      else
        layer = -1;
      // easier than using layer name
      *p = &layer;
      *name = "Layer";
      *select_function = Layer_Selector;
      return(INT_TYPE | INDEX_TYPE | DDLIST_TYPE);
    case 4:
      if(VERTEX->Block)
        block = BlockList.Find(VERTEX->Block);   // -1 = no block
      else
        block = -1;
      *p = &block;
      *name = "Block";
      *select_function = Block_Selector;
      return(INT_TYPE | INDEX_TYPE | DDLIST_TYPE);
  }
  static float pf;
  if(n < 3)
  { pf = fixtof(fp);
    *p = &pf;
    return(FLOAT_TYPE | INDEX_TYPE);  // INDEX_TYPEs require Set_Property
  }
  return(-1);
}

int VertexControlClass::Summary_Layer(ObjectClass* object, char* str, int maxstr)
{
  int i = 0;
  if(VERTEX->Layer)
    i = uszprintf(str,maxstr," L%u",LayerList.Find(VERTEX->Layer)+1);
/*  int b = BlockList.Find(VERTEX->Block);
 for name of block
  if(b)
  { char* bs = "Unknown";
    if(b < Blocks)
      bs = VERTEX->Block->Name;
    if(!bs)
      bs = "No name";
    i += uszprintf(str+i,maxstr-i" Block = %s ",bs));
  }
*/
  if(VERTEX->Block)
    i += uszprintf(str+i,maxstr-i," B%u ",BlockList.Find(VERTEX->Block)+1);
  return(i);
}

int VertexControlClass::Summary_Pos(ObjectClass* object,char* str, int maxstr)
{  char* format;
  switch(Current_Visual->Numeric)
  { case 0:
    default:
      format = "{%.3f,%.3f,%.3f}";
      break;
  }
  return(uszprintf(str,maxstr,format,fixtof(VERTEX->Pos.X),
                                      fixtof(VERTEX->Pos.Y),
                                      fixtof(VERTEX->Pos.Z)));
}

int VertexControlClass::Summary(ObjectClass* object,char* str, int maxstr, int flags)
{
  if((flags & 1) && VERTEX->Block != Base_Block) {
    str[0] = 0;
    return(1);
  }
  // assumes str is a reasonably bit longer than maxstr
  int i = uszprintf(str,maxstr,Name);
  i += Summary_Layer(object,str+i,maxstr-i);
  i += Summary_Pos(object,str+i,maxstr-i);
  return(i);
}

int VertexControlClass::SetProperty(ObjectClass* object, int n, void* p)
{
  fixed fp;
  if(n < 3)
    fp = ftofix(*((float*)p));
  switch(n)
  { case 0:
      VERTEX->Pos.X = fp;
      break;
    case 1:
      VERTEX->Pos.Y = fp;
      break;
    case 2:
      VERTEX->Pos.Z = fp;
      break;
    case 3:
      if(*((int*)p) >= 0) {
        // search through layer list for matching ID
     /*   LinkClass* link = LayerList.FirstLink();
        while(link) {
          if(*((int*)p) == ((LayerClass*)link->Object)->ID)
          { VERTEX->Layer = (LayerClass*)link->Object;
            break;
          }
          link = link->NextLink();
        }
      */
        LinkClass* l = LayerList.Find(*((int*)p));
        if(l) {
          LayerClass* v =  (LayerClass*)(l->Object);
          if(v)
            VERTEX->Layer = v;
        }
        // otherwise leave as it was I guess
      } else {
        VERTEX->Layer = NULL;
      }
      break;
    case 4:
      if(*((int*)p) >= 0) {
        LinkClass* l = BlockList.Find(*((int*)p));
        if(l) {
          BlockClass* b = (BlockClass*)(l->Object);
          if(b)
            VERTEX->Block = b;
        }
      } else {
        VERTEX->Block = NULL;
      }
      break;
    default:
      return(-1);
  }
  return(0);
}
void VertexControlClass::GetRealLimits(ObjectClass* object, fixed& x1, fixed& y1, fixed& z1,
                                                          fixed& x2, fixed& y2, fixed& z2)
{
  x1 = x2 = VERTEX->Pos.X;
  y1 = y2 = VERTEX->Pos.Y;
  z1 = z2 = VERTEX->Pos.Z;
}

bool VertexControlClass::GetLimits(ObjectClass* object,int& x,int& y,int& z,
                                                       int& w,int& h,int& d)
{
  // use current visual mode to map object limits onto a flat plane
  Current_Visual->RealToFlat(&VERTEX->Pos,x,y,z);
  x -= PointSize; // needs to have some width to see it
  y -= PointSize;
  z -= PointSize;
  w = h = d = 2*PointSize+1;
  return(Current_Visual->Show(Type,VERTEX->Layer));
}

void VertexControlClass::SetLimits(ObjectClass* object,int x,int y,
                                                       int w,int h)
{
  // use current visual mode to map flat plane onto object limits
  // find out current z for current visual so that we can use it for new pos
  fixed td = Current_Visual->Depth;
  if(RetainZ)
  { int dx,dy,z;
    Current_Visual->RealToFlat(&VERTEX->Pos,dx,dy,z);
    Current_Visual->Depth = itofix(z);
  }
  Current_Visual->FlatToReal(&VERTEX->Pos,x,y);
  // discard w & h in this case
  Current_Visual->Depth = td;
}

int VertexControlClass::GetColor(ObjectClass* object, int typecolor)
{
  int color;
  if(!object)
    return typecolor;
  if(VERTEX->Layer && (VERTEX->Layer->Force_Color || (Color_Seperation_Mode == 1)))
    color = VERTEX->Layer->Color;
  else if(VERTEX->Block && (Color_Seperation_Mode == 2))
    color = VERTEX->Block->Color;
  else
    color = typecolor;
  // Color_Seperation_Mode is in View.cpp
  return color;
}

void VertexControlClass::Draw(BITMAP* bmp,ObjectClass* object)
{
  if(VERTEX->Block != Base_Block)
    return;  // only show vertex for current Base - all others are a bit meaningless
  if(!Current_Visual->Show(Type,VERTEX->Layer))
    return;
  // use current visual mode to protray object on bmp
  int x, y, z;
  VERTEX->RealToFlat(x,y,z);
  rect(bmp,x-PointSize,y-PointSize,x+PointSize,y+PointSize,
     GetColor(object,Color));
}

void VertexControlClass::Indicate(BITMAP* bmp,ObjectClass* object,int, int,
                                                     int,int, int fg, int bg)
{
  int x, y, z;
  VERTEX->RealToFlat(x,y,z);
  dotted_rect(bmp,x-2,y-2,x+2,y+2,fg,bg);
// old way avoided RealToFlat here but had to do it in GetLimits
// GetLimits was called by targetlist->update() during multi view draws
//  dotted_rect(bmp,x1-2,y1-2,x2+2,y2+2,fg,bg);
// if you use data from caller, then target list must be updated with each draw
}



