/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "textuset.h"
#include <string.h>
#include "xproc.h"
#include "stdio.h"
// #include "view.h"
#include "help.h"
#include "visulist.h"   // for DependOn()

// globals for select editor
char Texture_Str[NCHAR];
char* Textures_Selected = NULL;  // only to be used by Select_Editor
DIALOG* Texture_List_dlg = NULL;
#define TEXTURE_LIST_DLG 3     // 3rd item in texture_dlg
int Texture_List_Pntr; // used to detect change in list selection point

LinkClass* Texture_Link; // used in define macro below but defined here so compiler knows about it
// previously I had an link called 'l' here and another in a function argument and the
// compiler didn't complain.
#define BEGIN_TEXTURELIST Texture_Link = TextureList.FirstLink(); while(Texture_Link) {
#define END_TEXTURELIST   Texture_Link = Texture_Link->NextLink(); }

int Get_Texture_Selected()
{
  if(!Textures_Selected)
    return(-1);
  unsigned i = 0;
  int j = 0;
  BEGIN_TEXTURELIST
    Textures_Selected[i] = Texture_Link->Selected;
    if(Textures_Selected[i])
      j++;
    i++;
  END_TEXTURELIST
  return(j);
}

void Set_Texture_Selected()
{
  if(!Textures_Selected)
    return;
  unsigned i = 0;
  BEGIN_TEXTURELIST
    Texture_Link->Selected = Textures_Selected[i];
    i++;
  END_TEXTURELIST
}

int Texture_Adder(void)
{
  TextureClass* texture = new TextureClass();
  if(texture) {
    TextureList.Add(texture);
    Textures_Selected= (char*)realloc(Textures_Selected,Textures);
    memset(Textures_Selected,0,Textures);
    Textures_Selected[Textures-1] = true;
    Action_Texture = texture;
  }
  return D_REDRAW;
}

/* delete (but don't put in the clipboard unless shift key) the selection */
int Texture_Deleter(void)
{ if(Textures_Selected)
  { Set_Texture_Selected();
    int j = 0;
    for(int s = 0; s < Textures; s++)
    { if(Textures_Selected[s]) {
        // if Base_Texture is removed then set to NULL
        LinkClass* link = TextureList.Find(s);
        if(link) {
          TextureClass* texture = (TextureClass*)link->Object;
          int user = TargetList->DependantOn(texture);
          if(user >= 0) {
            char str[6];
            sprintf(str,"Texture ID%d is being used by object #%d.",texture->ID,user);
            billalert("Sorry, can't delete texture.",str,NULL,"&Ok", NULL, 'o', 0);
            link->Selected = false;
          } else {
            if(texture == Action_Texture)
              Action_Texture = NULL;
            j++;
          }
        }
      }
      if(j && s+j < Textures)
        Textures_Selected[s] = Textures_Selected[s+j];
    }
    Textures -= j;
  }
  TextureList.Delete_Selected();
  return D_REDRAW;
}

/* getter for the list of the objects of the dialog
 *  this formats a string with the sproc and the id_params
*/

char *Select_Texture_Getter(int index, int *size)
{ if(index < 0)
  { *size = Textures;
    return(NULL);
  }
  if(Texture_List_dlg->d1 != Texture_List_Pntr && Texture_List_dlg->d1 >= 0 && Texture_List_dlg->d1 < Textures)
  { if(key_shifts & KB_CTRL_FLAG)
      Textures_Selected[Texture_List_dlg->d1] = TRUE;
    else if(key_shifts & KB_SHIFT_FLAG)
      Textures_Selected[Texture_List_dlg->d1] = FALSE;
    else
    { for(int i = 0; i < Textures; i++)
        Textures_Selected[i] = FALSE;
        Textures_Selected[Texture_List_dlg->d1] = TRUE;
    }
    Texture_List_Pntr = Texture_List_dlg->d1;
  }
  char check, actc;
  char flag_str[9];
  int i = 0;
  BEGIN_TEXTURELIST
    if(i == index)
    { if(Textures_Selected[i])
        check = '*';  // show original selection
      else
        check = ' ';
      TextureClass* texture = (TextureClass*)Texture_Link->Object;
      if(texture == Action_Texture)
        actc = 'A';
      else
        actc = ' ';
      const char* name = texture->Name;
      if(name == NULL)
        name = "NONAME";
      usprintf(Texture_Str, "%c%3d%c %-32.32s",check,texture->ID,actc,name);
      break;
    }
    i++;
  END_TEXTURELIST
  return Texture_Str;
}

int Select_All_Textures()
{
  TextureList.Select_All();
  Get_Texture_Selected();
  return D_REDRAW;
}

int Select_No_Textures()
{
  TextureList.Select_None();
  Get_Texture_Selected();
  return D_REDRAW;
}
int Invert_Texture_Selection()
{
  TextureList.Invert_Selection();
  Get_Texture_Selected();
  return D_REDRAW;
}

int Shift_Texture_Down()
{ if(Texture_List_dlg)
  { LinkClass* l = TextureList.Find(Texture_List_dlg->d1);
    if(l)
    { if(TextureList.Demote(l))
        Texture_List_dlg->d1++;
    }
  }
  Get_Texture_Selected();
  return D_REDRAW;
}

int Shift_Texture_Up()
{ if(Texture_List_dlg)
  { LinkClass* l = TextureList.Find(Texture_List_dlg->d1);
    if(l)
    { if(TextureList.Promote(l))
        Texture_List_dlg->d1--;
    }
  }
  Get_Texture_Selected();
  return D_REDRAW;
}

int Select_Action_Texture()
{
  int i = 0;
  BEGIN_TEXTURELIST
   if(Textures_Selected &&Textures_Selected[i])
     Action_Texture = (TextureClass*)Texture_Link->Object;  // default is first selected
   if(active_dialog[TEXTURE_LIST_DLG].d1 == i++)
   { Action_Texture = (TextureClass*)Texture_Link->Object;
     break;
   }
  END_TEXTURELIST
  return D_REDRAW;
}

#include "tostring.h"
#include "alcolor.h"

int Call_Texture_Prop_Help()
{
  Get_Help("TEXTURE PROPERTY EDITOR");
  return D_OK;
}

/* pop up a dialog to edit the TextureProperties of a DIALOG object */
int Texture_Properties(void)
{
    int i, j, res;
    int ssize = NCHAR/uwidth_max(U_CURRENT) - 1;
    char* name;

    // Find the first selected object
    i = 0;
    BEGIN_TEXTURELIST
      if(Texture_Link->Selected)
        break;
      i++;
    END_TEXTURELIST
    if(!Texture_Link)
      return D_O_K;  // no Link
    TextureClass* texture = (TextureClass*)(Texture_Link->Object);
    sprintf(Texture_Str,"Edit Texture ID #%d",texture->ID);
    name = new char[ssize];
    if(texture->Name)
      strcpy(name,texture->Name);
    else
      name[0] = 0;  // null str

    DIALOG texture_dlg[] =
{
   /* (proc)            (x)  (y) (w)  (h) (fg) (bg) (key) (flags) (d1) (d2) (dp)              (dp2)           (dp3)              */
   { d_billwin_proc,    0,   0,  352, 88, 0,   0,   0,    0,      0,   0,   (void*)Texture_Str, NULL,           NULL              },
   { d_billbutton_proc, 56,  64, 48,  16, 0,   0,   13,   D_EXIT, 0,   0,   (void*)"OK",      NULL,           NULL              },
   { d_billbutton_proc, 112, 64, 72,  16, 0,   0,   27,   D_EXIT, 0,   0,   (void*)"Cancel",  NULL,           NULL              },
   { d_billtext_proc,   8,   20, 144, 8,  0,   0,   0,    0,      0,   0,   (void*)"Name:",   NULL,           NULL              },
   { Xedit_proc,        48,  16, 296, 16, 0,   0,   0,    0,      9,   0,   name,             NULL,           NULL              },
   { Xbutton_proc,      300, 64, 48,  16, 0,   0,   '?',  D_EXIT, 0,   0,   (void*)"Help&?",  Call_Texture_Prop_Help,   NULL      },
   { NULL,              0,   0,  0,   0,  0,   0,   0,    0,      0,   0,   NULL,             NULL,           NULL              }
};
    set_dialog_color(texture_dlg, gui_fg_color, gui_bg_color);
    centre_dialog(texture_dlg);
    res = popup_dialog(texture_dlg, -1);

    // Get data back to object
    if(res == 1) { // OK
      if(texture->Name)
        delete(texture->Name);
      if(name[0] > 32)
        texture->Name = name;   // retained in memory - deleted with ~Texture()
      else
        texture->Name = NULL;
    } else {  // assume cancel
      delete name;
    }
    return D_REDRAW;
}

int Sel_Texture_Properties()
{
  int i = 0;
  // select only Link pointed to by list
  BEGIN_TEXTURELIST
    Texture_Link->Selected = (i == Texture_List_dlg->d1);
    i++;
  END_TEXTURELIST
  return(Texture_Properties());
}

int Call_Edit_Texture_Help()
{
  Get_Help("TEXTURE LIST EDITOR");
  return D_OK;
}

/* edit the list of selected textures */
int Texture_Editer(void)
{
    DIALOG_PLAYER *pl;

    // create array selected
    Textures_Selected = (char*)malloc(Textures);  // selected is a global - see above SelectAll
    Get_Texture_Selected();

    DIALOG sel_dlg[] =
{
   /* (proc)            (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1)       (d2) (dp)                     (dp2)                   (dp3) */
   { d_billwin_proc,    0,   0,   400, 240, 0,   0,   0,    0,      0,         0,   (void*)"Select Texture",   NULL,                   NULL },
   { d_billbutton_proc, 8,   216, 64,  16,  0,   0,   13,   D_EXIT, 0,         0,   (void*)"OK",             NULL,                   NULL },
   { d_billbutton_proc, 8,   196, 64,  16,  0,   0,   13,   D_EXIT, 0,         0,   (void*)"Cancel",         NULL,                   NULL },
   { d_billlist_proc,   8,   24,  344, 148, 0,   0,   0,    D_EXIT, 0,         0,   Select_Texture_Getter,     NULL,                   NULL },
   { d_keyboard_proc,   0,   0,   0,   0,   0,   0,   0,    0,      KEY_SPACE, 0,   Sel_Texture_Properties,       NULL,                   NULL },
   { Xbutton_proc,      312, 172, 48,  16,  0,   0,   '?',  D_EXIT, 0,         0,   (void*)"Help&?",         Call_Edit_Texture_Help,   NULL },
   { Xbutton_proc,      80,  196, 48,  16,  0,   0,   'a',  D_EXIT, 0,         0,   (void*)"&All",           Select_All_Textures,      NULL },
   { Xbutton_proc,      80,  216, 48,  16,  0,   0,   'n',  D_EXIT, 0,         0,   (void*)"&None",          Select_No_Textures,       NULL },
//   { Xbutton_proc,      136, 172, 64,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Base",           Select_Base_Texture,      NULL },
   { Xbutton_proc,      136, 196, 64,  16,  0,   0,   'i',  D_EXIT, 0,         0,   (void*)"&Invert",        Invert_Texture_Selection, NULL },
   { Xbutton_proc,      136, 216, 64,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Action",         Select_Action_Texture,    NULL },
   { Xbutton_proc,      312, 196, 40,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Add",            Texture_Adder,            NULL },
   { Xbutton_proc,      312, 216, 40,  16,  0,   0,   0,    D_EXIT, 0,         0,   (void*)"Del",            Texture_Deleter,          NULL },
   { Xbutton_proc,      360, 196, 32,  16,  0,   0,   'u',  D_EXIT, 0,         0,   (void*)"/\\",            Shift_Texture_Up,         NULL },
   { Xbutton_proc,      360, 216, 32,  16,  0,   0,   'd',  D_EXIT, 0,         0,   (void*)"\\/",            Shift_Texture_Down,       NULL },
   { d_keyboard_proc,   0,   0,   0,   0,   0,   0,   0,    0,      KEY_DEL,   0,   Texture_Deleter,           NULL,                   NULL },
   { NULL,              0,   0,   0,   0,   0,   0,   0,    0,      0,         0,   NULL,                    NULL,                   NULL }
};
    centre_dialog(sel_dlg);
    set_dialog_color(sel_dlg, gui_fg_color, gui_bg_color);
    pl = init_dialog(sel_dlg, 1);
    Texture_List_Pntr = sel_dlg[TEXTURE_LIST_DLG].d1 = -1;   // no particular selection
    Texture_List_dlg = &sel_dlg[TEXTURE_LIST_DLG];

    bool dialog_exit;
    do
    {
      dialog_exit = update_dialog(pl);
      if(dialog_exit == FALSE && pl->obj == TEXTURE_LIST_DLG)  // list
      { pl->res |= Sel_Texture_Properties();
        dialog_exit = TRUE;
      }
    }
    while(dialog_exit);

    int res = shutdown_dialog(pl);
    if(res == 1)  // OK
      Set_Texture_Selected();
    FREE(Textures_Selected);
    Texture_List_dlg = NULL;
    return D_REDRAW;
}

