/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "line.h"
#include "drawline.h"
#include "obj3ctrl.h"
#include "visulist.h"  // for access to TargetList
#include "vtxmath.h"
#include "spline.h"

SplineControlClass SplineControl;

#define SPLINE ((SplineClass*)object)

SplineControlClass:: SplineControlClass() : LineControlClass()
{ Name = "Spline"; Properties = 16;
  Color = LIGHT_BLUE;
}

ObjectClass* SplineControlClass::Create()
{
  return(new SplineClass);
}

long SplineControlClass::Size()
{
  return(sizeof(SplineClass));
}

bool SplineControlClass::Inside(ObjectClass* object, int mx, int my)
{
  if(!SPLINE->P1 || !SPLINE->P2 || SPLINE->P1->Block != Base_Block)
    return false;
// will only come here after passing initial test of limits
// for splines, it is the vector points we wish to capture
  // use current visual mode to protray object on bmp
  VTX dvtx = SPLINE->P2->Pos - SPLINE->P1->Pos;
  VTX v;
  VTX vw;
  int x,y,z;
  Calc_Vectors(object);   // will only do it if flags cleared
  if(FracVTX(vw,SPLINE->V1,dvtx,4))  // see Space.cpp
    return false;
  // make vector a fraction of the size of the overall line
  v = SPLINE->P1->Pos + vw;
  Current_Visual->RealToFlat(&v,x,y,z);
  if((mx > x - 2) && (mx < x + 2) && (my > y - 2) && (my < y + 2)) {
    Focus = SPLINE;
    Vector = 1;
    return true;
  }
  // make vector a fraction the size of the overall line
  if(FracVTX(vw,SPLINE->V2,dvtx,4))  // see Space.cpp
    return false;
  v = SPLINE->P2->Pos - vw;
  Current_Visual->RealToFlat(&v,x,y,z);
  if((mx > x - 2) && (mx < x + 2) && (my > y - 2) && (my < y + 2)) {
    Focus = SPLINE;
    Vector = 2;
    return true;
  }
  return false;

/* - based on lineclass
  long x1, x2, y1, y2, z;
  Current_Visual->RealToFlat(&SPLINE->P1->Pos,x1,y1,z);
  Current_Visual->RealToFlat(&SPLINE->P2->Pos,x2,y2,z);
  long d1x = x2 - x1;
  long d1y = y2 - y1;
  long d2x = x - x1;
  long d2y = y - y1;
  long de = 0;
  // make an approximation of distance from line based on gradient error
  if(d1x > d1y)
    de = (d2x * d1y)/d1x - d2y;
  else
    de = (d2y * d1x)/d1y - d2x;
  return(!de);
*/
/*  int x = MAX(x1,x2);
  x1 = MIN(x1,x2);
  x2 = x;
  int y = MAX(x1,x2);
  y1 = MIN(x1,x2);
  y2 = y;
  if(
  int y3 =
*/
}

/*
int SplineControlClass::Distance(ObjectClass* object, int x, int y)
{
  int x1, x2, y1, y2, z;
  Current_Visual->RealToFlat(&SPLINE->P1->Pos,x1,y1,z);
  Current_Visual->RealToFlat(&SPLINE->P2->Pos,x2,y2,z);
  int dx = x2 - x1;
  int dy = y2 - y1;
  return(0);
}
*/

void SplineControlClass::MoveVector(ObjectClass* object, int xn, int yn)
{
  if(!SPLINE->P1 || !SPLINE->P2)
    return;
  VTX dvtx = SPLINE->P2->Pos - SPLINE->P1->Pos;
  VTX* vp;
  if(Vector == 2)
    vp = &SPLINE->V2;
  else
    vp = &SPLINE->V1;
  VTX v;
  VTX vw;
  int x,y,z;
  Calc_Vectors(object);   // will only do it if flags cleared
  if(FracVTX(vw,*vp,dvtx,4))  // see Space.cpp
    return;
  // make vector a fraction of the size of the overall line
  if(Vector == 2)
    v = SPLINE->P2->Pos - vw;
  else
    v = SPLINE->P1->Pos + vw;
  Current_Visual->RealToFlat(&v,x,y,z);
  fixed d = Current_Visual->Depth;
  Current_Visual->FlatToReal(&v,xn,yn);
  Current_Visual->Depth;
  if(Vector == 2)
    vw = SPLINE->P2->Pos - v;
  else
    vw = v - SPLINE->P1->Pos;
  //  NormaliseVector(vw);
  *vp = vw;
  if(Vector == 2) {
    SPLINE->Flags |= SPLINE_V2_LOCK;
    SPLINE->Flags &= (SPLINE_V2_CALC ^ 0xFFFF);
  } else {
    SPLINE->Flags |= SPLINE_V1_LOCK;
    SPLINE->Flags &= (SPLINE_V1_CALC ^ 0xFFFF);
  }
}


bool SplineControlClass::GetLimits(ObjectClass* object,int& x,int& y,int& z,
                                                       int& w,int& h,int& d)
{
  // can always use "return(LineControlClass::GetLimits(object,x,y,z,w,h,d));"
  // need to repeat of the drawing calcs.  If not working, look for changes in Draw
  // use current visual mode to protray object on bmp
  VTX dvtx = SPLINE->P2->Pos - SPLINE->P1->Pos;
  VTX v;
  VTX vw;
  int x1,y1,z1,x2,y2,z2;
  Calc_Vectors(object);   // will only do it if flags cleared
  if(FracVTX(vw,SPLINE->V1,dvtx,4))  // see Space.cpp
    return false;
  // make vector a fraction of the size of the overall line
  v = SPLINE->P1->Pos + vw;
  Current_Visual->RealToFlat(&v,x1,y1,z1);
  // make vector a fraction the size of the overall line
  if(FracVTX(vw,SPLINE->V2,dvtx,4))  // see Space.cpp
    return false;
  v = SPLINE->P2->Pos - vw;
  Current_Visual->RealToFlat(&v,x2,y2,z2);
  x = MIN(x1,x2);
  y = MIN(y1,y2);
  z = MIN(z1,z2);
  w = MAX(x1,x2)-x + 1;
  h = MAX(y1,y2)-y + 1;
  d = MAX(z1,z2)-z + 1;
  return(Current_Visual->Show(Type,SPLINE->P1->Layer));
  // need to use vectors as limit points because these can be outside of end points
  // for inside(x,y)
}


// #include "visulist.h"

// should be called Get Pointer to and Name of Property
int SplineControlClass::GetProperty(ObjectClass* object, int n, void** p, char** name,
                                               void** select_function)
{
  static bool flag;
  if(n < 8)
    return(LineControlClass::GetProperty(object,n,p,name,select_function));
  *select_function = NULL;
  fixed fp;
  static float pf;
  switch(n)
  { case 8:
      fp = SPLINE->V1.X;
      *name = "V1_X";
      break;
    case 9:
      fp = SPLINE->V1.Y;
      *name = "V1_Y";
      break;
    case 10:
      fp = SPLINE->V1.Z;
      *name = "V1_Z";
      break;
    case 11:
      fp = SPLINE->V2.X;
      *name = "V2_X";
      break;
    case 12:
      fp = SPLINE->V2.Y;
      *name = "V2_Y";
      break;
    case 13:
      fp = SPLINE->V2.Z;
      *name = "V2_Z";
      break;
    case 14:
      *name = "Lock1";
      flag = ((SPLINE->Flags & SPLINE_V1_LOCK) != 0);
      *p = &flag;
      return(BOOL_TYPE | INDEX_TYPE);
    case 15:
      *name = "Lock2";
      flag = ((SPLINE->Flags & SPLINE_V2_LOCK) != 0);
      *p = &flag;
      return(BOOL_TYPE | INDEX_TYPE);
  }
  if(n < 14)
  { pf = fixtof(fp);
    *p = &pf;
    return(FLOAT_TYPE | INDEX_TYPE);  // INDEX_TYPEs require Set_Property
  }
  return(-1);
}

int SplineControlClass::Summary(ObjectClass* object,char* str, int maxstr, int flags)
{
  int i = LineControlClass::Summary(object,str,maxstr,flags);
/*
  int p1 = TargetList->Find_OfType(SPLINE->P1,&VertexControl);
  int p2 = TargetList->Find_OfType(SPLINE->P2,&VertexControl);
  int i = uszprintf(str,maxstr,"%s P1=%d P2=%d",Name,p1,p2);
  LINETYPE t = (LINETYPE)SPLINE->Type;
  if(t > LINETYPES)
    t = (LINETYPE)LINETYPES;  // equivilant to "unknown"
  i += uszprintf(str+i,maxstr-i," Type= %s Width=%u",Line_Type_String[t],SPLINE->Width);
  i += VertexControl.Summary_Layer(SPLINE->P1,str+i,maxstr-i);
  i += VertexControl.Summary_Pos(SPLINE->P1,str+i,maxstr-i);
  i += VertexControl.Summary_Pos(SPLINE->P2,str+i,maxstr-i);
  return(0);
*/
  return(i);
}

#include "visulist.h"

int SplineControlClass::SetProperty(ObjectClass* object, int n, void* p)
{
  UnCalcV1(object);
  UnCalcV2(object);
  if(n < 8)
    return(LineControlClass::SetProperty(object,n,p));
  fixed fp;
  LineClass* line;
  if(n < 14)
    fp = ftofix(*((float*)p));
  switch(n)
  { case 8:
      SPLINE->V1.X = fp;
      break;
    case 9:
      SPLINE->V1.Y = fp;
      break;
    case 10:
      SPLINE->V1.Z = fp;
      break;
    case 11:
      SPLINE->V2.X = fp;
      break;
    case 12:
      SPLINE->V2.Y = fp;
      break;
    case 13:
      SPLINE->V2.Z = fp;
      break;
    case 14:  // V1 LOCK
      if(*((bool*)p))
        SPLINE->Flags |= SPLINE_V1_LOCK;
      else
        SPLINE->Flags &= (SPLINE_V1_LOCK ^ 0xFFFF);
      break;
    case 15:  // V1 LOCK
      if(*((bool*)p))
        SPLINE->Flags |= SPLINE_V2_LOCK;
      else
        SPLINE->Flags &= (SPLINE_V2_LOCK ^ 0xFFFF);
      break;
    default:
      return(-1);
  }
  return(0);
}

/*
void LineClass::Get_Flat(ObjectClass* object,
                       int& x1, int& y1, int& z1,
                       int& x2, int& y2, int& z2 }
{
  if(LINE->P1)
    Current_Visual->RealToFlat(&LINE->P1->Pos,x1,y1,z1);
  if(LINE->P2)
    Current_Visual->RealToFlat(&LINE->P2->Pos,x2,y2,z2);
}
  I don't know what this is doing here
*/

void SplineControlClass::UnCalcV1(ObjectClass* object)
{ SPLINE->Flags &= (SPLINE_V1_CALC^0xFFFF);
  if(SPLINE->L1 && SPLINE->L1->Class==1 && SPLINE->L1->L2 == SPLINE)
    ((SplineClass*)(SPLINE->L1))->Flags &= (SPLINE_V2_CALC^0xFFFF);
}

void SplineControlClass::UnCalcV2(ObjectClass* object)
{ SPLINE->Flags &= (SPLINE_V2_CALC^0xFFFF);
  if(SPLINE->L2 && SPLINE->L2->Class==1 && SPLINE->L2->L1 == SPLINE)
    ((SplineClass*)(SPLINE->L2))->Flags &= (SPLINE_V1_CALC^0xFFFF);
}

void SplineControlClass::Calc_Vectors(ObjectClass* object)
{
  VTX dVTX;
  VTX ddVTX;

  // bool redo_leading_grad = false;
  dVTX = SPLINE->P2->Pos - SPLINE->P1->Pos;
  if(!(SPLINE->Flags & (SPLINE_V1_CALC | SPLINE_V1_LOCK))) // lead vector not calculated or locked
  { // is there a valid previous line to use
    if(SPLINE->L1)
    { if(SPLINE->L1->Class == 0) { // previous line is LineClass
        // so use straight vector
        if(SPLINE->L1->P1 && SPLINE->L1->P2 && (SPLINE->L1->P1 != SPLINE->L1->P2))
          SPLINE->V1 = SPLINE->L1->P2->Pos - SPLINE->L1->P1->Pos;
        else
          SPLINE->V1 = dVTX;
      } else if(SPLINE->L1->Class == 2) { // previous line is ArcClass
        // so use straight vector - should use tangent
        if(SPLINE->L1->P1 && SPLINE->L1->P2 && (SPLINE->L1->P1 != SPLINE->L1->P2))
          SPLINE->V1 = SPLINE->L1->P2->Pos - SPLINE->L1->P1->Pos;
        else
          SPLINE->V1 = dVTX;
      } else if( (((SplineClass*)(SPLINE->L1))->Flags &
           SPLINE_V2_LOCK)!= 0) { // locked
        SPLINE->V1 = ((SplineClass*)(SPLINE->L1))->V2;
      } else {    // have to calculate it now
        SPLINE->V1 = SPLINE->L1->P2->Pos - SPLINE->L1->P1->Pos;
        AveVTX(SPLINE->V1,SPLINE->V1,dVTX);  // in Space.cpp
        ((SplineClass*)SPLINE->L1)->V2 = SPLINE->V1;
        // the longer spline has the greater influence
      }
    }
    else  // vector straight to the end point (should use the reverse of the trailing vector)
    { SPLINE->V1 = dVTX;
    //  redo_leading_grad = true;
    }
    SPLINE->Flags |= SPLINE_V1_CALC;  // show leading edge calc has been made
  }
  ddVTX = SPLINE->V1 - dVTX;  // get the difference from direct
  if(!(SPLINE->Flags & (SPLINE_V2_CALC | SPLINE_V2_LOCK))) // trailing neither locked or calcd
  { // is there a valid next line to use
    if(SPLINE->L2)
    { if(SPLINE->L2->Class == 0) { // following line is LineClass
        if(SPLINE->L1->P1 && SPLINE->L1->P2 && (SPLINE->L1->P1 != SPLINE->L1->P2))
          SPLINE->V2 = SPLINE->L2->P2->Pos - SPLINE->L2->P1->Pos;
        else
          SPLINE->V2 = dVTX - ddVTX;
      } else if(SPLINE->L2->Class == 2) { // following line is ArcClass
        if(SPLINE->L1->P1 && SPLINE->L1->P2 && (SPLINE->L1->P1 != SPLINE->L1->P2))
          SPLINE->V2 = SPLINE->L2->P2->Pos - SPLINE->L2->P1->Pos;
        else
          SPLINE->V2 = dVTX - ddVTX;
      } else if( (((SplineClass*)(SPLINE->L2))->Flags &
          SPLINE_V2_LOCK)!= 0) {  // locked
        SPLINE->V2 = ((SplineClass*)(SPLINE->L2))->V1;
      } else { // have to calculate new for both now
        SPLINE->V2 = SPLINE->L2->P2->Pos - SPLINE->L2->P1->Pos;
        AveVTX(SPLINE->V2,SPLINE->V2,dVTX);  // in Space.cpp
        ((SplineClass*)SPLINE->L2)->V1 = SPLINE->V2;
        // longer line has the greater influcence
      }
    }
    else  // vector straight to the end point (should use the reverse of the trailing vector)
      SPLINE->V2 = dVTX - ddVTX;
    SPLINE->Flags |= SPLINE_V2_CALC;   // show trailing edge calc has been made
  }
  /*
  if(redo_leading_grad)
  { ddVTX = SPLINE->V2 - dVTX;
    SPLINE->V1 = SPLINE->V1 - ddVTX;
  }
  */
}

void SplineControlClass::RealToFlat(ObjectClass* object, int* p)
{
  int z;
  VTX dvtx = SPLINE->P2->Pos - SPLINE->P1->Pos;
  VTX v;
  VTX vw;
  Calc_Vectors(object);   // will only do it if flags cleared
  Current_Visual->RealToFlat(&SPLINE->P1->Pos,p[0],p[1],z);
  if(FracVTX(vw,SPLINE->V1,dvtx,4))  // see Space.cpp
    return;
  // make vector a fraction of the size of the overall line
  v = SPLINE->P1->Pos + vw;
  Current_Visual->RealToFlat(&v,p[2],p[3],z);
//  p[2] = x;
//  p[3] = y;
  Current_Visual->RealToFlat(&SPLINE->P2->Pos,p[6],p[7],z);
  // make vector a fraction the size of the overall line
  if(FracVTX(vw,SPLINE->V2,dvtx,4))  // see Space.cpp
    return;
  v = SPLINE->P2->Pos - vw;
  Current_Visual->RealToFlat(&v,p[4],p[5],z);
//  p[4] = x;
//  p[5] = y;
}

void SplineControlClass::Draw(BITMAP* bmp,ObjectClass* object)
{
  if(!Current_Visual->Show(Type,SPLINE->P1->Layer))
    return;
  // use current visual mode to protray object on bmp
  int p[8];
  RealToFlat(object,p);
  // at present all line types are the same with no width
  spline(bmp,p,    // uses allegro's spline function
    VertexControl.GetColor(SPLINE->P1,Color));
  // show vectors - can be editied
  rect(bmp,p[2]-2,p[3]-2,p[2]+2,p[3]+2,RED);
  rect(bmp,p[4]-2,p[5]-2,p[4]+2,p[5]+2,RED);
}

void SplineControlClass::Indicate(BITMAP* bmp, ObjectClass* object,
     int,int,int,int, int fg, int bg)
{
  int p[8];
  RealToFlat(object,p);
  dotted_line(bmp,p[0],p[1],p[2],p[3],fg,bg);
  dotted_line(bmp,p[2],p[3],p[4],p[5],fg,bg);
  dotted_line(bmp,p[4],p[5],p[6],p[7],fg,bg);
}



