/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "render.h"

RENDER_TYPE RenderMode = FLAT_RENDER;

// render types known to allegro 4.0
// remaps from RenderMode
int Render_Type[] = {
   0,
   POLYTYPE_FLAT,
   POLYTYPE_GCOL,
   POLYTYPE_GRGB,
   POLYTYPE_ATEX,
   POLYTYPE_PTEX,
   POLYTYPE_ATEX_MASK,
   POLYTYPE_PTEX_MASK,
   POLYTYPE_ATEX_LIT,
   POLYTYPE_PTEX_LIT,
   POLYTYPE_ATEX_MASK_LIT,
   POLYTYPE_PTEX_MASK_LIT
};

char *Render_Mode_Str[] = {
   "Wireframe",
   "Flat shaded",
   "Single color gouraud shaded",
   "Gouraud shaded",
   "Texture mapped",
   "Perspective correct texture mapped",
   "Masked texture mapped",
   "Masked persp. correct texture mapped",
   "Lit texture map",
   "Lit persp. correct texture map",
   "Masked lit texture map",
   "Masked lit persp. correct texture map"
};

#define RENDER_MODES 12

#include "face.h"
/* Twas that Vertex values X & Y were not adjusted for perspexive reasons???
void RefToCenter(V3D* vtx)
{
  vtx->x += Current_Visual->X<<16;
  vtx->y = (Current_Visual->Y<<16) - vtx->y;
}
*/

VTX Light_Vector = { 1<<16, 0, 0 };   // normalized vector
fixed Light_Level;
bool Light_Shade = true;
bool Rainbow_Shade = true;

int ModRenderColor(int c)
{
  if(!Light_Shade)
    return(c);    // unchanged
// if using RainbowPallet then possibly quicker method
  if(!Rainbow_Shade) {  // slow but sure
    int r = ((getr(c)*(int)Light_Level)>>16)&0XFF;
    int g = ((getg(c)*(int)Light_Level)>>16)&0XFF;
    int b = ((getb(c)*(int)Light_Level)>>16)&0XFF;
    return( makecol(r,g,b));
  }
  if(c < 48)
    return((c*(int)Light_Level)>>16);
  int k = c - 48;
  int h = k /16;
  k = (k>>4)+4;  // shade level above black
  k *= (int)Light_Level;
  k = k >> 16;
  if(k < 4)
    return(k);
  k -= 4;
  if(k < 16)
    return(48 + h*16 + k);
  k -= 16;
  k += 43;
  if(k > 47)
    return(47);
  return(k);
}

fixed Face_Z = 0;

void DrawFacet(BITMAP *bmp, FacetClass* facet, int mode)
{
   int col;
   /* four vertices */
   V3D vtx1 = { facet->X1, facet->Y1, facet->Z1, 0,      0,      0 };
   V3D vtx2 = { facet->X2, facet->Y2, facet->Z2, 31<<16, 0,      0 };
   V3D vtx3 = { facet->X3, facet->Y3, facet->Z3, 31<<16, 31<<16, 0 };
   // vtx4 might contain garbage if face->P4 is null , don't worry
   V3D vtx4 = { facet->X4, facet->Y4, facet->Z4, 0,      31<<16, 0 };

   Light_Level = 1<<16;

   /* cull backfaces */
   if (    //  (mode != WIREFRAME_RENDER) && - wouldn't be here you nit
       (mode != POLYTYPE_ATEX_MASK) && (mode != POLYTYPE_PTEX_MASK) &&
       (mode != POLYTYPE_ATEX_MASK_LIT) && (mode != POLYTYPE_PTEX_MASK_LIT))
   { if(!(facet->Face->Flags & 1) ||   // not double sided
         1 //shade mode
       )
     { fixed x, y, z;
       cross_product(facet->X2 - facet->X1,facet->Y2 - facet->Y1,facet->Z2 - facet->Z1,
                     facet->X3 - facet->X2,facet->Y3 - facet->Y2,facet->Z3 - facet->Z2,
                     &x, &y, &z );
//       (polygon_z_normal(&vtx1, &vtx2, &vtx3) < 0))
       if(!(facet->Face->Flags & 1) &&   // not double sided
            z < 0)
         return;  // can't see this side anyhow
       Face_Z = z;
       
       //fixed nl = vector_length(x,y,z);
       //x = fixdiv(x,nl);
       //y = fixdiv(y,nl);
       //z = fixdiv(z,nl);
//       z = abs(z);
       if(z < 0) {  // will only happen for double sided
         x = -x;
         y = -y;
         z = -z;
       }
       normalize_vector(&x,&y,&z);
       // could look at a list of light sources but for now...
       // take 1 light vector (ie.from infinite distance)
       // add normalise vector and divide distance by 2
       // if pointing in same direction then Light_Level = 1
       // if pointing in opposite direction then Light_Level = 0
       // what more can you ask for - cosine functions???
   //    x = fixmul(x,Light_Vector.X);
   //    y = fixmul(y,Light_Vector.Y);
   //    z = fixmul(z,Light_Vector.Z);
   //    if(x < 0 || y < 0 || z < 0)
   //      Light_Level = 0;
   //    else
       x = fixsub(x,Light_Vector.X);
       y = fixsub(y,Light_Vector.Y);
       z = fixsub(z,Light_Vector.Z);
//       Light_Level = vector_length(x,y,z); // only works for integer numbers?
       Light_Level = fsqrt(fmul(x,x) + fmul(y,y) + fmul(z,z));
//       Light_Level = (x+y+z)
       Light_Level = Light_Level>>1;
     }
   }

  /*
   if(!Current_Visual->Mode)  // convert to screen position relative to center of view
   { RefToCenter(&vtx1);
     RefToCenter(&vtx2);
     RefToCenter(&vtx3);
     RefToCenter(&vtx4);
   }
  */
   /* set up the vertex color, differently for each rendering mode */
   switch (mode) {

      case POLYTYPE_FLAT:

      // need to fix this

//	 col = MID(128, 255 - fixtoi(face->P1->Z+face->P2->Z) / 16, 255);
         if((facet->Face->Flags & 1) &&  // double sided so use second color
            (Face_Z < 0))
           vtx1.c = palette_color[ModRenderColor(facet->Face->C2)];
         else
           vtx1.c = palette_color[ModRenderColor(facet->Face->C1)];
	 vtx2.c = vtx3.c = vtx4.c = vtx1.c;
// maybe should adjust color depending on angle of light
// could use C2 for reverse side color
// could use other C colors for color per direction?
	 break;

      case POLYTYPE_GCOL:
         vtx1.c = palette_color[ModRenderColor(facet->Face->C1)];
         vtx2.c = palette_color[ModRenderColor(facet->Face->C2)];
         vtx3.c = palette_color[ModRenderColor(facet->Face->C3)];
         vtx4.c = palette_color[ModRenderColor(facet->Face->C4)];
         // in 8bit modes, only shading of a single color works properly
	 break;

      case POLYTYPE_GRGB:
//	 vtx1.c = 0x000000;
//	 vtx2.c = 0x7F0000;
//	 vtx3.c = 0xFF0000;
//	 vtx4.c = 0x7F0000;
         // will only work in 24bit mode
         vtx1.c = ModRenderColor(facet->Face->C1);
         vtx2.c = ModRenderColor(facet->Face->C2);
         vtx3.c = ModRenderColor(facet->Face->C3);
         vtx4.c = ModRenderColor(facet->Face->C4);
	 break;

      case POLYTYPE_ATEX_LIT:
      case POLYTYPE_PTEX_LIT:
      case POLYTYPE_ATEX_MASK_LIT:
      case POLYTYPE_PTEX_MASK_LIT:
      // and this
	 vtx1.c = MID(0, 255 - fixtoi(facet->Face->P1->Z) / 4, 255);
	 vtx2.c = MID(0, 255 - fixtoi(facet->Face->P2->Z) / 4, 255);
	 vtx3.c = MID(0, 255 - fixtoi(facet->Face->P3->Z) / 4, 255);
         if(facet->Face->P4)
	   vtx4.c = MID(0, 255 - fixtoi(facet->Face->P4->Z) / 4, 255);
	 break; 
   }

   BITMAP* texture = NULL;
   if(facet->Face->Texture != NULL)
     texture = facet->Face->Texture->BitMap;
   /* draw the quad */
   if(facet->Face->P4)
     quad3d(bmp, mode, texture, &vtx1, &vtx2, &vtx3, &vtx4);
   else
     triangle3d(bmp, mode, texture, &vtx1, &vtx2, &vtx3);
}



/* RGB -> color mapping table. Not needed, but speeds things up */
RGB_MAP rgb_table;

/* lighting color mapping table */
COLOR_MAP light_table;

bool Render_Initialised = false;

void Render_Init()
{
   PALLETE pal;
   get_pallete(pal);
   create_rgb_table(&rgb_table, pal, NULL); // print_progress);
   rgb_map = &rgb_table;
   create_light_table(&light_table, pal, 0, 0, 0, NULL); //print_progress);
   color_map = &light_table;
   set_trans_blender(0, 0, 0, 128);
  Render_Initialised = true;
}

void RenderFaces(BITMAP* bmp)
{
  // use and destroy each facet
  if(!Render_Initialised)
    Render_Init();
  FacetClass* facet = FirstFacet;
  FirstFacet = NULL;
  while(facet)
  { DrawFacet(bmp,facet,Render_Type[RenderMode]);
    // faces might use different rendertypes in furture eg. windows etc.
    FacetClass* nextfacet = facet->NextFacet;
    delete facet;
    facet = nextfacet;
  }
}

int RenderModeChecker();  // predefine

int ShadeToLightChecker()
{
  active_menu->flags ^= D_SELECTED;
  Light_Shade = !Light_Shade;
  return D_OK;
}

int RainbowShadeChecker()
{
  active_menu->flags ^= D_SELECTED;
  Rainbow_Shade = !Rainbow_Shade;
  return D_OK;
}

MENU Menu_Render[] =
{
//  (text)                  (proc)          (child)     (flags)     (dp)
    { Render_Mode_Str[0], RenderModeChecker,     NULL,       0,          NULL },
    { Render_Mode_Str[1], RenderModeChecker,     NULL,       D_SELECTED, NULL },
    { Render_Mode_Str[2], RenderModeChecker,     NULL,       0,          NULL },
    { Render_Mode_Str[3], RenderModeChecker,     NULL,       0,          NULL },
    { Render_Mode_Str[4], RenderModeChecker,     NULL,       0,          NULL },
    { Render_Mode_Str[5], RenderModeChecker,     NULL,       0,          NULL },
    { Render_Mode_Str[6], RenderModeChecker,     NULL,       0,          NULL },
    { Render_Mode_Str[7], RenderModeChecker,     NULL,       0,          NULL },
    { Render_Mode_Str[8], RenderModeChecker,     NULL,       0,          NULL },
    { Render_Mode_Str[9], RenderModeChecker,     NULL,       0,          NULL },
    { Render_Mode_Str[10],RenderModeChecker,     NULL,       0,          NULL },
    { Render_Mode_Str[11],RenderModeChecker,     NULL,       0,          NULL },
    { "",                 NULL,                  NULL,       0,          NULL },
    { "Shade to Light",   ShadeToLightChecker,   NULL,       D_SELECTED, NULL },
    { "Rainbow Shade",    RainbowShadeChecker,   NULL,       D_SELECTED, NULL },
    { 0 }
};

int RenderModeChecker()
{
  if(Menu_Render)
  { for(int n=0; n < RENDER_MODES; n++)
    { if((Menu_Render + n) == active_menu)
        RenderMode = (RENDER_TYPE)n;
      Menu_Render[n].flags = 0;
    }
  }
  active_menu->flags ^= D_SELECTED;
  return D_OK;
}

