/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "layers.h"
#include "drawline.h"

unsigned Layers = 0;   // no including base level
ListClass LayerList;
LayerClass* Action_Layer = NULL;  // the layer into which new objects are placed

LayerClass::LayerClass() : ObjectClass()
{
  DeleteOnZero = true;    // when last reference is lost then this is destroyed
  ID = Layers;
  Name = NULL;
  Color = EGAColor[Layers % 15 + 1];  // default
  Force_Color = false;
  LineType = SOLID_LINE;
  Force_Type = false;
  Texture = NULL;
  Force_Texture = false;
  Layers++;
  for(int i = 0; i < LAYER_VIEWS; i++)
    ViewFlags[i] = (unsigned char)0;  // Show and Include
  MatchFlag = 0;  // no match   - this is a marker used in obj3ctrl
}

LayerClass::~LayerClass()
{
  if(Name)
    delete Name;
  Layers--;
}

#include "stdio.h"

char* Layer_Selector(int index, int* size)   // used by properties() in edit.cpp
{                                           // via vertex.cpp getproperty()
  static char dname[5];
  if(index < 0) {
    *size = Layers + 1;
    return NULL;
  }
  if(index == 0)
    return("DEFAULT NULL LAYER");
  LinkClass* link = LayerList.Find(index - 1);
  if(link)
  { LayerClass* layer = (LayerClass*)link->Object;
    if(layer)
    { if(layer->Name)
        return(layer->Name);
      sprintf(dname,"L%3d",layer->ID);
      return(dname);
    }
  }
  else
    return("LAYER DOESN'T SEEM TO EXIST");
}

