/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "insert.h"

InsertClass::InsertClass() : ObjectClass()
{ P1 = P2 = NULL;
  Rx=Ry=Rz=0;
  Sx=Sy=Sz=1<<16;
  RotOrder = 0;  // XYZ
  InsertBlock = Action_Block;
  MatrixMade = false;
}

void InsertClass::MakeMatrix()
{
  if(MatrixMade || !P1)
    return;
  // rotational transform in the opposite order to Camera tranform
  MATRIX mt, mx, my, mz, mo;
  get_translation_matrix(&mt,P1->Pos.X,P1->Pos.Y,P1->Pos.Z);
  // reverse rotations to z, y, and then x
  get_x_rotate_matrix(&mx,-Rx);  // opposite to normal translate?
  get_y_rotate_matrix(&my,-Ry);
  get_z_rotate_matrix(&mz,-Rz);
  matrix_mul(&mx,&my,&mo);
  matrix_mul(&mo,&mz,&mo);
  qscale_matrix(&mo,Sx);
  matrix_mul(&mo,&mt,&Matrix);
  MatrixMade = true;

}

InsertControlClass InsertControl;

InsertControlClass:: InsertControlClass() : Object3DControlClass()
{ Name = "Insert"; Properties = 7; // really 9 but Sy and Sz do nothing
  Color = LIGHT_MAGENTA;
}

ObjectClass* InsertControlClass::Create()
{
  return(new InsertClass);
}

long InsertControlClass::Size()
{
  return(sizeof(InsertClass));
}

void InsertControlClass::NewForOld( ObjectClass* object, ObjectClass* oldobj, ObjectClass* newobj)
{
  if(INSERT->P1 == (VertexClass*)oldobj)
    INSERT->P1 = (VertexClass*)newobj;
  if(INSERT->P2 == (VertexClass*)oldobj)
    INSERT->P2 = (VertexClass*)newobj;
}

bool InsertControlClass::Match(ObjectClass* object,BlockClass* block ,LayerClass* layer)
{ if(INSERT->P1)
    return(INSERT->P1->Block == block && (AllLayers || INSERT->P1->Layer == layer));
  else
    return false;
}

bool InsertControlClass::Include(ObjectClass* object, int, int, int, int)
{
  if(INSERT->P1 && INSERT->P1->Block == Base_Block)
    return(Current_Visual->Include(Type,INSERT->P1->Layer));
  return false;
}

/*
bool InsertControlClass::Inside(ObjectClass* object, int x, int y)
{
  if(!INSERT->P1 || INSERT->P1->Block != Base_Block)
    return false;
  // haven't decided whether to use P2 as well as per line
  // if so, wait for Insert to use a common ascestor as Line
  int x1, y1, z;
  VTX vtx;
  vtx.X = INSERT->X;
  vtx.Y = INSERT->Y;
  vtx.Z = INSERT->Z;
  Current_Visual->RealToFlat(&vtx,x1,y1,z);
}


int InsertControlClass::Distance(ObjectClass* object, int x, int y)
{
  return(VertexControl->Distance(INSERT->P1,x,y);
}
*/
#include "visulist.h"

bool InsertControlClass::DependantOn(ObjectClass* object) {
  return((INSERT->P1 == object));
}

char* RotOrderStr[] = {"XYZ","XZY","YXZ","YZX","ZXY","ZYX","???"};

char* RotOrderSelector(int ro, int* size)
{
  if(ro < 0) {
    *size = 6;
    return NULL;
  }
  else if(ro > 5)
    return RotOrderStr[6];
  return RotOrderStr[ro];
}

// should be called Get Pointer to and Name of Property
int InsertControlClass::GetProperty(ObjectClass* object, int n, void** p, char** name,
                                               void** select_function)
{
  *select_function = NULL;
  // user wants to have a better reference than a hexdecimal pointer so convert to link count
  static int vertex;
  static float fp;
  static int blocknum;
  fixed pf;
  fixed i;
  switch(n)
  { case 0:
      vertex = TargetList->Find_OfType(INSERT->P1,&VertexControl);
      *p = &vertex;
      *name = "P1:";
      return(INT_TYPE);
    case 1:
      vertex = TargetList->Find_OfType(INSERT->P2,&VertexControl);
      *p = &vertex;
      *name = "P2:";
      return(INT_TYPE);
    case 2:
      if(INSERT->InsertBlock)
        blocknum = BlockList.Find(INSERT->InsertBlock);   // -1 = no block
      else
        blocknum = -1;
      *p = &blocknum;
      *name = "Block";
      *select_function = Block_Selector;
      return(INT_TYPE | INDEX_TYPE | DDLIST_TYPE);
    case 3:
      pf = INSERT->Rx;
      *name = "X Rot'n";
      break;
    case 4:
      pf = INSERT->Ry;
      *name = "Y Rot'n";
      break;
    case 5:
      pf = INSERT->Rz;
      *name = "Z Rot'n";
      break;
    case 6:
      *p = &(INSERT->RotOrder);
      *name = "Rot.Order:";
      *select_function = RotOrderSelector;
      return(BYTE_TYPE | DDLIST_TYPE);
    case 7:
      pf = INSERT->Sx;
      *name = "Scale";     // "X Scale"
      break;
    case 8:
      pf = INSERT->Sy;
      *name = "Y Scale";
      break;
    case 9:
      pf = INSERT->Sz;
      *name = "Z Scale";
      break;
    default:
      return -1;
  }
  *p = &fp;
  fp = fixtof(pf);
  if(n < 6)
    fp *=360.0/256.0;  // convert to degrees
  return(FLOAT_TYPE | INDEX_TYPE);
}

int InsertControlClass::Summary(ObjectClass* object,char* str, int maxstr, int flags)
{
  if((flags & 1) && INSERT->P1 && INSERT->P1->Block != Base_Block) {
    str[0] = 0;
    return 0;
  }

  int i = 0;
  if(INSERT->InsertBlock)
    i += uszprintf(str,maxstr,"%s ",INSERT->InsertBlock->Name);
  else
    i += uszprintf(str,maxstr,"ERROR:NO BLOCK");
  int p1 = -1;
  int p2 = -1;
  if(INSERT->P1)
    p1 = TargetList->Find_OfType(INSERT->P1,&VertexControl);
  i += uszprintf(str+i,maxstr-1," P1=%d",p1);
  if(INSERT->P2)
    p2 = TargetList->Find_OfType(INSERT->P2,&VertexControl);
  i += uszprintf(str+i,maxstr-1," P2=%d",p2);
  
  i += uszprintf(str+i,maxstr-i," Rx=%f",fixtof(INSERT->Rx)*360.0/256.0);
  i += uszprintf(str+i,maxstr-i," Ry=%f",fixtof(INSERT->Ry)*360.0/256.0);
  i += uszprintf(str+i,maxstr-i," Rz=%f ",fixtof(INSERT->Rz)*360.0/256.0);
  i += uszprintf(str+i,maxstr-i,RotOrderStr[INSERT->RotOrder]);
  i += uszprintf(str+i,maxstr-i," Sx=%f",fixtof(INSERT->Sx));
  i += uszprintf(str+i,maxstr-i," Sy=%f",fixtof(INSERT->Sy));
  i += uszprintf(str+i,maxstr-i," Sz=%f",fixtof(INSERT->Sz));
  i += VertexControl.Summary_Layer(INSERT->P1,str+i,maxstr-i);
  i += VertexControl.Summary_Layer(INSERT->P2,str+i,maxstr-i);
  return(i);
}

#include "visulist.h"

int InsertControlClass::SetProperty(ObjectClass* object, int n, void* p)
{
  fixed fp;
  if(n > 2 && n != 6)
  { if(n < 6)
      fp = ftofix(*((float*)p)*256.0/360.0);
    else
      fp = ftofix(*(float*)p);
  }
  VertexClass* vtx;
  switch(n)
  { case 0:
      INSERT->P1 = (VertexClass*)TargetList->Find_OfType(*(int*)p,&VertexControl);
      INSERT->MatrixMade = false;
      break;
    case 1:
      INSERT->P2 = (VertexClass*)TargetList->Find_OfType(*(int*)p,&VertexControl);
      break;
    case 2:
      if(*((int*)p) >= 0) {
        LinkClass* l = BlockList.Find(*((int*)p));
        if(l) {
          BlockClass* b = (BlockClass*)(l->Object);
          if(b)
            INSERT->InsertBlock = b;
        }
      } else {
        INSERT->InsertBlock = NULL;
      }
      break;
    case 3:
      INSERT->Rx = fp;
      INSERT->MatrixMade = false;
      break;
    case 4:
      INSERT->Ry = fp;
      INSERT->MatrixMade = false;
      break;
    case 5:
      INSERT->Rz = fp;
      INSERT->MatrixMade = false;
      break;
    case 6:
      INSERT->RotOrder = *(int*)p;
/*      for(int ro = 0; ro  < 6; ro++) {
        if(stricmp((char*)p,RotOrderStr[ro]) == 0) {
          INSERT->RotOrder = ro;
          break;
        }
      } */
      INSERT->MatrixMade = false;
    case 7:
      INSERT->Sx = fp;
      INSERT->MatrixMade = false;
      break;
    case 8:
      INSERT->Sy = fp;
      INSERT->MatrixMade = false;
      break;
    case 9:
      INSERT->Sz = fp;
      INSERT->MatrixMade = false;
      break;
    default:
      return(-1);
  }
  return(0);
}

void InsertControlClass::GetRealLimits(ObjectClass* object, int& x1, int& y1, int& z1,
                                                          int& x2, int& y2, int& z2)
{
  x1 = MIN(INSERT->P1->Pos.X,INSERT->P2->Pos.X);
  x2 = MAX(INSERT->P1->Pos.X,INSERT->P2->Pos.X);
  y1 = MIN(INSERT->P1->Pos.Y,INSERT->P2->Pos.Y);
  y2 = MAX(INSERT->P1->Pos.Y,INSERT->P2->Pos.Y);
  z1 = MIN(INSERT->P1->Pos.Z,INSERT->P2->Pos.Z);
  z2 = MAX(INSERT->P1->Pos.Z,INSERT->P2->Pos.Z);
}

bool InsertControlClass::GetLimits(ObjectClass* object,int& x,int& y,int &z,
                                                       int& w,int& h,int &d)
{
  // use current visual mode to map object limits onto a flat plane
  int x1,y1,x2,y2,z1,z2;
  Current_Visual->RealToFlat(&INSERT->P1->Pos,x1,y1,z1);
  Current_Visual->RealToFlat(&INSERT->P2->Pos,x2,y2,z2);
  x = MIN(x1,x2);
  y = MIN(y1,y2);
  z = MIN(z1,z2);
  w = MAX(x1,x2)-x + 1;
  h = MAX(y1,y2)-y + 1;
  d = MAX(z1,z2)-z + 1;
  // don't use x,y,w,h for any line drawing nosense
  return(Current_Visual->Show(Type,INSERT->P1->Layer));
}

void InsertControlClass::SetLimits(ObjectClass* object,int x,int y,
                                                       int w,int h)
{
  // not sure if changing the vertex settings makes any sense
  // use current visual mode to map flat plane onto object limits
  //  VertexControl.SetLimits(INSERT->P1,x,y,w,h);
}

#include "findvisu.h"

const int MAX_INSERT_LEVEL = 32;
MATRIX Insert_Stack[MAX_INSERT_LEVEL];
int Insert_Level = 0;

void InsertControlClass::Draw(BITMAP* bmp,ObjectClass* object)
{
  // temporary adjustment of current_visual scale and position
  if(Insert_Level >= MAX_INSERT_LEVEL)
    return;
  Insert_Stack[Insert_Level++] = Current_Visual->TransMatrix;
  INSERT->MakeMatrix();
  matrix_mul(&INSERT->Matrix,&Current_Visual->TransMatrix,&Current_Visual->TransMatrix);

  DrawVisu(bmp,INSERT->InsertBlock);  // can recursively call other inserts
  // restore current_visual matrix
  Current_Visual->TransMatrix = Insert_Stack[--Insert_Level];
}

void InsertControlClass::Indicate(BITMAP* bmp, ObjectClass* object,
     int, int, int, int, int fg, int bg)
{
  int x1, x2, y1, y2, z;
  Current_Visual->RealToFlat(&INSERT->P1->Pos,x1,y1,z);
  if(INSERT->P2) {
    Current_Visual->RealToFlat(&INSERT->P2->Pos,x2,y2,z);
    dotted_line(bmp,x1,y1,x2,y2,fg,bg);
  } else {
    dotted_rect(bmp,x1-3,y1-3,x1+3,y1+3,fg,bg);
  }
}

