/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "face.h"
#include "drawline.h"
#include "alcolor.h"
#include "obj3ctrl.h"

FacetClass* FirstFacet = NULL;  // used for rendering in correct order
// this should always be null except during an actual render
// otherwise it means the linked list has not been deleted
int Face_Default_Colors[4] = { WHITE, WHITE, WHITE, WHITE };
char Face_Default_Texture_Name[MAX_TEXTURE_NAME] = { "NONE" };
char Face_Default_Flags = 0;

FaceClass::FaceClass() : ObjectClass()
{ P1 = P2 = P3 = P4 = NULL;
  C1 = C2 = C3 = C4 = WHITE;
  Texture = NULL;
};

FaceControlClass FaceControl;

FaceControlClass:: FaceControlClass() : Object3DControlClass()
{ Name = "Face"; Properties = 10;
  Color = LIGHT_GREEN;
}

ObjectClass* FaceControlClass::Create()
{
  return(new FaceClass);
}

long FaceControlClass::Size()
{
  return(sizeof(FaceClass));
}

void FaceControlClass::NewForOld( ObjectClass* object, ObjectClass* oldobj, ObjectClass* newobj)
{
  if(FACE->P1 == (VertexClass*)oldobj)
    FACE->P1 = (VertexClass*)newobj;
  if(FACE->P2 == (VertexClass*)oldobj)
    FACE->P2 = (VertexClass*)newobj;
  if(FACE->P3 == (VertexClass*)oldobj)
    FACE->P3 = (VertexClass*)newobj;
  if(FACE->P4 == (VertexClass*)oldobj)
    FACE->P4 = (VertexClass*)newobj;
}

bool FaceControlClass::Match(ObjectClass* object,BlockClass* block ,LayerClass* layer)
{ if(FACE->P1)
    return(FACE->P1->Block == block && (AllLayers || FACE->P1->Layer == layer));
  else
    return(false); // a non face after all
}

bool FaceControlClass::Include(ObjectClass* object, int, int, int, int)
{
  if(FACE->P1 && FACE->P1->Block == Base_Block)
    return(Current_Visual->Include(Type,FACE->P1->Layer));
  return(false);
}

bool FaceControlClass::Inside(ObjectClass* object, int x, int y)
{
  if(!FACE->P1 || !FACE->P2 || !FACE->P3 || FACE->P1->Block != Base_Block)
    return(false);   // an incompelete face
  long x1, x2, y1, y2, x3, y3, x4, y4, z;
  Current_Visual->RealToFlat(&FACE->P1->Pos,x1,y1,z);
  Current_Visual->RealToFlat(&FACE->P2->Pos,x2,y2,z);
  Current_Visual->RealToFlat(&FACE->P3->Pos,x3,y3,z);
  if(FACE->P4)
    Current_Visual->RealToFlat(&FACE->P4->Pos,x4,y4,z);
  else
  { x4 = x3;
    y4 = y3;
  }
  // *********** this is only the line check NEEDS WORK
  long dx = x2 - x1;
  long dy = y2 - y1;
  // quick and dirty check for line inclusion
  if(!dx && !dy)
  { if(abs(dx) < abs(dy))
    { dx = dx*(y-y1)/dy + x1 - x;
      if(dx > 1 || dx < -1)
        return(FALSE);
    }
    else
    { dy = dy*(x-x1)/dx + y1 - y;
      if(dy > 1 || dy < -1)
        return(FALSE);
    }
  }
  return(Current_Visual->Include(Type,FACE->P1->Layer));
}

int FaceControlClass::Distance(ObjectClass* object, int xc, int yc)
{
  if(!FACE->P1 || !FACE->P2 || !FACE->P3)
    return(false);   // an incompelete face
  int d[4];
  d[0] = VertexControl.Distance(FACE->P1,xc,yc);
  d[1] = VertexControl.Distance(FACE->P2,xc,yc);
  d[2] = VertexControl.Distance(FACE->P3,xc,yc);
  if(FACE->P4)
    d[3] = VertexControl.Distance(FACE->P4,xc,yc);
  else
    d[3] = d[2];
  int dr = MIN(d[0],d[1]);
  dr = MIN(dr,d[2]);
  dr = MIN(dr,d[3]);
  dr = MIN(dr,d[4]);
  return(dr);
  // not very good yet
  // first need to check if point is inside then need to check distance from edges
/*
  int x[4], y[4], z;
  Current_Visual->RealToFlat(&FACE->P1->Pos,x[1],y[1],z);
  Current_Visual->RealToFlat(&FACE->P2->Pos,x[2],y[2],z);
  Current_Visual->RealToFlat(&FACE->P3->Pos,x[3],y[3],z);
  if(FACE->P4)
    Current_Visual->RealToFlat(&FACE->P4->Pos,x[4],y[4],z);
  else
  { x[4] = x[3];
    y[4] = y[3];
  }
  for(int p = 0; p < 4; p++)
*/
  return(0);
}

#include "visulist.h"
int minus_one = -1;  // needed to return NULLvertex below

bool FaceControlClass::DependantOn(ObjectClass* object, ObjectClass* dependant)
{ return((dependant == FACE->P1 ||
      dependant == FACE->P2 ||
      dependant == FACE->P3 ||
      dependant == FACE->P4 ||
      dependant == FACE->Texture));
}

// should be called Get Pointer to and Name of Property
int FaceControlClass::GetProperty(ObjectClass* object, int n, void** p, char** name,
                                               void** select_function)
{
  static bool flag;
  static int texture;
  *select_function = NULL;
  VertexClass* vtx;
  switch(n)
  { case 0:
      vtx = FACE->P1;
      break;
    case 1:
      vtx = FACE->P2;
      break;
    case 2:
      vtx = FACE->P3;
      break;
    case 3:
      vtx = FACE->P4;
      break;
  }
  // user wants to have a better reference than a hexdecimal pointer so convert to link count
  if(n < 4 && vtx)
  { static int vertex; // static registers can't have dynamic assignment on the same line
    vertex = TargetList->Find_OfType(vtx,&VertexControl);
    *p = &vertex;
  }
  else
    *p = &minus_one;
  switch(n)
  { case 0:
      *name = "P1:";
      return(INT_TYPE | INDEX_TYPE);
    case 1:
      *name = "P2:";
      return(INT_TYPE | INDEX_TYPE);
    case 2:
      *name = "P3:";
      return(INT_TYPE | INDEX_TYPE);
    case 3:
      *name = "P4:";
      return(INT_TYPE | INDEX_TYPE);
    case 4:
      *name = "C1:";
      *p = &FACE->C1;
      *select_function = Color_Selecter;
      return(INT_TYPE);
    case 5:
      *name = "C2:";
      *p = &FACE->C2;
      *select_function = Color_Selecter;
      return(INT_TYPE);
    case 6:
      *name = "C3:";
      *p = &FACE->C3;
      *select_function = Color_Selecter;
      return(INT_TYPE);
    case 7:
      *name = "C4:";
      *p = &FACE->C4;
      *select_function = Color_Selecter;
      return(INT_TYPE);
    case 8:
      if(FACE->Texture)
        texture = TextureList.Find(FACE->Texture);   // -1 = no block
      else
        texture = -1;
      *p = &texture;
      *name = "Texture";
      *select_function = Texture_Selector;
      return(INT_TYPE | INDEX_TYPE | DDLIST_TYPE);
    case 9:
      *name = "DoubleSided";
      flag = ((FACE->Flags & 1) != 0);
      *p = &flag;
      return(BOOL_TYPE | INDEX_TYPE);
  }
  return(-1);
}

int FaceControlClass::Summary(ObjectClass* object,char* str, int maxstr, int flags)
{
  if((flags & 1) && FACE->P1 && FACE->P1->Block != Base_Block) {
    str[0] = 0;
    return(0);
  }
  int p1,p2,p3,p4;
  p1 = p2 = p3 = p4 = -1;
  if(FACE->P1)
    p1 = TargetList->Find_OfType(FACE->P1,&VertexControl);
  if(FACE->P2)
    p2 = TargetList->Find_OfType(FACE->P2,&VertexControl);
  if(FACE->P3)
    p3 = TargetList->Find_OfType(FACE->P3,&VertexControl);
  if(FACE->P4)
    p4 = TargetList->Find_OfType(FACE->P4,&VertexControl);
  int i = uszprintf(str,maxstr,"%s P=%d,%d,%d,%d",Name,p1,p2,p3,p4);
  i += uszprintf(str+i,maxstr-i,"C=%d,%d,%d,%d",
               FACE->C1,FACE->C2,FACE->C3,FACE->C4);
  if(FACE->Texture)
  { int t = TextureList.Find(FACE->Texture);
    if(t >= 0)
      i += uszprintf(str+i,maxstr-i," T=%d",t);
  }
  if(FACE->Flags & 1)
    i += uszprintf(str+i,maxstr-i," DS");
  if(FACE->P1)
    i += VertexControl.Summary_Layer(FACE->P1,str+i,maxstr-i);
  if(FACE->P1)
    i += VertexControl.Summary_Pos(FACE->P1,str+i,maxstr-i);
  if(FACE->P2)
    i += VertexControl.Summary_Pos(FACE->P2,str+i,maxstr-i);
  if(FACE->P3)
    i += VertexControl.Summary_Pos(FACE->P3,str+i,maxstr-i);
  if(FACE->P4)
    i += VertexControl.Summary_Pos(FACE->P4,str+i,maxstr-i);
  return(i);
}

#include "visulist.h"

int FaceControlClass::SetProperty(ObjectClass* object, int n, void* p)
{
  VertexClass* vtx;
  if(n < 4)
    vtx = (VertexClass*)TargetList->Find_OfType(*(int*)p,&VertexControl);
  switch(n)
  { case 0:
      FACE->P1 = vtx;
      break;
    case 1:
      FACE->P2 = vtx;
      break;
    case 2:
      FACE->P3 = vtx;
      break;
    case 3:
      FACE->P4 = vtx;
      break;
    case 4:
      FACE->C1 = *((int*)p);
      break;
    case 5:
      FACE->C2 = *((int*)p);
      break;
    case 6:
      FACE->C3 = *((int*)p);
      break;
    case 7:
      FACE->C4 = *((int*)p);
      break;
    case 8:
      if(*((int*)p) >= 0) {
        LinkClass* l = TextureList.Find(*((int*)p));
        if(l) {
          TextureClass* b = (TextureClass*)(l->Object);
          if(b)
            FACE->Texture = b;
        }
      } else {
        FACE->Texture = NULL;
      }
      break;
    case 9:
      FACE->Flags |= FACES_DOUBLE_SIDED_FLAG;   // double sided
      if(!(*((bool*)p)))
        FACE->Flags ^= FACES_DOUBLE_SIDED_FLAG;  // not double sided
      break;
    default:
      return(-1);
  }
  return(0);
}

void FaceControlClass::GetRealLimits(ObjectClass* object, fixed& x1, fixed& y1, fixed& z1,
                                                          fixed& x2, fixed& y2, fixed& z2)
{
  if(FACE->P1)
  { x1 = x2 = FACE->P1->Pos.X;
    y1 = y2 = FACE->P1->Pos.Y;
    z1 = z2 = FACE->P1->Pos.Z;
  }
  else
    return;
  for(int i = 0; i < 3; i++)
  { VertexClass* p;
    switch(i)
    { case 0:
        p = FACE->P2;
        break;
      case 1:
        p = FACE->P3;
        break;
      case 2:
        p = FACE->P4;
        break;
    }
    if(!p)
      break;
    x1= MIN(x1,p->Pos.X);
    x2= MAX(x2,p->Pos.X);
    y1= MIN(y1,p->Pos.Y);
    y2= MAX(y2,p->Pos.Y);
    z1= MIN(z1,p->Pos.Z);
    z2= MAX(z2,p->Pos.Z);
  }
}


bool FaceControlClass::GetLimits(ObjectClass* object,int& xl,int& yl,int& zl,
                                                       int& wl,int& hl,int& dl)
{
  // use current visual mode to map object limits onto a flat plane
  long x,y,z;
  if(FACE->P1)
    Current_Visual->RealToFlat(&FACE->P1->Pos,x,y,z);
  else
    return(false);  // no face at all
  long mx1 = x;
  long mx2 = x;
  long my1 = y;
  long my2 = y;
  long mz1 = z;
  long mz2 = z;
  if(FACE->P2)
  { Current_Visual->RealToFlat(&FACE->P2->Pos,x,y,z);
    mx1 = MAX(x,mx1);
    mx2 = MIN(x,mx2);
    my1 = MAX(y,my1);
    my2 = MIN(y,my2);
    mz1 = MAX(z,mz1);
    mz2 = MIN(z,mz2);
  }
  if(FACE->P3)
  { Current_Visual->RealToFlat(&FACE->P3->Pos,x,y,z);
    mx1 = MAX(x,mx1);
    mx2 = MIN(x,mx2);
    my1 = MAX(y,my1);
    my2 = MIN(y,my2);
    mz1 = MAX(z,mz1);
    mz2 = MIN(z,mz2);
  }
  if(FACE->P4)
  { Current_Visual->RealToFlat(&FACE->P4->Pos,x,y,z);
    mx1 = MAX(x,mx1);
    mx2 = MIN(x,mx2);
    my1 = MAX(y,my1);
    my2 = MIN(y,my2);
    mz1 = MAX(z,mz1);
    mz2 = MIN(z,mz2);
  }

  xl = mx1;
  yl = my1;
  zl = mz1;
  wl = mx2-mx1 + 1;
  hl = my2-my1 + 1;
  dl = mz2-mz1 + 1;

  return(Current_Visual->Show(Type,FACE->P1->Layer));
}

void FaceControlClass::SetLimits(ObjectClass* object,int x,int y,
                                                       int w,int h)
{
  // not sure if changing the vertex settings makes any sense
  // use current visual mode to map flat plane onto object limits
  //  VertexControl.SetLimits(FACE->P1,x,y,w,h);
  //  VertexControl.SetLimits(FACE->P2,x,y,w,h);
}

void FaceControlClass::Draw(BITMAP* bmp,ObjectClass* object)
{
  if(!FACE->P1 || !Current_Visual->Show(Type,FACE->P1->Layer))
    return;
  // use current visual mode to protray object on bmp
  int x1, y1, x2, y2, x3, y3, x4, y4, z;
  if(!FACE->P1 || !FACE->P2 || !FACE->P3)
    return;
  FACE->P1->RealToFlat(x1,y1,z);
//  Current_Visual->RealToFlat(&FACE->P1->Pos,x1,y1,z);
    FACE->P2->RealToFlat(x2,y2,z);
//  Current_Visual->RealToFlat(&FACE->P2->Pos,x2,y2,z);
    FACE->P3->RealToFlat(x3,y3,z);
//  Current_Visual->RealToFlat(&FACE->P3->Pos,x3,y3,z);
  if(FACE->P4)
    FACE->P4->RealToFlat(x4,y4,z);
//    Current_Visual->RealToFlat(&FACE->P4->Pos,x4,y4,z);
  // if current_visual has another system for faces then
  // load vertix and face arrays before a final draw occurs
  // otherwise use default drawing of face below
  // variables C1,C2,C3,C4,Texture
  int color = VertexControl.GetColor(FACE->P1,Color);
  line(bmp,x1,y1,x2,y2,color);
  line(bmp,x2,y2,x3,y3,color);
  if(FACE->P4)
  { line(bmp,x3,y3,x4,y4,color);
    line(bmp,x4,y4,x1,y1,color);
  }
  else
    line(bmp,x3,y3,x1,y1,color);
}

void FaceControlClass::Render(ObjectClass* object)
{
  if(!Current_Visual->Show(Type,FACE->P1->Layer))
    return;
  int x,y,z;
  int zmax = MININT;
  if(!FACE->P1 || !FACE->P2 || !FACE->P3)
    return;
  // look for furthest point in the view
  // also check to see that a given point is within the view
  // problem here if point is just outside view - **** need to fix one day
  FACE->P1->RealToFlat(x,y,z);
  int r1 = Current_Visual->Inside(x,y,z);   // check if it's even in the picture
  if(z > zmax)
    zmax = z;
  FACE->P2->RealToFlat(x,y,z);
  int r2 = Current_Visual->Inside(x,y,z);   // check if it's even in the picture
  if(z > zmax)
    zmax = z;
  FACE->P3->RealToFlat(x,y,z);
  int r3 = Current_Visual->Inside(x,y,z);   // check if it's even in the picture
  if(z > zmax)
    zmax = z;
  int r4 = r3;
  if(FACE->P4) {
    FACE->P4->RealToFlat(x,y,z);
    r4 = Current_Visual->Inside(x,y,z);   // check if it's even in the picture
    if(z > zmax)
      zmax = z;
  }
  if(r1 && r2 && r3 && r4)     // all points outside view
  { int rt = r1 | r2 | r3 | r4;  // bit1 <X, bit2 >X, bit3<Y, bit4>Y
    if((rt & 0x03)!= 3 && (rt & 0x0C)!= 0x0C)  // no points on opposite sides
      return;
  }
  // limit objects to view by screen width back from camera position?
  if(zmax > -SCREEN_W) { // use this distance to order this face for rendering
    FacetClass* f = new FacetClass(FACE,zmax);
    FacetClass* facet = FirstFacet;
    if(!facet) {
      // start the chain
      FirstFacet = f;
    } else if(facet->Far_Z < zmax) {
      // demote first line
      FirstFacet = f;
      f->NextFacet = facet;
    } else {
      while(facet) {
        FacetClass* lastfacet = facet;
        facet = facet->NextFacet;
        if(!facet || (facet->Far_Z < zmax)) {
          // break into link
          lastfacet->NextFacet = f;
          f->NextFacet = facet;
          break;
        }
      }
    }
  }
}

// facets are used in render to .. well .. render the faces
// faces may be shared in multipul blocks, so copy current Vertex positions
// assumes preuse of FaceClass::Render()
FacetClass::FacetClass(FaceClass* face, long z)
{
  Face = face;
  Far_Z = z;
  if(face->P1) {
    X1 = face->P1->X;
    Y1 = face->P1->Y;
    Z1 = face->P1->Z;
  }
  if(face->P2) {
    X2 = face->P2->X;
    Y2 = face->P2->Y;
    Z2 = face->P2->Z;
  }
  if(face->P3) {
    X3 = face->P3->X;
    Y3 = face->P3->Y;
    Z3 = face->P3->Z;
  }
  if(face->P4) {
    X4 = face->P4->X;
    Y4 = face->P4->Y;
    Z4 = face->P4->Z;
  }
  NextFacet = NULL;
}

void FaceControlClass::Indicate(BITMAP* bmp, ObjectClass* object,
     int, int, int, int, int fg, int bg)
{
  int x1, y1, x2, y2, x3, y3, x4, y4, z;
  if(FACE->P1)
    FACE->P1->RealToFlat(x1,y1,z);
//    Current_Visual->RealToFlat(&FACE->P1->Pos,x1,y1,z);  // old version slower but still works
// only slower because it's don't repedively
  else
    return;  // no face at all
  if(FACE->P2)
    FACE->P2->RealToFlat(x2,y2,z);
//    Current_Visual->RealToFlat(&FACE->P2->Pos,x2,y2,z);
  else
    return;  // what's there to show
  if(FACE->P3)
    FACE->P3->RealToFlat(x3,y3,z);
//    Current_Visual->RealToFlat(&FACE->P3->Pos,x3,y3,z);
  if(FACE->P4)
    FACE->P4->RealToFlat(x4,y4,z);
//    Current_Visual->RealToFlat(&FACE->P4->Pos,x4,y4,z);
  
  // at present all line types are the same
  dotted_line(bmp,x1,y1,x2,y2,fg,bg);
  if(FACE->P3)
  { dotted_line(bmp,x2,y2,x3,y3,fg,bg);
    if(FACE->P4)
    { dotted_line(bmp,x3,y3,x4,y4,fg,bg);
      dotted_line(bmp,x4,y4,x1,y1,fg,bg);
    }
    else
      dotted_line(bmp,x3,y3,x1,y1,fg,bg);
  }
}
