/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "blocks.h"

unsigned Blocks = 0;
ListClass BlockList;
BlockClass* Action_Block = NULL;  // the block used for inserts
BlockClass* Base_Block = NULL;  // the block into which new objects are placed

BlockClass::BlockClass() : ObjectClass()
{
  ID = Blocks;
  Name = NULL;
  Color = EGAColor[Blocks % 15 + 1];
  Blocks++;
  MatchFlag = 0;
  DeleteOnZero = true;
}

BlockClass::~BlockClass()
{
  if(Name)
    delete Name;
  Blocks--;
}

#include "stdio.h"

char* Block_Selector(int index, int* size)   // used by properties() in edit.cpp
{                                           // via vertex.cpp getproperty()
  static char dname[5];
  if(index < 0) {
    *size = Blocks + 1;
    return NULL;
  }
  if(index == 0)
    return("NULL BLOCK???");
  LinkClass* link = BlockList.Find(index - 1);
  if(link)
  { BlockClass* block = (BlockClass*)link->Object;
    if(block)
    { if(block->Name)
        return(block->Name);
      sprintf(dname,"B%3d",block->ID);
      return(dname);
    }
  }
  else
    return("BLOCK DOESN'T SEEM TO EXIST");
}

