/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "avi.h"
#include <string.h> // just for stricmp()

AVI_Struct Last_AVI_Loaded;

/*
LIST hdrl
  avih
  LIST strl
    strh vids
    strf
  LIST strl
    strh auds
    strf
  ISFT
  IDIT
00 00
JUNK
LIST movi
  "00db"
  "01wb"
  JUNK
*/

const char* ChunkStr[] = { "avih", "strh", "strf", "00db", "00dc", "01wb", "" };
const char* ListStr[] = { "hdrl", "strl", "movi", "" };
int Chunk_Level;

int Match_From_List(char* c, const char* str[])
{ int t = 1;
  while(str[t-1][0])
  { if(!stricmp(str[t-1],c))
      return(t);
    t++;
  }
  return(0);
}

long Chunk_Size[4];
long Chunk_Position[4];

int Skip_Chunk(FILE* file)
{
  return(fseek(file,Chunk_Position[Chunk_Level]+Chunk_Size[Chunk_Level],SEEK_SET));  // go to next list or chunk
}

int Find_Tag(FILE* file)
{ char tag[5];
  int type;
  int chunk_add;
  long pos;
  tag[0] = 0;
  while(!feof(file) && !tag[0])  // egnor 0's
  { fread(tag,1,1,file);
  }
  tag[4] = 0; // terminate the string
  fread(tag+1,3,1,file);  // get the remainder of the tag
  pos = ftell(file);
  // see if we're past the end of a previous parent chunk
  if(Chunk_Level && pos > Chunk_Position[Chunk_Level-1]+Chunk_Size[Chunk_Level-1])
    Chunk_Level--;
  fread(Chunk_Size + Chunk_Level,4,1,file);   // might be chunk size or list length
  Chunk_Position[Chunk_Level] = pos + 4;
  if(!stricmp(tag,"LIST"))
  { fread(tag,4,1,file);
    type = Match_From_List(tag,ListStr);
    chunk_add = 0;
    if(!type)  // not recognised so skip this list
      Skip_Chunk(file);
    else
      Chunk_Level++;
  }
  else
  { type = Match_From_List(tag,ChunkStr);
    chunk_add = 128;
    if(!type)  // not recognised or JUNK so skip this chunk
      Skip_Chunk(file);
  }
  return(type + chunk_add);
}

int Load_Bitmap(AVI_Struct* avi, FILE* file, BITMAP* bmp)
{
  unsigned char irgb[4];
  int x,y,c;
  if(avi->BitsPerPixel < 24)
    return(1);   // only support 24 and 32 bits per pixel at the moment
  for(y = avi->Height-1; y >= 0; y--)
  { for(x = 0; x < avi->Width; x++)
    { fread(&irgb,(avi->BitsPerPixel-1)/8+1,1,file);
      c = makecol(irgb[2],irgb[1],irgb[0]);
      putpixel(bmp,x,y,c);
    }
  }
}

int AVI_Load_Error = 0;

BITMAP* Load_Frame(char* path, int frame, int* frames, AVI_Struct* avi_stats)
{ FILE* file;
  char tag[5];
  unsigned long file_size;
  unsigned long list_length;
  unsigned long chunk_size;
  BITMAP* bmp = NULL;
  AVI_Struct* avi = &Last_AVI_Loaded;
  int object;
  int stream_header = 0;
  int frame_count = 0;
  tag[4] = 0;

  long file_pos = 0;
  file = fopen(path,"rb");
  if(!file)
  { AVI_Load_Error = 1;
    return(NULL);
  }
  do
  { if(!fread(&tag,4,1,file))  // test the read at least once
    { AVI_Load_Error = 2;
      break;
    }
    if(stricmp(tag,"RIFF"))
    { AVI_Load_Error = 3;
      break;
    }
    fread(&file_size,4,1,file);  // of no partiulcar use
    fread(tag,4,1,file);
    if(stricmp(tag,"avi "))
    { AVI_Load_Error = 4;
      break;
    }
    Chunk_Level = 0;
    do
    { object = Find_Tag(file);
      switch(object)
      { case 1:  // htrl  - nothing to do really
          break;
        case 129:  // avih
          fread(&avi->uSecPerFrame,4,1,file);
          fseek(file,12,SEEK_CUR);
          fread(&avi->Frames,4,1,file);
          if(frames)
            *frames = avi->Frames;
          fseek(file,12,SEEK_CUR);
          fread(&avi->Width,4,1,file);
          fread(&avi->Height,4,1,file);
          Skip_Chunk(file);
          break;
        case 2: // strl
          break;
        case 130: // strh for vids and auds
          fread(tag,4,1,file);
          if(!stricmp(tag,"vids"))
            stream_header = 0;
          else if(!stricmp(tag,"auds"))
            stream_header = 1;
          Skip_Chunk(file);
          break;
        case 131: // strf
          if(!stream_header)          // vids
          { fseek(file,14,SEEK_CUR);
            fread(&avi->BitsPerPixel,2,1,file);
            fseek(file,4,SEEK_CUR);
            fread(&avi->BytesPerFrame,4,1,file);
          }
          else                          // auds
          { fseek(file,2,SEEK_CUR);
            fread(&avi->Channels,2,1,file);
            fread(&avi->SamplesPerSecond,4,1,file);
            fread(&avi->BytesPerSecond,4,1,file);
            fread(&avi->BytesPerSample,2,1,file);
            fread(&avi->BitsPerSample,2,1,file);
          }
          Skip_Chunk(file);
          break;
        case 3:  // movi
          break;
        case 132: // 00db
        case 133: // 00dc  - sometimes uncompressed AVI still gets labelled thus
          if(frame_count < frame)  // not the right frame yet
          { Skip_Chunk(file);
            frame_count++;
            break;
          }
          bmp = create_bitmap_ex(8,avi->Width,avi->Height);
          if(bmp)
            Load_Bitmap(avi,file,bmp);
          if(Chunk_Level)   // move back to movi list level
            Chunk_Level--;
          Skip_Chunk(file); // skip to the end of movi
          break;
        case 134:  // 01wb
          Skip_Chunk(file);
          break;
      }
      file_pos = ftell(file);
    } while(file_pos < file_size + 8);
    if(avi_stats)
      memcpy(avi_stats,&Last_AVI_Loaded,sizeof(AVI_Struct));
  } while(0);
  fclose(file);
  return(bmp);
}

  
