/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "a3dsave.h"

extern PACKFILE* pf; // = NULL;  // already defined in a3load.cpp somehow - may not apply to other compilers
#define MAXSTRING 256

int WByte(BYTE b)
{ BYTE n = b;
  return(pack_fwrite(&n,1,pf) != 1);
}

int WInt(int i)
{ int n = i;
  return(pack_fwrite(&n,sizeof(int),pf) != sizeof(int));
}

int WUnsigned(unsigned u)
{ unsigned n = u;
  return(pack_fwrite(&n,sizeof(unsigned),pf) != sizeof(unsigned));
}

int WFixed(fixed fx)
{ fixed f = fx;
  return(pack_fwrite(&f,sizeof(fixed),pf) != sizeof(fixed));
}

int WString(char* str)
{
  int size = ustrlen(str);
  // store size of string - ie. don't use null terminate
  if(pack_fwrite(&size,sizeof(int),pf) != sizeof(int))
    return 2;
  char* buf = new char[size+1];
  char* s = uconvert(str,U_CURRENT,buf,U_ASCII,size-1);
  int ret = (pack_fwrite(s,size,pf) != size);
  if(buf)
    delete buf;
  return(ret);
}

int WColor(int color)
{ unsigned red, green, blue;
  red = getr(color);
  green = getg(color);
  blue = getb(color);
  if(WByte(red) || WByte(green) || WByte(blue))
    return(1);
  return(0);
}

#include "vertex.h"
#include "line.h"
#include "arc.h"
#include "spline.h"
#include "face.h"
#include "insert.h"
#include "findvisu.h"
#include "a3dload.h"  // somethings in commmon

void LineBaseSave(ObjectClass* object, BlockClass* block, LayerClass* layer) {
  WUnsigned(FindMatchingVertex(LINE->P1,block,layer));
  WUnsigned(FindMatchingVertex(LINE->P2,block,layer));
  WByte(LINE->Type);
  WByte(LINE->Width);
  // assume referred previous lines and parrellel lines already saved
  WUnsigned(FindMatchingLine(LINE->L1,block,layer));
  WUnsigned(FindMatchingLine(LINE->PL1,block,layer));
}

int Save_Entities(BlockClass* block = NULL)
{
/* OBJECT_CONTROL_TYPES { VERTEX_CONTROL =0,
   FACE_CONTROL, INSERT_CONTROL, LINE_CONTROL, ARC_CONTROL, SPLINE_CONTROL };
*/
  LinkClass* layerlink = LayerList.FirstLink();
  while(TRUE)
  { LayerClass* layer = NULL;
    if(layerlink)
       layer = (LayerClass*)(layerlink->Object);
    // otherwise do base layer
    OBJECT_CONTROL_TYPES type = VERTEX_CONTROL;
    Object3DControlClass* control = ControlClasses[type];
    while(control)
    { unsigned numberoftype = CountMatchingObject(control,block,layer);
      VisualLinkClass* object_link = NULL;
      if(numberoftype) // else effectively skips to next type
      { WByte((BYTE)type+1);   // 0 is terminator
        WByte(SizeOfA3DObject[type]);   // to allow old readers to read new formats
        WUnsigned(numberoftype);   // eg. how many Vertex
        object_link = FirstMatchingObject(control,block,layer);
      }
      while(object_link)
      { ObjectClass* object = object_link->Object;
        unsigned p3;
        switch(type)
        { case VERTEX_CONTROL:   // 3 byt sizeof(fixed)
            WFixed(VERTEX->Pos.X);
            WFixed(VERTEX->Pos.Y);
            WFixed(VERTEX->Pos.Z);
            break;
          case FACE_CONTROL:   // 22 bytes
            WUnsigned(FindMatchingVertex(FACE->P1,block,layer));
            WUnsigned(FindMatchingVertex(FACE->P2,block,layer));
            p3 = FindMatchingVertex(FACE->P3,block,layer);
            WUnsigned(p3);
            if(FACE->P4)
              WUnsigned(FindMatchingVertex(FACE->P4,block,layer));
            else
              WUnsigned(p3); // p3 = p4 in triangle
            // layer->Texture may override FACE->Texture which may override
            // FACE->C# but all are written to key type length consistant
            if(FACE->Texture)
              WUnsigned(TextureList.Find(FACE->Texture));
            else
              WUnsigned(0xFFFF);
            WColor(FACE->C1); // 3 bytes each
            WColor(FACE->C2);
            WColor(FACE->C3);
            WColor(FACE->C4);
            WUnsigned(FACE->Flags);
            break;
          case INSERT_CONTROL:
            WUnsigned(BlockList.Find(INSERT->InsertBlock));
            WUnsigned(FindMatchingVertex(INSERT->P1,block,layer));
            WUnsigned(FindMatchingVertex(INSERT->P2,block,layer));
            WFixed(INSERT->Rx);
            WFixed(INSERT->Ry);
            WFixed(INSERT->Rz);
            WByte(INSERT->RotOrder);
            WFixed(INSERT->Sx);
            WFixed(INSERT->Sy);
            WFixed(INSERT->Sz);
            break;
          case LINE_CONTROL:    // 10 bytes
            LineBaseSave(object,block,layer);
            break;
          case ARC_CONTROL:    // 12 bytes
            LineBaseSave(object,block,layer);
            WUnsigned(FindMatchingVertex(ARC->P3,block,layer));
            WUnsigned(FindMatchingVertex(ARC->P4,block,layer));
            WByte(ARC->Flags);
            break;
          case SPLINE_CONTROL:  // 12 bytes + 3 or 6 x sizeof(fixed)
            LineBaseSave(object,block,layer);
            WUnsigned(SPLINE->Flags);
            WFixed(SPLINE->V1.X);
            WFixed(SPLINE->V1.Y);
            WFixed(SPLINE->V1.Z);
            WFixed(SPLINE->V2.X);
            WFixed(SPLINE->V2.Y);
            WFixed(SPLINE->V2.Z);
            break;
        }
        object_link = NextMatchingObject(object_link,control,block,layer);
      }
      ((int)type)++;
      control = ControlClasses[type]; // will be null at end of types
    }
    WByte(0);  // end entities for this layer
    if(!layer)
      break;
    layerlink = layerlink->NextLink();
  }
}

int Save_A3D()
{
  WUnsigned(THIS_VERSION);  // version - from A3Load.h
  WUnsigned(0); // textures - fixthis up when I know what textureclass contains
  WUnsigned(Layers); // save number of layers
  LinkClass* link = LayerList.FirstLink(); // find first layer
  unsigned layernum = 1;
  while(link)
  { LayerClass* layer = (LayerClass*)(link->Object);
    if(layer->Name)
      WString(layer->Name);
    else
    { char str[20];
      sprintf(str,"L#%d",layernum);
      WString(str);
    }
    WColor(layer->Color);
    WByte(layer->LineType);
    unsigned t = 0;
    if(layer->Texture)
      t = TextureList.Find(layer->Texture) + 1;
    WUnsigned(t);
    link = link->NextLink();
    layernum++;
  }
  WUnsigned(Blocks);  // save number of blocks
  link = BlockList.FirstLink(); // get first block
  int blocknum = 1;
  while(link)
  { BlockClass* block = (BlockClass*)(link->Object);
    if(block->Name)
      WString(block->Name);  // save block name
    else
    { char str[20];
      sprintf(str,"B#%d",blocknum);
      WString(str);
    }
    WColor(block->Color);
    WFixed(block->Base.X);
    WFixed(block->Base.Y);
    WFixed(block->Base.Z);
      Save_Entities(block);
    link = link->NextLink();
    blocknum++;
  }
  Save_Entities();  // save non block entities
}

bool SaveUnPacked = false;

int SaveA3D(char* path)
{
  char* errorstr = "PACKED SAVE ERROR";
  if(!SaveUnPacked)
    pf = pack_fopen(path,"wp");  // standard unpacked
  else
    pf = pack_fopen(path,"w!");  // ! will enable load to detect that file is unpacked
  if(!pf)
  { billalert(errorstr,path,"Couldn't open file for writing","&Ok",NULL,'o',0);
    return(1);
  }
  int errorcode = Save_A3D();
  if(errorcode)
  { char errortype[32];
    sprintf(errortype,"Code:%3d",errorcode);
    billalert(errorstr,errortype,"in Save_A3D","&Ok",NULL,'o',0);
    pack_fclose(pf);
    return(1);
  }
  pack_fclose(pf);
  return(0);
}

