/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef VISUAL_LINKHPP
#define VISUAL_LINKHPP

#include "linklist.h"
#include "grid.h"
#include "drawrect.h"
#include "objctrl.h"
#include <allegro.h>   // for PACK_FILE
#include <stdio.h>

class VisualListClass;  // predefine

class VisualLinkClass : public LinkClass
{
public:
  int X, Y, W, H;         // on screen quality
  bool Visible;
  bool PosLocked;        // prevent user reposition
  bool SizeLocked;       // prevent user resize
  ObjectControlClass* Control; // this knows how to draw and update the object
  
  VisualLinkClass(ObjectClass*);
  ~VisualLinkClass();
  bool Inside(int,int);
  bool Include(int,int,int,int);
  virtual void Indicate(BITMAP*,int = 0,int = 255);   // use link defaults
  void Xor_Indicate();  // these use the screen regardless
  int Drag_Resize(int,int,int = 0);   // these use the screen regardless

  virtual void Update();
  virtual void Draw(BITMAP*);   // nothing at present
};

class VisualListClass : public ListClass
{
public:
  bool ObjectSnap;
  ObjectControlClass* FindOnly;
  int ClipX1, ClipY1, ClipX2, ClipY2;   // mainly used for object snap
  VisualListClass();
  VisualLinkClass* Add(ObjectClass*,ObjectControlClass*,LinkClass* = NULL);
  virtual VisualLinkClass* CreateLink(ObjectClass* obj, ObjectControlClass* control);
  VisualLinkClass* Add(ObjectControlClass*,int,int,int,int);
  VisualLinkClass* Copy(VisualLinkClass*,LinkClass* = NULL,bool = false);
  virtual VisualLinkClass* Find_Mouse_Object();
  virtual VisualLinkClass* Find_Object(int,int);
  void Set_Clip(int,int,int,int);
// The following function doesn't seem to exist
//  VisualLinkClass* Add(VisualLinkClass*);  // sort of a copy function
  int  Drag_Move(VisualLinkClass*,int,int,int = 0);
  int  Drag_Select(void);
  void Xor_Indicate_Selected(void);
  int  Snap_Selected(void);
  void Indicate_Selected(BITMAP* bmp, int = 0, int = 255);
  void Draw_All(BITMAP* bmp);
  long Load(FILE*);
  void Save(PACKFILE*);
  int Find_OfType(ObjectClass*,ObjectControlClass* = NULL,
                       ObjectControlClass* = NULL,
                       ObjectControlClass* = NULL);
  ObjectClass* Find_OfType(int,ObjectControlClass* = NULL,
                       ObjectControlClass* = NULL,
                       ObjectControlClass* = NULL);
  bool DependantOn(ObjectClass* object);
  void Delete_Selected();  // overload to dependant check is made
//  void Clear();
  virtual void Update() { ListClass::Update(); }; // needed for childclasses
};

extern VisualLinkClass* target;  // needed by macro, must be global to avoid redeclare
extern VisualListClass* TargetList;   // current edit target
extern unsigned Targets;

#define BEGIN_TARGETLIST target = (VisualLinkClass*)TargetList->FirstLink(); \
                         while(target) {
#define END_TARGETLIST   target = (VisualLinkClass*)(target->NextLink()); }
#endif
