/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "alcolor.h"
#include "xproc.h"
#include <string.h>

int EGAColor[] = { 0, 69, 115, 99, 216, 50, 189, 32, 12, 107, 130, 110, 252, 62, 179, 47 };

INLINE int COL24(int c)
{
    return makecol_depth(24, getr(c), getg(c), getb(c));
}

INLINE int COL(int c)
{
    return makecol(getr_depth(24, c), getg_depth(24, c), getb_depth(24, c));
}

int Back_fg, Back_mg, Back_bg;

// pallet variables and defaults
// dark, light, purple, blue, spruce, cyan, green, lightgreen, yellow, orange, red, maroon
BYTE rh[] = { 255,255,128,  0,  0,  0,  0,192,255,255,255,255};    // red factor
BYTE gh[] = { 255,255,  0,  0,128,255,255,255,255,128,  0, 64};    // green factor
BYTE bh[] = { 255,255,255,255,255,255,  0,  0,  0,  0,  0,128};    // blue factor
BYTE sh[] = {   8, 32,  8,  8,  8, 12, 20, 20, 20, 16, 16, 16, 0}; // pure shades
BYTE lh[] = {   0,  8,  8,  8,  8,  4,  4,  4,  4,  8,  8,  8, 0}; // pastels
BYTE fh[] = {   0, 64, 80, 80, 80, 64, 64, 64, 64, 64, 64, 64};    // from shade level
BYTE th[] = {  60,192,255,255,255,255,255,255,255,255,255,255};    // to shade level
BYTE eh[] = {   0,255,192,192,192,192,192,192,192,192,192,192};    // end white level
char oh[] = {   0,  0,  5,  5,  5,  7,  7,  7,  7,  7,  7,  7};    // offset to grey
char ph[] = {   0,  0,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5};    // offset from white
char Palette_Hues = 0;
bool First_Draw = TRUE;
//
// sum of sh and lh should add up to 256

int Display_Palette(int x, int y, int w, int h, int highlight = 256)
{ int c = 0;
  int gc = -1;  // interim color found
  int ss, sg;
  int hx1 = -1, hx2, hy1, hy2;
  for(int hu=1; hu < Palette_Hues; hu++)
  { ss = sh[hu] + lh[hu];
    if(hu == 1)
    { ss += sh[0];      // include the blacker greys in with the lighter greys
      sg = ss;
    }
    int ox = 0;
    int px = w-4;
    if(hu > 1)
    { ox += oh[hu]*(w-4)/sg;   // offset to equal grey level
      px -= ox + ph[hu]*(w-4)/sg;
    }
    int y1 = y+2 + ((h-4)*(hu-1))/(Palette_Hues-1);
    int y2 = y+1 + ((h-4)*(hu))/(Palette_Hues-1);
    for(int s = 0; s < ss && c < 256; s++ , c++)
    { int x1 = x + 2 + ox + s*px/ss;
      int x2 = x + 2 + ox + (s+1)*px/ss;
      if(highlight >= 256)
      { if(mouse_x >= x1 && mouse_x <= x2 && mouse_y >= y1 && mouse_y <= y2)
          return(c);
        else if(hu == 1 && mouse_x >= x1 && mouse_x <= x2)
          gc = c;  // match grey level if nothing else
      }
      else
      { if(c == highlight)  // naturally it won't if highlight < 0
        { hx1 = x1;   // can't do it now or it'd get swamped
          if(s == 0)
            hx1 += 2;
          hx2 = x2;
          if(s == ss - 1)
            hx2 -= 2;
          hy1 = y1;
          hy2 = y2;
        }
        int y3;
        if(hu == 1 && First_Draw)
          y3 = y + h - 2;   // make the greys fill the background
        else
          y3 = y2;
        rectfill(screen, x1,y1,x2,y3,palette_color[c]);
      }
    }
  }
  if(hx1 >= x)
  { rect(screen, hx1-2, hy1+1, hx2+2, hy2-1, gui_bg_color);
    rect(screen, hx1-1, hy1+2, hx2+1, hy2-2, gui_fg_color);
  }
  return(gc);
}

/* palette_proc - called from color_selector
 *  display the palette, and holds the index of the selected color in d1.
 *  w and h are ignored: the object is sized 132x132. supports D_EXIT.
 */
int Palette_proc(int msg, DIALOG* d, int cc)
{
    int x, y, ret = D_O_K;
    int c;

    switch(msg)
    {
    case MSG_START:
//      d->w = d->h = 132;
      First_Draw = TRUE;
      break;

    case MSG_DRAW:
      if(Palette_Hues)
        Display_Palette(d->x,d->y,d->w,d->h,d->d1);
      else
      { for(x=0; x<16; x++)
          for(y=0; y<16; y++)
            rectfill(screen, d->x+2 + x*8, d->y+2 + y*8, d->x+9 + x*8, d->y+9 + y*8, palette_color[x+16*y]);

        if(d->d1 >= 0) // highlight selected color
        {
          x = d->x+1 + 8*(d->d1%16);
          y = d->y+1 + 8*(d->d1/16);
          rect(screen, x+1, y+1, x+9, y+9, gui_bg_color);
          rect(screen, x,   y,   x+8, y+8, gui_fg_color);
        }
      }
      tdbox(screen, d->x, d->y, d->w-1, d->h-1, STL_IN|STL_FRAME);
      First_Draw = FALSE;
      break;

    case MSG_DCLICK:

      ret = D_CLOSE;
      // break;

    case MSG_CLICK:
      if(Palette_Hues)
        c = Display_Palette(d->x,d->y,d->w,d->h);
      else
      { x = (mouse_x - (d->x+1))/8;
        y = (mouse_y - (d->y+1))/8;
        c = x + y*16;
      }

      if(c < 256 && c != d->d1)
      {
        d->d1 = c;
        return D_REDRAWME | D_WANTFOCUS;
      }
      break;

    case MSG_WANTFOCUS:
      ret = D_WANTFOCUS;
  }

  return ret;
}


/* color selecter for the 'object properties' dialog */
int Color_Selecter(DIALOG *d)
{
    int c, res, r, g ,b;
    char red[20], green[20], blue[20], color[50];
    BITMAP *bkg;
    DIALOG_PLAYER *dlg_player;
    int xx = 0;
    if(Palette_Hues)
      xx = 128;

    DIALOG pal_dlg[] =
{
   /* (proc)            (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)               (dp2) (dp3) */
   { d_billwin_proc,    0,   0,   280+xx, 160, 0,   0,   0,    0,      0,   0,   (void*)" Select a color", NULL, NULL },
   { Palette_proc,      142, 22,  132+xx, 132, 0,   0,   0,    0,      -1,  0,   NULL,              NULL, NULL },
   { d_billtext_proc,   56,  32,  40,  8,   0,   0,   0,    0,      0,   0,   (void*)"Red",             NULL, NULL },
   { d_billedit_proc,   104, 32,  32,  12,  0,   0,   0,    0,      3,   0,   red,               NULL, NULL },
   { d_billtext_proc,   56,  48,  40,  8,   0,   0,   0,    0,      0,   0,   (void*)"Green",           NULL, NULL },
   { d_billedit_proc,   104, 48,  32,  12,  0,   0,   0,    0,      3,   0,   green,             NULL, NULL },
   { d_billtext_proc,   56,  64,  40,  8,   0,   0,   0,    0,      0,   0,   (void*)"Blue",            NULL, NULL },
   { d_billedit_proc,   104, 64,  32,  12,  0,   0,   0,    0,      3,   0,   blue,              NULL, NULL },
   { d_billtext_proc,   8,   88,  120, 8,   0,   0,   0,    0,      0,   0,   (void*)"Color number:",   NULL, NULL },
   { d_billedit_proc,   8,   104, 128, 12,  0,   0,   0,    0,      10,  0,   color,             NULL, NULL },
   { d_shadow_box_proc, 8,   32,  40,  40,  0,   0,   0,    0,      0,   0,   NULL,              NULL, NULL },
   { d_billbutton_proc, 8,   136, 56,  16,  0,   0,   13,   D_EXIT, 0,   0,   (void*)"OK",              NULL, NULL },
   { d_billbutton_proc, 72,  136, 64,  16,  0,   0,   27,   D_EXIT, 0,   0,   (void*)"Cancel",          NULL, NULL },
   { NULL,              0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,              NULL, NULL }
};

    // Initialize the dialog
    set_dialog_color(pal_dlg, gui_fg_color, gui_bg_color);
    centre_dialog(pal_dlg);
    dlg_player = init_dialog(pal_dlg, 10);
    if(Palette_Hues)
      pal_dlg[1].w = 260;   // for some reason size reverts to 132 otherwise
    

    bkg = create_bitmap(pal_dlg[0].w+1, pal_dlg[0].h+1); 
    scare_mouse();
    blit(screen, bkg, pal_dlg[0].x, pal_dlg[0].y, 0, 0, pal_dlg[0].w+1, pal_dlg[0].h+1);
    unscare_mouse();

    c = ustrtol((char*)d->dp, NULL, 0);
    usprintf(red,   "%d", getr(c));
    usprintf(green, "%d", getg(c));
    usprintf(blue,  "%d", getb(c));
    usprintf(color, "%d", c);
    pal_dlg[10].bg = c;

    if(_color_depth == 8)
      pal_dlg[1].d1 = c;

    // Do the dialog
    do
    {
      res = update_dialog(dlg_player);
      if(dlg_player->res)
      {
        switch(dlg_player->focus_obj)
        {
          case 1: // the palette
            c = palette_color[pal_dlg[1].d1];
            usprintf(red,   "%d", getr(c));
            usprintf(green, "%d", getg(c));
            usprintf(blue,  "%d", getb(c));
            usprintf(color, "%d", c);
            break;

          case 4:
          case 6: // the red, green, or blue edit
          case 8:
            r = ustrtol(red,   NULL, 0);
            g = ustrtol(green, NULL, 0);
            b = ustrtol(blue,  NULL, 0);
            c = makecol(r, g, b);
            usprintf(color, "%d", c);
            break;

          case 10: // the color number
            c = ustrtol(color, NULL, 10);
            if(_color_depth == 8 && (c>255 || c<0))
              c = 0;
            usprintf(red,   "%d", getr(c));
            usprintf(green, "%d", getg(c));
            usprintf(blue,  "%d", getb(c));
            break;
        }

        pal_dlg[10].bg = c;
        pal_dlg[ 3].flags |= D_DIRTY;
        pal_dlg[ 5].flags |= D_DIRTY;
        pal_dlg[ 7].flags |= D_DIRTY;
        pal_dlg[ 9].flags |= D_DIRTY;
        pal_dlg[10].flags |= D_DIRTY;
      }
    } while(res);

    res = shutdown_dialog(dlg_player);

    scare_mouse();
    blit(bkg, screen, 0, 0, pal_dlg[0].x, pal_dlg[0].y, pal_dlg[0].w+1, pal_dlg[0].h+1);
    unscare_mouse();
    destroy_bitmap(bkg);

    // Get data back from the dialog
    if(res == 11 || res == 1)
    { ustrcpy((char*)d->dp, color);
      if(d->dp3)
      { if(_color_depth == 8)
          *(int*)d->dp3 = c;
        else
          *(int*)d->dp3 = COL(c);
      }
    }

    return D_REDRAWME;
}

/* set the colors of the backup */
/*
int Color_Setter()
{
    int res;
    char fg[30], mg[30], bg[30];

    DIALOG col_dlg[] =
    {
       // (proc)            (x)  (y) (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)                (dp2)           (dp3)
       { d_billwin_proc,    0,   0,  232, 132, 16,  15,  0,    0,      0,   0,   (void*)" Set colors",      NULL,           NULL },
       { d_billtext_proc,   8,   40, 120, 8,   0,   0,   0,    0,      0,   0,   (void*)"Forground  color", NULL,           NULL },
       { Xedit_proc,        144, 36, 80,  16,  16,  15,  0,    0,      0,   0,   fg,                 Color_Selecter, (void*)&Back_fg },
       { d_billtext_proc,   8,   60, 120, 8,   16,  15,  0,    0,      0,   0,   (void*)"Midground  color", NULL,         NULL },
       { Xedit_proc,        144, 56, 80,  16,  16,  15,  0,    0,      0,   0,   mg,                 Color_Selecter, (void*)&Back_mg },
       { d_billtext_proc,   8,   80, 120, 8,   16,  15,  0,    0,      0,   0,   (void*)"Background color", NULL,           NULL },
       { Xedit_proc,        144, 76, 80,  16,  16,  15,  0,    0,      0,   0,   bg,                 Color_Selecter, (void*)&Back_bg },
       { d_billbutton_proc, 64, 108, 40,  16,  16,  15,  13,   D_EXIT, 0,   0,   (void*)"OK",               NULL,           NULL },
       { d_billbutton_proc, 108,108, 62,  16,  16,  15,  27,   D_EXIT, 0,   0,   (void*)"Cancel",           NULL,           NULL },
       { NULL,              0,   0,  0,   0,   0,   0,   0,    0,      0,   0,   NULL,               NULL,           NULL }
    };

    // Write data in the dialog
    if(_color_depth == 8)
    {
      usprintf(fg, "%d", Back_fg);
      usprintf(mg, "%d", Back_mg);
      usprintf(bg, "%d", Back_bg);
    }
    else
    {
      usprintf(fg, "%.06X", COL24(Back_fg));
      usprintf(mg, "%.06X", COL24(Back_mg));
      usprintf(bg, "%.06X", COL24(Back_bg));
    }

    // Do the dialog
    set_dialog_color(col_dlg, gui_fg_color, gui_bg_color);
    centre_dialog(col_dlg);
    res = popup_dialog(col_dlg, -1);

    // Read data back
    if(res == 7)    // OK
    {
      if(_color_depth == 8)
      {
        Back_fg  = ustrtol(fg, NULL, 0);
        Back_mg  = ustrtol(mg, NULL, 0);
        Back_bg  = ustrtol(bg, NULL, 0);
      }
      else
      {
        Back_fg = COL(ustrtol(fg, NULL, 16));
        Back_mg = COL(ustrtol(mg, NULL, 16));
        Back_bg = COL(ustrtol(bg, NULL, 16));
      }
    }

    return D_REDRAW;
}
*/

char* Ega_Color_Str[] = {"BLACK", "BLUE", "GREEN", "CYAN", "RED", "MAGENTA", "BROWN",
           "LIGHT_GREY","DARK_GREY", "LIGHT_BLUE", "LIGHT_GREEN", "LIGHT_CYAN", "LIGHT_RED",
           "LIGHT_MAGENTA","YELLOW","WHITE" };

int Ega_Color_Setter()
{
  return(Color_Setter(EGAColor,16,Ega_Color_Str,"egacolor"));
}

// As with GUI setter, the color shown in the Xedit_proc doesn't update until exit.
// This could be fixed with a little fiddling I think - any volunteers?

int Color_Setter(int* color, int colors, char** color_str, char* config_str)
{
    if(!color || !colors)
      return D_OK;
      
    int res;
    char* cg = new char[colors*30];
    int* tempcolor = new int[colors];
    char* def_str = NULL;
    if(!color_str)
      def_str = new char[20*colors];
    // Write data in the dialog
    int c;
    for(c= 0; c < colors; c++)
    { if(_color_depth == 8)
        usprintf(cg + c*30, "%d", color[c]);
      else
        usprintf(cg + c*30, "%.06X", COL24(color[c]));
      tempcolor[c] = color[c];
      if(def_str)
        usprintf(def_str + c*20,"Color %d", c);
    }

    int dialogs = colors*2+4;
    DIALOG* col_dlg = new DIALOG[dialogs];
    memset(col_dlg,0,sizeof(DIALOG)*dialogs);
    col_dlg[0].proc = d_billwin_proc;
    col_dlg[0].w = 232;
    col_dlg[0].h = colors*18+38;
    char title[80];
    strcpy(title,"Set ");
    if(config_str)
      strcat(title,config_str);
    strcat(title," Colors");
    col_dlg[0].dp = (void*)title;
    for(c = 0; c < colors; c++)
    { col_dlg[c*2+1].proc = d_billtext_proc;
      col_dlg[c*2+1].x = 8;
      col_dlg[c*2+1].y = 20 + c*18;
      col_dlg[c*2+1].w = 120;
      col_dlg[c*2+1].h = 8;
      if(color_str)
        col_dlg[c*2+1].dp = (void*)color_str[c];
      else
        col_dlg[c*2+1].dp = (void*)(def_str+c*20);
      col_dlg[c*2+2].proc = Xedit_proc;
      col_dlg[c*2+2].x = 144;
      col_dlg[c*2+2].y = 16 + c*18;
      col_dlg[c*2+2].w = 80;
      col_dlg[c*2+2].h = 16;
      col_dlg[c*2+2].dp = (void*)(cg+c*30);
      col_dlg[c*2+2].dp2 = Color_Selecter;
      col_dlg[c*2+2].dp3 = (void*)&tempcolor[c];
    }
    int okbutton = colors*2+1;
    for(c = okbutton; c < okbutton+2; c++)
    { col_dlg[c].proc = d_billbutton_proc;
      col_dlg[c].y = 20 + colors*18;
      col_dlg[c].h = 16;
      col_dlg[c].flags = D_EXIT;
    }
    col_dlg[okbutton].dp = (void*)"OK";
    col_dlg[okbutton+1].dp = (void*)"Cancel";
    col_dlg[okbutton].x = 64;
    col_dlg[okbutton+1].x = 108;
    col_dlg[okbutton].w = 40;
    col_dlg[okbutton+1].w = 62;

    // Do the dialog
    set_dialog_color(col_dlg, gui_fg_color, gui_bg_color);
    centre_dialog(col_dlg);
    res = popup_dialog(col_dlg, -1);

    // Read data back
    if(res == okbutton)    // OK
    { for(c = 0; c < colors; c++)
      { int col;
        if(_color_depth == 8)
          col = ustrtol(cg +c*30, NULL, 0);
        else
          col = COL(ustrtol(cg + c*30, NULL, 16));
        if(color_str && config_str && color[c] != col)   // a change was made
        { char str[80];
          strcpy(str,config_str);
          if(_color_depth == 8)
            strcat(str,"_8");
          set_config_int(config_str,color_str[c],col);
        }
        color[c] = col;
      }
    }
    
    delete tempcolor;
    if(def_str)
      delete def_str;
    delete cg;
    return(res == okbutton);
}

void Rainbow_Palette(PALETTE pal, int start)
{
  int h = 0;
  int c = start;
  while(c< 256 && (sh[h] || lh[h]))
  { int shade;
    for(int s = 0; s < sh[h] && c < 256; s++, c++)
    { shade = (fh[h]+s*(th[h]-fh[h])/(sh[h]-1))/4;
      pal[c].r = shade*rh[h]/255;
      pal[c].g = shade*gh[h]/255;
      pal[c].b = shade*bh[h]/255;
    }
    int rs = th[h]/4*rh[h]/255;
    int gs = th[h]/4*gh[h]/255;
    int bs = th[h]/4*bh[h]/255;
    if(gs > 60)
    { rs = rs + (63 - rs)/3;
      bs = bs + (63 - bs)/3;
    }
    for(int l = 1; l <= lh[h] && c < 256; l++, c++)
    { int shade = l*eh[h]/lh[h];
      pal[c].r = rs + (63-rs)*shade/255;
      pal[c].g = gs + (63-gs)*shade/255;
      pal[c].b = bs + (63-bs)*shade/255;
    }
    h++;
  }
  Palette_Hues = h;
}

void Init_EGAColors()
{
  for(int c = 0; c < 16; c++)
  { if(_color_depth == 8)
      EGAColor[c] = get_config_int("egacolor_8",Ega_Color_Str[c],EGAColor[c]);
    else
      EGAColor[c] = COL(get_config_int("egacolor",Ega_Color_Str[c],EGAColor[c]));
  }
}




