/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef VISUAL3DHPP
#define VISUAL3DHPP

#include <allegro.h>
#include "grid.h"
#include "alcolor.h"
#include "space.h"
#include "layers.h"
#include "axis.h"
#include "avi.h"

class CameraClass
{
/* parameters controlling the camera and projection state */
//  int viewport_w = 320;
//  int viewport_h = 240;
public:
  SpaceClass Sc;
  fixed FOV;
  fixed Aspect;
  MATRIX Matrix;
  CameraClass();
  void MakeMatrix();
};

struct BitmapBackgroundStruct
{
  fixed X,Y; // position of bit map onto 2D projected screen
  fixed W,H; // projected size
  fixed rX[2],rY[2],rW[2],rH[2];  // reference positions/size for AVI
  CameraClass Ref1Camera; // for frame Ref1
  CameraClass Ref2Camera; // for frame Ref2
  unsigned Frame, Ref1, Ref2, Frames;  // for AVI use
  char File_Name[80];
};

int IntLimit(long xl);  // usefull global function

class VisualClass
{
public:
  int ID;
  int X, Y;            // center of view
  fixed fX, fY;        // fixed equiv of X & Y
  int X1, Y1, X2, Y2;  // port to viewing bmp
  long Xa, Ya;    // virtual point of axis if in Isometric view
  int Xg, Yg;    // offset for grid calculated in SetView
  fixed Depth;   // set depth for flat to real conversion
  VTX Origin; // origin for this view
  CameraClass Camera;
  MATRIX TransMatrix;
  MATRIX RevMatrix;
  int Scale;  // eg. +ve is X:1 / -ve is 1:X
  bool Mode;  // 0 = Isometric, 1 = Perspective
  int Numeric; // see obj3ctrl.cpp::Summary()
  char Linked; // link group 1 or group 2
  long IncludeTypes, ShowTypes;
  
  BITMAP* Background_Buffer;
  BitmapBackgroundStruct BitmapBackground;
  bool Link_Background;
  bool Background_Visible;
  fixed Background_Fixed_Aspect;  // 0 is not fixed
  AVI_Struct AVI_Status;
  unsigned long AVI_Position;   // position in AVI in uSec
  unsigned long Frame_Advance;  // number uSec advance to previous or next for AVI

  bool Joystick_Enabled;
  long LastClock;
  bool Refresh;
  bool Render;        // uses the RenderMode in Render.cpp
  
  VisualClass();
  ~VisualClass();
  void SetView(int,int,int,int);
  int  Save(char*);
  int  Load(char*);
  void Set_Origin();
  void AxisSign(BITMAP*);
  void Reset_Bitmap_Pos();
  void Reset_Bitmap_Size();
  int  Load_Background(char*,int frame = 0);
  int Previous_Frame();
  int Next_Frame();
  void Unload_Background();
  void Get_Background_Corners(long &x1, long &y1, long &x2, long &y2);
  void Set_Background_Corners(long x1, long y1, long x2, long y2);
  void MakeTransMatrix();
  void MakeRevMatrix();
  int  Draw_Background(BITMAP*);
  void Draw(BITMAP*, bool = FALSE, VTX* = NULL);
  void Rect(BITMAP*,int);
  void SetDepth(VTX* vtx);
  void RealToFixed(VTX*,fixed&,fixed&,fixed&);
  void RealToFlat(VTX*,long&,long&,long&);
  void RealToFlat(VTX*,int&,int&,int&);
  void FlatToReal(VTX*,long,long);
  long RealToFlat(fixed,bool = false);
  fixed FlatToReal(long,bool=false);
  void Extremity(VTX*,VTX*);  // find the real extremites for this view
  void SetCamera(long,long);
  void CorrectScale();
  void In(long,long);
  void Out(long,long);
  void ScaleIn(int&,int&);
  void Pan(int,int);
  void Set(VisualClass*);
  bool Include(int, LayerClass*);
  bool Show(int, LayerClass*);
  int Inside(int,int,int);
  bool Animate();
};

extern VisualClass* Current_Visual;

#endif
