/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef VISUAL_LINK_3DHPP
#define VISUAL_LINK_3DHPP

#include "visulist.h"
#include "obj3ctrl.h"

class VisualList3DClass;  // predefine

class VisualLink3DClass : public VisualLinkClass
{
  friend VisualList3DClass;
  int Z, D;  // temporary values of on screen depth
public:
  VisualLink3DClass(ObjectClass*);
  bool Inside(int,int,int);
  bool Includes(int,int,int,int,int,int);
  virtual void Update();
  virtual void Draw(BITMAP*);   // nothing at present
};

class VisualList3DClass : public VisualListClass
{
public:
  VisualList3DClass();
  VisualLinkClass* Add(ObjectClass*, ObjectControlClass*, LinkClass* = NULL);
  virtual VisualLinkClass* CreateLink(ObjectClass* obj, ObjectControlClass* control);
  VisualLink3DClass* Add(ObjectControlClass*,int,int,int,int);
  /*
  VisualLinkClass* Add(ObjectClass*,ObjectControlClass*,LinkClass* = NULL);
  VisualLinkClass* Copy(VisualLinkClass*,LinkClass* = NULL);
  VisualLinkClass* Find_Mouse_Object();
  VisualLinkClass* Add(VisualLinkClass*);  // sort of a copy function
  int  Drag_Move(VisualLinkClass*,int,int);
  int  Drag_Select(void);
  void Xor_Indicate_Selected(void);
  int  Snap_Selected(void);
  void Indicate_Selected(BITMAP* bmp, int = 0, int = 255);
  void Draw_All(BITMAP* bmp);
  long Load(FILE*);
  void Save(PACKFILE*);
  */
  virtual void Update();
  virtual VisualLinkClass* Find_Mouse_Object();
  virtual VisualLinkClass* Find_Object(int x, int y);
};

#define BEGIN_3D_LIST target = (VisualLink3DClass*)Target3DList->FirstLink(); \
                         while(target) {
#define END_3D_LIST   target = (VisualLink3DClass*)(target->NextLink()); }

extern VisualList3DClass* Target3DList;

#endif
